/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.api;

import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.LdapPrincipal;
import org.apache.directory.server.core.api.changelog.LogChange;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.model.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.model.entry.Entry;
import org.apache.directory.shared.ldap.model.entry.Modification;
import org.apache.directory.shared.ldap.model.exception.LdapException;
import org.apache.directory.shared.ldap.model.filter.ExprNode;
import org.apache.directory.shared.ldap.model.message.AddRequest;
import org.apache.directory.shared.ldap.model.message.AliasDerefMode;
import org.apache.directory.shared.ldap.model.message.CompareRequest;
import org.apache.directory.shared.ldap.model.message.Control;
import org.apache.directory.shared.ldap.model.message.DeleteRequest;
import org.apache.directory.shared.ldap.model.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.model.message.ModifyRequest;
import org.apache.directory.shared.ldap.model.message.SearchRequest;
import org.apache.directory.shared.ldap.model.message.SearchScope;
import org.apache.directory.shared.ldap.model.message.UnbindRequest;
import org.apache.directory.shared.ldap.model.name.Dn;
import org.apache.directory.shared.ldap.model.name.Rdn;
import org.apache.directory.shared.ldap.model.schema.AttributeTypeOptions;

public interface CoreSession {
    public DirectoryService getDirectoryService();

    public LdapPrincipal getAnonymousPrincipal();

    public LdapPrincipal getAuthenticatedPrincipal();

    public LdapPrincipal getEffectivePrincipal();

    public boolean isConfidential();

    public boolean isAnonymous();

    public boolean isAdministrator();

    public boolean isAnAdministrator();

    public AuthenticationLevel getAuthenticationLevel();

    public Set<Control> getControls();

    public Set<OperationContext> getOutstandingOperations();

    public boolean isVirtual();

    public SocketAddress getClientAddress();

    public SocketAddress getServiceAddress();

    public void add(Entry var1) throws LdapException;

    public void add(Entry var1, LogChange var2) throws LdapException;

    public void add(Entry var1, boolean var2) throws LdapException;

    public void add(Entry var1, boolean var2, LogChange var3) throws LdapException;

    public void add(AddRequest var1) throws LdapException;

    public void add(AddRequest var1, LogChange var2) throws LdapException;

    public boolean compare(Dn var1, String var2, Object var3) throws LdapException;

    public boolean compare(Dn var1, String var2, Object var3, boolean var4) throws LdapException;

    public boolean compare(CompareRequest var1) throws LdapException;

    public void delete(Dn var1) throws LdapException;

    public void delete(Dn var1, LogChange var2) throws LdapException;

    public void delete(DeleteRequest var1) throws LdapException;

    public void delete(DeleteRequest var1, LogChange var2) throws LdapException;

    public void delete(Dn var1, boolean var2) throws LdapException;

    public void delete(Dn var1, boolean var2, LogChange var3) throws LdapException;

    public boolean exists(String var1) throws LdapException;

    public boolean exists(Dn var1) throws LdapException;

    public Entry lookup(Dn var1) throws LdapException;

    public Entry lookup(Dn var1, String ... var2) throws LdapException;

    public Entry lookup(Dn var1, Control[] var2, String ... var3) throws LdapException;

    public void modify(Dn var1, List<Modification> var2) throws LdapException;

    public void modify(Dn var1, Modification ... var2) throws LdapException;

    public void modify(Dn var1, List<Modification> var2, LogChange var3) throws LdapException;

    public void modify(Dn var1, List<Modification> var2, boolean var3) throws LdapException;

    public void modify(Dn var1, List<Modification> var2, boolean var3, LogChange var4) throws LdapException;

    public void modify(ModifyRequest var1) throws LdapException;

    public void modify(ModifyRequest var1, LogChange var2) throws LdapException;

    public void move(Dn var1, Dn var2) throws LdapException;

    public void move(Dn var1, Dn var2, LogChange var3) throws LdapException;

    public void move(Dn var1, Dn var2, boolean var3) throws Exception;

    public void move(Dn var1, Dn var2, boolean var3, LogChange var4) throws LdapException;

    public void move(ModifyDnRequest var1) throws LdapException;

    public void move(ModifyDnRequest var1, LogChange var2) throws LdapException;

    public void moveAndRename(Dn var1, Dn var2, Rdn var3, boolean var4) throws LdapException;

    public void moveAndRename(Dn var1, Dn var2, Rdn var3, boolean var4, LogChange var5) throws LdapException;

    public void moveAndRename(Dn var1, Dn var2, Rdn var3, boolean var4, boolean var5) throws LdapException;

    public void moveAndRename(Dn var1, Dn var2, Rdn var3, boolean var4, boolean var5, LogChange var6) throws LdapException;

    public void moveAndRename(ModifyDnRequest var1) throws LdapException;

    public void moveAndRename(ModifyDnRequest var1, LogChange var2) throws LdapException;

    public void rename(Dn var1, Rdn var2, boolean var3) throws LdapException;

    public void rename(Dn var1, Rdn var2, boolean var3, LogChange var4) throws LdapException;

    public void rename(Dn var1, Rdn var2, boolean var3, boolean var4) throws LdapException;

    public void rename(Dn var1, Rdn var2, boolean var3, boolean var4, LogChange var5) throws LdapException;

    public void rename(ModifyDnRequest var1) throws LdapException;

    public void rename(ModifyDnRequest var1, LogChange var2) throws LdapException;

    public EntryFilteringCursor list(Dn var1, AliasDerefMode var2, Set<AttributeTypeOptions> var3) throws LdapException;

    public EntryFilteringCursor list(Dn var1, AliasDerefMode var2, Set<AttributeTypeOptions> var3, long var4, int var6) throws LdapException;

    public EntryFilteringCursor search(Dn var1, String var2) throws LdapException;

    public EntryFilteringCursor search(Dn var1, String var2, boolean var3) throws LdapException;

    public EntryFilteringCursor search(Dn var1, SearchScope var2, ExprNode var3, AliasDerefMode var4, Set<AttributeTypeOptions> var5) throws LdapException;

    public EntryFilteringCursor search(Dn var1, SearchScope var2, ExprNode var3, AliasDerefMode var4, Set<AttributeTypeOptions> var5, long var6, int var8) throws LdapException;

    public EntryFilteringCursor search(SearchRequest var1) throws LdapException;

    public void unbind() throws LdapException;

    public void unbind(UnbindRequest var1) throws LdapException;
}

