/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.request;

import org.apache.directory.api.ldap.model.message.CompareRequest;
import org.apache.directory.api.ldap.model.message.LdapResult;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompareRequestHandler
extends LdapRequestHandler<CompareRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(CompareRequestHandler.class);

    @Override
    public void handle(LdapSession session, CompareRequest req) {
        LOG.debug("Handling compare request while ignoring referrals: {}", (Object)req);
        LdapResult result = req.getResultResponse().getLdapResult();
        try {
            if (session.getCoreSession().compare(req)) {
                result.setResultCode(ResultCodeEnum.COMPARE_TRUE);
            } else {
                result.setResultCode(ResultCodeEnum.COMPARE_FALSE);
            }
            result.setMatchedDn(req.getName());
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

