/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.message;

import org.apache.directory.api.ldap.model.message.AbstractResponse;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.Referral;
import org.apache.directory.api.ldap.model.message.ReferralImpl;
import org.apache.directory.api.ldap.model.message.SearchResultReference;

public class SearchResultReferenceImpl
extends AbstractResponse
implements SearchResultReference {
    static final long serialVersionUID = 7423807019951309810L;
    private Referral referral = new ReferralImpl();

    public SearchResultReferenceImpl() {
        super(-1, MessageTypeEnum.SEARCH_RESULT_REFERENCE);
    }

    public SearchResultReferenceImpl(int id) {
        super(id, MessageTypeEnum.SEARCH_RESULT_REFERENCE);
    }

    @Override
    public Referral getReferral() {
        return this.referral;
    }

    @Override
    public void setReferral(Referral referral) {
        this.referral = referral;
    }

    @Override
    public int hashCode() {
        int hash = 37;
        if (this.referral != null) {
            hash = hash * 17 + this.referral.hashCode();
        }
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        SearchResultReference resp = (SearchResultReference)obj;
        if (this.referral != null && resp.getReferral() == null) {
            return false;
        }
        if (this.referral == null && resp.getReferral() != null) {
            return false;
        }
        return this.referral == null || resp.getReferral() == null || this.referral.equals(resp.getReferral());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Search Result Reference\n");
        if (this.referral == null || this.referral.getLdapUrls() == null || this.referral.getLdapUrls().size() == 0) {
            sb.append("        No Reference\n");
        } else {
            sb.append("        References\n");
            for (String url : this.referral.getLdapUrls()) {
                sb.append("            '").append(url).append("'\n");
            }
        }
        return super.toString(sb.toString());
    }
}

