/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.aci;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import org.apache.directory.api.ldap.aci.ACIItem;
import org.apache.directory.api.ldap.aci.ACITuple;
import org.apache.directory.api.ldap.aci.GrantAndDenial;
import org.apache.directory.api.ldap.aci.UserClass;
import org.apache.directory.api.ldap.aci.UserPermission;
import org.apache.directory.api.ldap.model.constants.AuthenticationLevel;

public class UserFirstACIItem
extends ACIItem {
    private final Collection<UserClass> userClasses;
    private final Collection<UserPermission> userPermissions;

    public UserFirstACIItem(String identificationTag, int precedence, AuthenticationLevel authenticationLevel, Collection<UserClass> userClasses, Collection<UserPermission> userPermissions) {
        super(identificationTag, precedence, authenticationLevel);
        this.userClasses = Collections.unmodifiableCollection(new ArrayList<UserClass>(userClasses));
        this.userPermissions = Collections.unmodifiableCollection(new ArrayList<UserPermission>(userPermissions));
    }

    public Collection<UserClass> getUserClasses() {
        return this.userClasses;
    }

    public Collection<UserPermission> getUserPermission() {
        return this.userPermissions;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("{ identificationTag \"");
        buf.append(this.getIdentificationTag());
        buf.append("\", ");
        buf.append("precedence ");
        buf.append(this.getPrecedence());
        buf.append(", ");
        buf.append("authenticationLevel ");
        buf.append(this.getAuthenticationLevel().getName());
        buf.append(", ");
        buf.append("itemOrUserFirst userFirst: { ");
        buf.append("userClasses { ");
        boolean isFirst = true;
        for (UserClass userClass : this.userClasses) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(userClass.toString());
        }
        buf.append(" }, ");
        buf.append("userPermissions { ");
        isFirst = true;
        for (UserPermission permission : this.userPermissions) {
            if (isFirst) {
                isFirst = false;
            } else {
                buf.append(", ");
            }
            buf.append(permission.toString());
        }
        buf.append(" } } }");
        return buf.toString();
    }

    @Override
    public Collection<ACITuple> toTuples() {
        ArrayList<ACITuple> tuples = new ArrayList<ACITuple>();
        for (UserPermission userPermission : this.userPermissions) {
            int precedence;
            Set<GrantAndDenial> grants = userPermission.getGrants();
            Set<GrantAndDenial> denials = userPermission.getDenials();
            int n = precedence = userPermission.getPrecedence() != null ? userPermission.getPrecedence().intValue() : this.getPrecedence();
            if (grants.size() > 0) {
                tuples.add(new ACITuple(this.getUserClasses(), this.getAuthenticationLevel(), userPermission.getProtectedItems(), UserFirstACIItem.toMicroOperations(grants), true, precedence));
            }
            if (denials.size() <= 0) continue;
            tuples.add(new ACITuple(this.getUserClasses(), this.getAuthenticationLevel(), userPermission.getProtectedItems(), UserFirstACIItem.toMicroOperations(denials), false, precedence));
        }
        return tuples;
    }
}

