/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.api.ldap.model.constants.Loggers;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.cursor.InvalidCursorPositionException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.impl.ScanCountComparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AndCursor<V>
extends AbstractIndexCursor<V> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger(Loggers.CURSOR_LOG.getName());
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_707, new Object[0]);
    private final Cursor<IndexEntry<V, String>> wrapped;
    private final List<Evaluator<? extends ExprNode>> evaluators;

    public AndCursor(Cursor<IndexEntry<V, String>> wrapped, List<Evaluator<? extends ExprNode>> evaluators) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating AndCursor {}", (Object)this);
        }
        this.wrapped = wrapped;
        this.evaluators = this.optimize(evaluators);
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException {
        this.checkNotClosed("beforeFirst()");
        this.wrapped.beforeFirst();
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws LdapException, CursorException {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.setAvailable(false);
    }

    @Override
    public boolean first() throws LdapException, CursorException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws LdapException, CursorException {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry<V, String> candidate = this.wrapped.get();
            if (!this.matches(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public boolean next() throws LdapException, CursorException {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry<V, String> candidate = this.wrapped.get();
            if (!this.matches(candidate)) continue;
            return this.setAvailable(true);
        }
        return this.setAvailable(false);
    }

    @Override
    public IndexEntry<V, String> get() throws CursorException {
        this.checkNotClosed("get()");
        if (this.available()) {
            return this.wrapped.get();
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AndCursor {}", (Object)this);
        }
        super.close();
        this.wrapped.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing AndCursor {}", (Object)this);
        }
        super.close(cause);
        this.wrapped.close(cause);
    }

    private List<Evaluator<? extends ExprNode>> optimize(List<Evaluator<? extends ExprNode>> unoptimized) {
        ArrayList<Evaluator<? extends ExprNode>> optimized = new ArrayList<Evaluator<? extends ExprNode>>(unoptimized.size());
        optimized.addAll(unoptimized);
        Collections.sort(optimized, new ScanCountComparator());
        return optimized;
    }

    private boolean matches(IndexEntry<V, String> indexEntry) throws LdapException {
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            if (evaluator.evaluate(indexEntry)) continue;
            return false;
        }
        return true;
    }

    private String dumpEvaluators(String tabs) {
        StringBuilder sb = new StringBuilder();
        for (Evaluator<? extends ExprNode> evaluator : this.evaluators) {
            sb.append(evaluator.toString(tabs + "  >>"));
        }
        return sb.toString();
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("AndCursor (");
        if (this.available()) {
            sb.append("available) :\n");
        } else {
            sb.append("absent) :\n");
        }
        if (this.evaluators != null && this.evaluators.size() > 0) {
            sb.append(this.dumpEvaluators(tabs));
        }
        sb.append(this.wrapped.toString(tabs + "  "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

