/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.decorators;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.EncoderException;
import org.apache.directory.api.asn1.ber.Asn1Container;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.AttributeValueAssertion;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.api.MessageDecorator;
import org.apache.directory.api.ldap.codec.search.AndFilter;
import org.apache.directory.api.ldap.codec.search.AttributeValueAssertionFilter;
import org.apache.directory.api.ldap.codec.search.ConnectorFilter;
import org.apache.directory.api.ldap.codec.search.ExtensibleMatchFilter;
import org.apache.directory.api.ldap.codec.search.Filter;
import org.apache.directory.api.ldap.codec.search.NotFilter;
import org.apache.directory.api.ldap.codec.search.OrFilter;
import org.apache.directory.api.ldap.codec.search.PresentFilter;
import org.apache.directory.api.ldap.codec.search.SubstringFilter;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.ApproximateNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.BranchNormalizedVisitor;
import org.apache.directory.api.ldap.model.filter.EqualityNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ExtensibleNode;
import org.apache.directory.api.ldap.model.filter.GreaterEqNode;
import org.apache.directory.api.ldap.model.filter.LeafNode;
import org.apache.directory.api.ldap.model.filter.LessEqNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.filter.SimpleNode;
import org.apache.directory.api.ldap.model.filter.SubstringNode;
import org.apache.directory.api.ldap.model.message.AbandonListener;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.MessageTypeEnum;
import org.apache.directory.api.ldap.model.message.SearchRequest;
import org.apache.directory.api.ldap.model.message.SearchResultDone;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.util.Strings;

public class SearchRequestDecorator
extends MessageDecorator<SearchRequest>
implements SearchRequest {
    private int searchRequestLength;
    private int attributeDescriptionListLength;
    private Filter terminalFilter;
    private Filter currentFilter;
    private Filter topFilter;
    private int tlvId;
    private byte[] dnBytes;

    public SearchRequestDecorator(LdapApiService codec, SearchRequest decoratedMessage) {
        super(codec, decoratedMessage);
    }

    public void setSearchRequestLength(int searchRequestLength) {
        this.searchRequestLength = searchRequestLength;
    }

    public int getSearchRequestLength() {
        return this.searchRequestLength;
    }

    public void setAttributeDescriptionListLength(int attributeDescriptionListLength) {
        this.attributeDescriptionListLength = attributeDescriptionListLength;
    }

    public int getAttributeDescriptionListLength() {
        return this.attributeDescriptionListLength;
    }

    public void setTlvId(int tlvId) {
        this.tlvId = tlvId;
    }

    public Filter getCurrentFilter() {
        return this.currentFilter;
    }

    public Filter getCodecFilter() {
        return this.topFilter;
    }

    public ExprNode getFilterNode() {
        return this.transform(this.topFilter);
    }

    public Filter getTerminalFilter() {
        return this.terminalFilter;
    }

    public void setTerminalFilter(Filter terminalFilter) {
        this.terminalFilter = terminalFilter;
    }

    @Override
    public SearchRequest setFilter(ExprNode filter) {
        this.topFilter = SearchRequestDecorator.transform(filter);
        return this;
    }

    @Override
    public SearchRequest setFilter(String filter) throws LdapException {
        ((SearchRequest)this.getDecorated()).setFilter(filter);
        this.currentFilter = SearchRequestDecorator.transform(((SearchRequest)this.getDecorated()).getFilter());
        return this;
    }

    public void setCurrentFilter(Filter filter) {
        this.currentFilter = filter;
    }

    public void addCurrentFilter(Filter localFilter) throws DecoderException {
        if (this.currentFilter != null) {
            ((ConnectorFilter)this.currentFilter).addFilter(localFilter);
            localFilter.setParent(this.currentFilter, this.currentFilter.getTlvId());
            if (localFilter instanceof ConnectorFilter) {
                this.currentFilter = localFilter;
            }
        } else {
            this.currentFilter = localFilter;
            this.currentFilter.setParent(null, this.tlvId);
            this.topFilter = localFilter;
        }
    }

    public void unstackFilters(Asn1Container container) {
        LdapMessageContainer ldapMessageContainer = (LdapMessageContainer)container;
        TLV tlv = ldapMessageContainer.getCurrentTLV();
        TLV localParent = tlv.getParent();
        Filter localFilter = this.terminalFilter;
        while (localParent != null && localParent.getExpectedLength() == 0) {
            int parentTlvId;
            int n = parentTlvId = localFilter.getParent() != null ? localFilter.getParent().getTlvId() : localFilter.getParentTlvId();
            if (localParent.getId() != parentTlvId) {
                localParent = localParent.getParent();
                continue;
            }
            Filter filterParent = localFilter.getParent();
            if (localFilter instanceof PresentFilter) {
                if (filterParent == null) break;
                filterParent = filterParent.getParent();
            } else if (filterParent instanceof Filter) {
                filterParent = filterParent.getParent();
            }
            if (!(filterParent instanceof Filter)) break;
            localFilter = this.currentFilter;
            this.currentFilter = filterParent;
            localParent = localParent.getParent();
        }
    }

    private ExprNode transform(Filter filter) {
        if (filter != null) {
            if (filter instanceof ConnectorFilter) {
                BranchNode branch = null;
                if (filter instanceof AndFilter) {
                    branch = new AndNode();
                } else if (filter instanceof OrFilter) {
                    branch = new OrNode();
                } else if (filter instanceof NotFilter) {
                    branch = new NotNode();
                }
                List<Filter> filtersSet = ((ConnectorFilter)filter).getFilterSet();
                if (filtersSet != null) {
                    for (Filter node : filtersSet) {
                        branch.addNode(this.transform(node));
                    }
                }
                return branch;
            }
            LeafNode branch = null;
            if (filter instanceof PresentFilter) {
                branch = new PresenceNode(((PresentFilter)filter).getAttributeDescription());
            } else if (filter instanceof AttributeValueAssertionFilter) {
                AttributeValueAssertion ava = ((AttributeValueAssertionFilter)filter).getAssertion();
                switch (((AttributeValueAssertionFilter)filter).getFilterType()) {
                    case 0: {
                        branch = new EqualityNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 1: {
                        branch = new GreaterEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 2: {
                        branch = new LessEqNode(ava.getAttributeDesc(), ava.getAssertionValue());
                        break;
                    }
                    case 3: {
                        branch = new ApproximateNode(ava.getAttributeDesc(), ava.getAssertionValue());
                    }
                }
            } else if (filter instanceof SubstringFilter) {
                SubstringFilter substrFilter = (SubstringFilter)filter;
                String initialString = null;
                String finalString = null;
                ArrayList<String> anyString = null;
                if (substrFilter.getInitialSubstrings() != null) {
                    initialString = substrFilter.getInitialSubstrings();
                }
                if (substrFilter.getFinalSubstrings() != null) {
                    finalString = substrFilter.getFinalSubstrings();
                }
                if (substrFilter.getAnySubstrings() != null) {
                    anyString = new ArrayList<String>();
                    for (String any : substrFilter.getAnySubstrings()) {
                        anyString.add(any);
                    }
                }
                branch = new SubstringNode(anyString, substrFilter.getType(), initialString, finalString);
            } else if (filter instanceof ExtensibleMatchFilter) {
                ExtensibleMatchFilter extFilter = (ExtensibleMatchFilter)filter;
                String matchingRule = null;
                Value<?> value = extFilter.getMatchValue();
                if (extFilter.getMatchingRule() != null) {
                    matchingRule = extFilter.getMatchingRule();
                }
                branch = new ExtensibleNode(extFilter.getType(), value, matchingRule, extFilter.isDnAttributes());
            }
            return branch;
        }
        return null;
    }

    private static Filter transform(ExprNode exprNode) {
        if (exprNode != null) {
            Filter filter = null;
            if (exprNode instanceof BranchNode) {
                if (exprNode instanceof AndNode) {
                    filter = new AndFilter();
                } else if (exprNode instanceof OrNode) {
                    filter = new OrFilter();
                } else if (exprNode instanceof NotNode) {
                    filter = new NotFilter();
                }
                List<ExprNode> children = ((BranchNode)exprNode).getChildren();
                if (children != null) {
                    for (ExprNode child : children) {
                        try {
                            ((ConnectorFilter)filter).addFilter(SearchRequestDecorator.transform(child));
                        }
                        catch (DecoderException de) {
                            return null;
                        }
                    }
                }
            } else if (exprNode instanceof PresenceNode) {
                filter = new PresentFilter();
                ((PresentFilter)filter).setAttributeDescription(((PresenceNode)exprNode).getAttribute());
            } else if (exprNode instanceof SimpleNode) {
                if (exprNode instanceof EqualityNode) {
                    filter = new AttributeValueAssertionFilter(0);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((EqualityNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((EqualityNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof GreaterEqNode) {
                    filter = new AttributeValueAssertionFilter(1);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((GreaterEqNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((GreaterEqNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof LessEqNode) {
                    filter = new AttributeValueAssertionFilter(2);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((LessEqNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((LessEqNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                } else if (exprNode instanceof ApproximateNode) {
                    filter = new AttributeValueAssertionFilter(3);
                    AttributeValueAssertion assertion = new AttributeValueAssertion();
                    assertion.setAttributeDesc(((ApproximateNode)exprNode).getAttribute());
                    assertion.setAssertionValue(((ApproximateNode)exprNode).getValue());
                    ((AttributeValueAssertionFilter)filter).setAssertion(assertion);
                }
            } else if (exprNode instanceof SubstringNode) {
                filter = new SubstringFilter();
                ((SubstringFilter)filter).setType(((SubstringNode)exprNode).getAttribute());
                String initialString = ((SubstringNode)exprNode).getInitial();
                String finalString = ((SubstringNode)exprNode).getFinal();
                List<String> anyStrings = ((SubstringNode)exprNode).getAny();
                if (initialString != null) {
                    ((SubstringFilter)filter).setInitialSubstrings(initialString);
                }
                if (finalString != null) {
                    ((SubstringFilter)filter).setFinalSubstrings(finalString);
                }
                if (anyStrings != null) {
                    for (String any : anyStrings) {
                        ((SubstringFilter)filter).addAnySubstrings(any);
                    }
                }
            } else if (exprNode instanceof ExtensibleNode) {
                filter = new ExtensibleMatchFilter();
                String attribute = ((ExtensibleNode)exprNode).getAttribute();
                String matchingRule = ((ExtensibleNode)exprNode).getMatchingRuleId();
                boolean dnAttributes = ((ExtensibleNode)exprNode).hasDnAttributes();
                Value<?> value = ((ExtensibleNode)exprNode).getValue();
                if (attribute != null) {
                    ((ExtensibleMatchFilter)filter).setType(attribute);
                }
                if (matchingRule != null) {
                    ((ExtensibleMatchFilter)filter).setMatchingRule(matchingRule);
                }
                ((ExtensibleMatchFilter)filter).setMatchValue(value);
                ((ExtensibleMatchFilter)filter).setDnAttributes(dnAttributes);
            }
            return filter;
        }
        return null;
    }

    public int hashCode() {
        int hash = 37;
        if (((SearchRequest)this.getDecorated()).getBase() != null) {
            hash = hash * 17 + ((SearchRequest)this.getDecorated()).getBase().hashCode();
        }
        hash = hash * 17 + ((SearchRequest)this.getDecorated()).getDerefAliases().hashCode();
        hash = hash * 17 + ((SearchRequest)this.getDecorated()).getScope().hashCode();
        hash = hash * 17 + Long.valueOf(((SearchRequest)this.getDecorated()).getSizeLimit()).hashCode();
        hash = hash * 17 + ((SearchRequest)this.getDecorated()).getTimeLimit();
        hash = hash * 17 + (((SearchRequest)this.getDecorated()).getTypesOnly() ? 0 : 1);
        List<String> attributes = ((SearchRequest)this.getDecorated()).getAttributes();
        if (attributes != null) {
            hash = hash * 17 + attributes.size();
            for (String attr : attributes) {
                hash += attr.hashCode();
            }
        }
        BranchNormalizedVisitor visitor = new BranchNormalizedVisitor();
        ((SearchRequest)this.getDecorated()).getFilter().accept(visitor);
        hash = hash * 17 + this.currentFilter.toString().hashCode();
        hash = hash * 17 + super.hashCode();
        return hash;
    }

    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (o == null || o instanceof SearchRequestDecorator) {
            return false;
        }
        SearchRequestDecorator otherSearchRequestDecorator = (SearchRequestDecorator)o;
        if (this.getDecorated() != null && !((SearchRequest)this.getDecorated()).equals(otherSearchRequestDecorator.getDecorated())) {
            return false;
        }
        if (this.searchRequestLength != otherSearchRequestDecorator.searchRequestLength) {
            return false;
        }
        if (this.attributeDescriptionListLength != otherSearchRequestDecorator.attributeDescriptionListLength) {
            return false;
        }
        if (this.terminalFilter != null && this.terminalFilter.equals(otherSearchRequestDecorator.terminalFilter)) {
            return false;
        }
        if (this.currentFilter != null && this.currentFilter.equals(otherSearchRequestDecorator.currentFilter)) {
            return false;
        }
        if (this.topFilter != null && this.topFilter.equals(otherSearchRequestDecorator.topFilter)) {
            return false;
        }
        return this.tlvId == otherSearchRequestDecorator.tlvId;
    }

    @Override
    public MessageTypeEnum[] getResponseTypes() {
        return ((SearchRequest)this.getDecorated()).getResponseTypes();
    }

    @Override
    public Dn getBase() {
        return ((SearchRequest)this.getDecorated()).getBase();
    }

    @Override
    public SearchRequest setBase(Dn baseDn) {
        ((SearchRequest)this.getDecorated()).setBase(baseDn);
        return this;
    }

    @Override
    public SearchScope getScope() {
        return ((SearchRequest)this.getDecorated()).getScope();
    }

    @Override
    public SearchRequest setScope(SearchScope scope) {
        ((SearchRequest)this.getDecorated()).setScope(scope);
        return this;
    }

    @Override
    public AliasDerefMode getDerefAliases() {
        return ((SearchRequest)this.getDecorated()).getDerefAliases();
    }

    @Override
    public SearchRequest setDerefAliases(AliasDerefMode aliasDerefAliases) {
        ((SearchRequest)this.getDecorated()).setDerefAliases(aliasDerefAliases);
        return this;
    }

    @Override
    public long getSizeLimit() {
        return ((SearchRequest)this.getDecorated()).getSizeLimit();
    }

    @Override
    public SearchRequest setSizeLimit(long entriesMax) {
        ((SearchRequest)this.getDecorated()).setSizeLimit(entriesMax);
        return this;
    }

    @Override
    public int getTimeLimit() {
        return ((SearchRequest)this.getDecorated()).getTimeLimit();
    }

    @Override
    public SearchRequest setTimeLimit(int secondsMax) {
        ((SearchRequest)this.getDecorated()).setTimeLimit(secondsMax);
        return this;
    }

    @Override
    public boolean getTypesOnly() {
        return ((SearchRequest)this.getDecorated()).getTypesOnly();
    }

    @Override
    public SearchRequest setTypesOnly(boolean typesOnly) {
        ((SearchRequest)this.getDecorated()).setTypesOnly(typesOnly);
        return this;
    }

    @Override
    public ExprNode getFilter() {
        return ((SearchRequest)this.getDecorated()).getFilter();
    }

    @Override
    public List<String> getAttributes() {
        return ((SearchRequest)this.getDecorated()).getAttributes();
    }

    @Override
    public SearchRequest addAttributes(String ... attributes) {
        ((SearchRequest)this.getDecorated()).addAttributes(attributes);
        return this;
    }

    @Override
    public SearchRequest removeAttribute(String attribute) {
        ((SearchRequest)this.getDecorated()).removeAttribute(attribute);
        return this;
    }

    @Override
    public int computeLength() {
        int searchRequestLength = 0;
        this.dnBytes = Strings.getBytesUtf8(this.getBase().getName());
        searchRequestLength += 1 + TLV.getNbBytes(this.dnBytes.length) + this.dnBytes.length;
        searchRequestLength += 3;
        searchRequestLength += 3;
        searchRequestLength += 2 + BerValue.getNbBytes(this.getSizeLimit());
        searchRequestLength += 2 + BerValue.getNbBytes(this.getTimeLimit());
        searchRequestLength += 3;
        this.setFilter(this.getFilter());
        searchRequestLength += this.getCodecFilter().computeLength();
        int attributeDescriptionListLength = 0;
        if (this.getAttributes() != null && this.getAttributes().size() != 0) {
            for (String attribute : this.getAttributes()) {
                int idLength = Strings.getBytesUtf8(attribute).length;
                attributeDescriptionListLength += 1 + TLV.getNbBytes(idLength) + idLength;
            }
        }
        this.setAttributeDescriptionListLength(attributeDescriptionListLength);
        this.setSearchRequestLength(searchRequestLength += 1 + TLV.getNbBytes(attributeDescriptionListLength) + attributeDescriptionListLength);
        return 1 + TLV.getNbBytes(searchRequestLength) + searchRequestLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        try {
            buffer.put((byte)99);
            buffer.put(TLV.getBytes(this.getSearchRequestLength()));
            BerValue.encode(buffer, this.dnBytes);
            BerValue.encodeEnumerated(buffer, this.getScope().getScope());
            BerValue.encodeEnumerated(buffer, this.getDerefAliases().getValue());
            BerValue.encode(buffer, this.getSizeLimit());
            BerValue.encode(buffer, this.getTimeLimit());
            BerValue.encode(buffer, this.getTypesOnly());
            this.getCodecFilter().encode(buffer);
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes(this.getAttributeDescriptionListLength()));
            if (this.getAttributes() != null && this.getAttributes().size() != 0) {
                for (String attribute : this.getAttributes()) {
                    BerValue.encode(buffer, attribute);
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException(I18n.err(I18n.ERR_04005, new Object[0]));
        }
        return buffer;
    }

    @Override
    public SearchResultDone getResultResponse() {
        return (SearchResultDone)((SearchRequest)this.getDecorated()).getResultResponse();
    }

    @Override
    public boolean hasResponse() {
        return ((SearchRequest)this.getDecorated()).hasResponse();
    }

    @Override
    public void abandon() {
        ((SearchRequest)this.getDecorated()).abandon();
    }

    @Override
    public boolean isAbandoned() {
        return ((SearchRequest)this.getDecorated()).isAbandoned();
    }

    @Override
    public SearchRequest addAbandonListener(AbandonListener listener) {
        ((SearchRequest)this.getDecorated()).addAbandonListener(listener);
        return this;
    }

    @Override
    public SearchRequest setMessageId(int messageId) {
        return (SearchRequest)super.setMessageId(messageId);
    }

    @Override
    public SearchRequest addControl(Control control) {
        return (SearchRequest)super.addControl(control);
    }

    @Override
    public SearchRequest addAllControls(Control[] controls) {
        return (SearchRequest)super.addAllControls(controls);
    }

    @Override
    public SearchRequest removeControl(Control control) {
        return (SearchRequest)super.removeControl(control);
    }

    @Override
    public boolean isFollowReferrals() {
        return ((SearchRequest)this.getDecorated()).isFollowReferrals();
    }

    @Override
    public SearchRequest followReferrals() {
        return ((SearchRequest)this.getDecorated()).followReferrals();
    }

    @Override
    public boolean isIgnoreReferrals() {
        return ((SearchRequest)this.getDecorated()).isIgnoreReferrals();
    }

    @Override
    public SearchRequest ignoreReferrals() {
        return ((SearchRequest)this.getDecorated()).ignoreReferrals();
    }
}

