/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.partition.impl.btree.mavibot;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Comparator;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.cursor.Tuple;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.MatchingRule;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.ldap.model.schema.comparators.SerializableComparator;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.serializer.AbstractElementSerializer;
import org.apache.directory.mavibot.btree.serializer.ByteArraySerializer;
import org.apache.directory.mavibot.btree.serializer.StringSerializer;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.core.partition.impl.btree.mavibot.MavibotTable;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndex;
import org.apache.directory.server.xdbm.EmptyIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MavibotIndex<K>
extends AbstractIndex<K, String> {
    private static final Logger LOG = LoggerFactory.getLogger(MavibotIndex.class.getSimpleName());
    public static final String FORWARD_BTREE = "_forward";
    public static final String REVERSE_BTREE = "_reverse";
    protected MavibotTable<K, String> forward;
    protected MavibotTable<String, K> reverse;
    protected File wkDirPath;
    protected RecordManager recordMan;

    public MavibotIndex(String attributeId, boolean withReverse) {
        super(attributeId, withReverse);
        this.initialized = false;
    }

    public void init(SchemaManager schemaManager, AttributeType attributeType) throws IOException {
        LOG.debug("Initializing an Index for attribute '{}'", (Object)attributeType.getName());
        if (this.recordMan == null) {
            throw new IllegalStateException("No RecordManager reference was set in the index " + this.getAttributeId());
        }
        this.attributeType = attributeType;
        if (this.attributeId == null) {
            this.setAttributeId(attributeType.getName());
        }
        if (this.wkDirPath == null) {
            NullPointerException e = new NullPointerException("The index working directory has not be set");
            throw e;
        }
        try {
            this.initTables(schemaManager);
        }
        catch (IOException e) {
            this.close();
            throw e;
        }
        this.initialized = true;
    }

    private void initTables(SchemaManager schemaManager) throws IOException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            throw new IOException(I18n.err(I18n.ERR_574, this.attributeType.getName()));
        }
        SerializableComparator<byte[]> comp = new SerializableComparator<byte[]>(mr.getOid());
        comp.setSchemaManager(schemaManager);
        AbstractElementSerializer forwardKeySerializer = null;
        forwardKeySerializer = !this.attributeType.getSyntax().isHumanReadable() ? new ByteArraySerializer((Comparator<byte[]>)comp) : new StringSerializer((Comparator<String>)comp);
        boolean forwardDups = true;
        String oid = this.attributeType.getOid();
        if (oid.equals("1.3.6.1.4.1.4203.666.1.7") || oid.equals("1.3.6.1.1.16.4")) {
            forwardDups = false;
        }
        String forwardTableName = this.attributeType.getOid() + FORWARD_BTREE;
        this.forward = new MavibotTable<byte[], String>(this.recordMan, schemaManager, forwardTableName, forwardKeySerializer, new StringSerializer(), forwardDups, 10000);
        if (this.withReverse) {
            String reverseTableName = this.attributeType.getOid() + REVERSE_BTREE;
            this.reverse = new MavibotTable<String, byte[]>(this.recordMan, schemaManager, reverseTableName, new StringSerializer(), forwardKeySerializer, !this.attributeType.isSingleValued());
        }
        String path = new File(this.wkDirPath, this.attributeType.getOid()).getAbsolutePath();
        FileWriter fw = new FileWriter(new File(path + "-" + this.attributeType.getName() + ".txt"));
        fw.write(this.attributeType.toString());
        fw.close();
    }

    public void setRecordManager(RecordManager rm) {
        this.recordMan = rm;
    }

    @Override
    public void setWkDirPath(URI wkDirPath) {
        this.protect("wkDirPath");
        this.wkDirPath = new File(wkDirPath);
    }

    @Override
    public URI getWkDirPath() {
        return this.wkDirPath != null ? this.wkDirPath.toURI() : null;
    }

    @Override
    public long count() throws IOException {
        return this.forward.count();
    }

    @Override
    public long count(K attrVal) throws Exception {
        return this.forward.count(attrVal);
    }

    @Override
    public long greaterThanCount(K attrVal) throws Exception {
        return this.forward.greaterThanCount(attrVal);
    }

    @Override
    public long lessThanCount(K attrVal) throws Exception {
        return this.forward.lessThanCount(attrVal);
    }

    @Override
    public String forwardLookup(K attrVal) throws Exception {
        return this.forward.get(attrVal);
    }

    @Override
    public K reverseLookup(String id) throws LdapException {
        if (this.withReverse) {
            return this.reverse.get(id);
        }
        return null;
    }

    @Override
    public synchronized void add(K attrVal, String id) throws Exception {
        this.forward.put(attrVal, id);
        if (this.withReverse) {
            this.reverse.put(id, (String)attrVal);
        }
    }

    @Override
    public synchronized void drop(K attrVal, String id) throws Exception {
        if (this.forward.has(attrVal, id)) {
            this.forward.remove(attrVal, id);
            if (this.withReverse) {
                this.reverse.remove(id, (String)attrVal);
            }
        }
    }

    @Override
    public void drop(String entryId) throws Exception {
        if (this.withReverse) {
            if (this.isDupsEnabled()) {
                Cursor<Tuple<String, K>> values = this.reverse.cursor(entryId);
                while (values.next()) {
                    this.forward.remove(values.get().getValue(), entryId);
                }
                values.close();
            } else {
                K key = this.reverse.get(entryId);
                this.forward.remove(key);
            }
            this.reverse.remove(entryId);
        }
    }

    @Override
    public Cursor<IndexEntry<K, String>> reverseCursor() throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(), false);
        }
        return new EmptyIndexCursor();
    }

    @Override
    public Cursor<IndexEntry<K, String>> forwardCursor() throws LdapException {
        return new IndexCursorAdaptor(this.forward.cursor(), true);
    }

    @Override
    public Cursor<IndexEntry<K, String>> reverseCursor(String id) throws Exception {
        if (this.withReverse) {
            return new IndexCursorAdaptor(this.reverse.cursor(id), false);
        }
        return new EmptyIndexCursor();
    }

    @Override
    public Cursor<IndexEntry<K, String>> forwardCursor(K key) throws Exception {
        return new IndexCursorAdaptor(this.forward.cursor(key), true);
    }

    @Override
    public Cursor<K> reverseValueCursor(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.valueCursor(id);
        }
        return new EmptyCursor();
    }

    @Override
    public Cursor<String> forwardValueCursor(K key) throws Exception {
        return this.forward.valueCursor(key);
    }

    @Override
    public boolean forward(K attrVal) throws Exception {
        return this.forward.has(attrVal);
    }

    @Override
    public boolean forward(K attrVal, String id) throws LdapException {
        return this.forward.has(attrVal, id);
    }

    @Override
    public boolean reverse(String id) throws Exception {
        if (this.withReverse) {
            return this.reverse.has(id);
        }
        return false;
    }

    @Override
    public boolean reverse(String id, K attrVal) throws Exception {
        return this.forward.has(attrVal, id);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            if (this.forward != null) {
                this.forward.close();
            }
            if (this.reverse != null) {
                this.reverse.close();
            }
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public synchronized void sync() throws IOException {
        this.forward.getBTree().flush();
        if (this.reverse != null) {
            this.reverse.getBTree().flush();
        }
    }

    @Override
    public boolean isDupsEnabled() {
        if (this.withReverse) {
            return this.reverse.isDupsEnabled();
        }
        return false;
    }

    public String toString() {
        return "Index<" + this.attributeId + ">";
    }
}

