/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.util.Date;
import org.apache.directory.mavibot.btree.Page;

public class ReadTransaction<K, V> {
    private long revision;
    private long creationDate;
    private volatile Page<K, V> root;
    private volatile boolean closed;

    public ReadTransaction(Page<K, V> root, long revision, long creationDate) {
        this.revision = revision;
        this.creationDate = creationDate;
        this.root = root;
        this.closed = false;
    }

    public long getRevision() {
        return this.revision;
    }

    public Page<K, V> getRoot() {
        return this.root;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public void close() {
        this.root = null;
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public String toString() {
        return "Transaction[" + this.revision + ":" + new Date(this.creationDate) + ", closed :" + this.closed + "]";
    }
}

