/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.PersistedBTree;
import org.apache.directory.mavibot.btree.RecordManager;
import org.apache.directory.mavibot.btree.exception.BTreeOperationException;
import org.apache.directory.mavibot.btree.exception.EndOfFileExceededException;

class PersistedPageHolder<K, V>
extends PageHolder<K, V> {
    private RecordManager recordManager;
    private Cache cache;
    private long offset;
    private long lastOffset;

    public PersistedPageHolder(BTree<K, V> btree, Page<K, V> page) {
        super(btree, page);
        this.cache = ((PersistedBTree)btree).getCache();
        this.recordManager = ((PersistedBTree)btree).getRecordManager();
        this.offset = ((AbstractPage)page).getOffset();
        this.lastOffset = ((AbstractPage)page).getLastOffset();
        ((AbstractPage)page).setOffset(this.offset);
        ((AbstractPage)page).setLastOffset(this.lastOffset);
        this.cache.put(new Element(this.offset, page));
    }

    public PersistedPageHolder(BTree<K, V> btree, Page<K, V> page, long offset, long lastOffset) {
        super(btree, page);
        this.cache = ((PersistedBTree)btree).getCache();
        this.recordManager = ((PersistedBTree)btree).getRecordManager();
        this.offset = offset;
        this.lastOffset = lastOffset;
        if (page != null) {
            ((AbstractPage)page).setOffset(offset);
            ((AbstractPage)page).setLastOffset(lastOffset);
        }
        this.cache.put(new Element(offset, page));
    }

    @Override
    public Page<K, V> getValue() {
        Element element = this.cache.get(Long.valueOf(this.offset));
        if (element == null) {
            Page<K, V> page = this.fetchElement();
            this.cache.put(new Element(this.offset, page));
            return page;
        }
        Page<K, V> page = (Page<K, V>)element.getObjectValue();
        if (page == null) {
            page = this.fetchElement();
            ((AbstractPage)page).setOffset(this.offset);
            ((AbstractPage)page).setLastOffset(this.lastOffset);
            this.cache.put(new Element(this.offset, page));
        }
        return page;
    }

    private Page<K, V> fetchElement() {
        try {
            Page element = this.recordManager.deserialize(this.btree, this.offset);
            return element;
        }
        catch (EndOfFileExceededException eofee) {
            throw new BTreeOperationException(eofee.getMessage());
        }
        catch (IOException ioe) {
            throw new BTreeOperationException(ioe.getMessage());
        }
    }

    long getOffset() {
        return this.offset;
    }

    long getLastOffset() {
        return this.lastOffset;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Page<K, V> page = this.getValue();
        if (page != null) {
            sb.append(this.btree.getName()).append("[").append(this.offset).append(", ").append(this.lastOffset).append("]:").append(page);
        } else {
            sb.append(this.btree.getName()).append("[").append(this.offset).append(", ").append(this.lastOffset).append("]");
        }
        return sb.toString();
    }
}

