/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.mavibot.btree;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.List;
import org.apache.directory.mavibot.btree.AbstractPage;
import org.apache.directory.mavibot.btree.BTree;
import org.apache.directory.mavibot.btree.BorrowedFromLeftResult;
import org.apache.directory.mavibot.btree.BorrowedFromRightResult;
import org.apache.directory.mavibot.btree.BorrowedFromSiblingResult;
import org.apache.directory.mavibot.btree.DeleteResult;
import org.apache.directory.mavibot.btree.InsertResult;
import org.apache.directory.mavibot.btree.KeyHolder;
import org.apache.directory.mavibot.btree.MergedWithSiblingResult;
import org.apache.directory.mavibot.btree.ModifyResult;
import org.apache.directory.mavibot.btree.NotPresentResult;
import org.apache.directory.mavibot.btree.Page;
import org.apache.directory.mavibot.btree.PageHolder;
import org.apache.directory.mavibot.btree.RemoveResult;
import org.apache.directory.mavibot.btree.SplitResult;
import org.apache.directory.mavibot.btree.Tuple;

class InMemoryNode<K, V>
extends AbstractPage<K, V> {
    InMemoryNode(BTree<K, V> btree, long revision, int nbElems) {
        super(btree, revision, nbElems);
        this.children = (PageHolder[])Array.newInstance(PageHolder.class, nbElems + 1);
    }

    InMemoryNode(BTree<K, V> btree, long revision, K key, Page<K, V> leftPage, Page<K, V> rightPage) {
        super(btree, revision, 1);
        this.children = (PageHolder[])Array.newInstance(PageHolder.class, btree.getPageSize() + 1);
        this.children[0] = new PageHolder<K, V>(btree, leftPage);
        this.children[1] = new PageHolder<K, V>(btree, rightPage);
        this.setKeys((KeyHolder[])Array.newInstance(KeyHolder.class, btree.getPageSize()));
        this.setKey(0, new KeyHolder<K>(key));
    }

    @Override
    public InsertResult<K, V> insert(long revision, K key, V value) throws IOException {
        Page<K, V> child;
        InsertResult result;
        int pos = this.findPos(key);
        if (pos < 0) {
            pos = -pos++;
        }
        if ((result = (child = this.children[pos].getValue()).insert(revision, key, value)) instanceof ModifyResult) {
            return this.replaceChild(revision, (ModifyResult)result, pos);
        }
        SplitResult splitResult = (SplitResult)result;
        Object pivot = splitResult.getPivot();
        Page leftPage = splitResult.getLeftPage();
        Page rightPage = splitResult.getRightPage();
        result = this.nbElems == this.btree.getPageSize() ? this.addAndSplit(splitResult.getCopiedPages(), revision, pivot, leftPage, rightPage, pos) : this.insertChild(splitResult.getCopiedPages(), revision, pivot, leftPage, rightPage, pos);
        return result;
    }

    private RemoveResult<K, V> handleRemoveResult(RemoveResult<K, V> removeResult, int index, int pos, boolean found) throws IOException {
        InMemoryNode newPage = this.copy(this.revision);
        Page modifiedPage = removeResult.getModifiedPage();
        if (found) {
            newPage.children[index + 1] = new PageHolder(this.btree, modifiedPage);
        } else {
            newPage.children[index] = new PageHolder(this.btree, modifiedPage);
        }
        if (pos < 0) {
            newPage.setKey(index, new KeyHolder(removeResult.getModifiedPage().getLeftMostKey()));
        }
        removeResult.setModifiedPage(newPage);
        removeResult.addCopiedPage(this);
        return removeResult;
    }

    private RemoveResult<K, V> handleRootRemove(MergedWithSiblingResult<K, V> mergedResult, int pos, boolean found) throws IOException {
        RemoveResult<K, V> removeResult = null;
        if (this.nbElems == 1) {
            removeResult = new RemoveResult(mergedResult.getCopiedPages(), mergedResult.getModifiedPage(), mergedResult.getRemovedElement());
            removeResult.addCopiedPage(this);
        } else {
            removeResult = this.removeKey(mergedResult, this.revision, pos);
        }
        return removeResult;
    }

    private DeleteResult<K, V> borrowFromRight(long revision, MergedWithSiblingResult<K, V> mergedResult, InMemoryNode<K, V> sibling, int pos) throws IOException {
        Page modifiedPage;
        InMemoryNode<K, V> newSibling = new InMemoryNode<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        Object siblingKey = sibling.children[0].getValue().getLeftMostKey();
        System.arraycopy(sibling.getKeys(), 1, newSibling.getKeys(), 0, newSibling.getNbElems());
        System.arraycopy(sibling.children, 1, newSibling.children, 0, newSibling.getNbElems() + 1);
        InMemoryNode newNode = new InMemoryNode(this.btree, revision, this.nbElems);
        int index = Math.abs(pos);
        newNode.setKey(this.nbElems - 1, new KeyHolder(siblingKey));
        newNode.children[this.nbElems] = sibling.children[0];
        if (index < 2) {
            System.arraycopy(this.getKeys(), 1, newNode.getKeys(), 0, this.nbElems - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[0] = new PageHolder(this.btree, modifiedPage);
            System.arraycopy(this.children, 2, newNode.children, 1, this.nbElems - 1);
        } else {
            if (index > 2) {
                System.arraycopy(this.getKeys(), 0, newNode.getKeys(), 0, index - 2);
            }
            newNode.setKey(index - 2, new KeyHolder(mergedResult.getModifiedPage().getLeftMostKey()));
            if (index < this.nbElems) {
                System.arraycopy(this.getKeys(), index, newNode.getKeys(), index - 1, this.nbElems - index);
                System.arraycopy(this.children, index + 1, newNode.children, index, this.nbElems - index);
            }
            System.arraycopy(this.children, 0, newNode.children, 0, index - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[index - 1] = new PageHolder(this.btree, modifiedPage);
        }
        BorrowedFromRightResult result = new BorrowedFromRightResult(mergedResult.getCopiedPages(), newNode, newSibling, mergedResult.getRemovedElement());
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> borrowFromLeft(long revision, MergedWithSiblingResult<K, V> mergedResult, InMemoryNode<K, V> sibling, int pos) throws IOException {
        Page modifiedPage;
        Page siblingChild = sibling.children[sibling.nbElems].getValue();
        InMemoryNode<K, V> newSibling = new InMemoryNode<K, V>(this.btree, revision, sibling.getNbElems() - 1);
        System.arraycopy(sibling.getKeys(), 0, newSibling.getKeys(), 0, newSibling.getNbElems());
        System.arraycopy(sibling.children, 0, newSibling.children, 0, newSibling.getNbElems() + 1);
        InMemoryNode newNode = new InMemoryNode(this.btree, revision, this.nbElems);
        newNode.children[0] = new PageHolder(this.btree, siblingChild);
        int index = Math.abs(pos);
        if (index < 2) {
            newNode.setKey(0, new KeyHolder(mergedResult.getModifiedPage().getLeftMostKey()));
            System.arraycopy(this.getKeys(), 1, newNode.getKeys(), 1, this.nbElems - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[1] = new PageHolder(this.btree, modifiedPage);
            System.arraycopy(this.children, 2, newNode.children, 2, this.nbElems - 1);
        } else {
            newNode.setKey(0, new KeyHolder(this.children[0].getValue().getLeftMostKey()));
            if (index > 2) {
                System.arraycopy(this.getKeys(), 0, newNode.getKeys(), 1, index - 2);
            }
            newNode.setKey(index - 1, new KeyHolder(mergedResult.getModifiedPage().getLeftMostKey()));
            if (index < this.nbElems) {
                System.arraycopy(this.getKeys(), index, newNode.getKeys(), index, this.nbElems - index);
                System.arraycopy(this.children, index + 1, newNode.children, index + 1, this.nbElems - index);
            }
            System.arraycopy(this.children, 0, newNode.children, 1, index - 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[index] = new PageHolder(this.btree, modifiedPage);
        }
        BorrowedFromLeftResult result = new BorrowedFromLeftResult(mergedResult.getCopiedPages(), newNode, newSibling, mergedResult.getRemovedElement());
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    private DeleteResult<K, V> mergeWithSibling(long revision, MergedWithSiblingResult<K, V> mergedResult, InMemoryNode<K, V> sibling, boolean isLeft, int pos) throws IOException {
        Page modifiedPage;
        InMemoryNode newNode = new InMemoryNode(this.btree, revision, this.btree.getPageSize());
        Tuple removedElement = mergedResult.getRemovedElement();
        int half = this.btree.getPageSize() / 2;
        int index = Math.abs(pos);
        if (isLeft) {
            System.arraycopy(sibling.getKeys(), 0, newNode.getKeys(), 0, half);
            System.arraycopy(sibling.children, 0, newNode.children, 0, half + 1);
            if (index < 2) {
                newNode.setKey(half, new KeyHolder(mergedResult.getModifiedPage().getLeftMostKey()));
                System.arraycopy(this.getKeys(), 1, newNode.getKeys(), half + 1, half - 1);
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[half + 1] = new PageHolder(this.btree, modifiedPage);
                System.arraycopy(this.children, 2, newNode.children, half + 2, half - 1);
            } else {
                newNode.setKey(half, new KeyHolder(this.children[0].getValue().getLeftMostKey()));
                if (index > 2) {
                    System.arraycopy(this.getKeys(), 0, newNode.getKeys(), half + 1, index - 2);
                }
                newNode.setKey(half + index - 1, new KeyHolder(mergedResult.getModifiedPage().getLeftMostKey()));
                if (index < half) {
                    System.arraycopy(this.getKeys(), index, newNode.getKeys(), half + index, half - index);
                    System.arraycopy(this.children, index + 1, newNode.children, half + index + 1, half - index);
                }
                System.arraycopy(this.children, 0, newNode.children, half + 1, index - 1);
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[half + index] = new PageHolder(this.btree, modifiedPage);
            }
        } else {
            if (index < 2) {
                System.arraycopy(this.getKeys(), 1, newNode.getKeys(), 0, half - 1);
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[0] = new PageHolder(this.btree, modifiedPage);
                System.arraycopy(this.children, 2, newNode.children, 1, half - 1);
            } else {
                if (index > 2) {
                    System.arraycopy(this.getKeys(), 0, newNode.getKeys(), 0, index - 2);
                }
                System.arraycopy(this.children, 0, newNode.children, 0, index - 1);
                newNode.setKey(index - 2, new KeyHolder(mergedResult.getModifiedPage().getLeftMostKey()));
                modifiedPage = mergedResult.getModifiedPage();
                newNode.children[index - 1] = new PageHolder(this.btree, modifiedPage);
                if (index < half) {
                    System.arraycopy(this.getKeys(), index, newNode.getKeys(), index - 1, half - index);
                    System.arraycopy(this.children, index + 1, newNode.children, index, half - index);
                }
            }
            newNode.setKey(half - 1, new KeyHolder(sibling.findLeftMost().getKey()));
            System.arraycopy(sibling.getKeys(), 0, newNode.getKeys(), half, half);
            System.arraycopy(sibling.children, 0, newNode.children, half, half + 1);
        }
        MergedWithSiblingResult result = new MergedWithSiblingResult(mergedResult.getCopiedPages(), newNode, removedElement);
        result.addCopiedPage(this);
        result.addCopiedPage(sibling);
        return result;
    }

    @Override
    public DeleteResult<K, V> delete(long revision, K key, V value, Page<K, V> parent, int parentPos) throws IOException {
        int pos = this.findPos(key);
        boolean found = pos < 0;
        int index = pos;
        Page<K, V> child = null;
        DeleteResult deleteResult = null;
        if (found) {
            index = -(pos + 1);
            child = this.children[-pos].getValue();
            deleteResult = child.delete(revision, key, value, this, -pos);
        } else {
            child = this.children[pos].getValue();
            deleteResult = child.delete(revision, key, value, this, pos);
        }
        if (deleteResult instanceof NotPresentResult) {
            return deleteResult;
        }
        if (deleteResult instanceof RemoveResult) {
            RemoveResult<K, V> removeResult = this.handleRemoveResult((RemoveResult)deleteResult, index, pos, found);
            return removeResult;
        }
        if (deleteResult instanceof BorrowedFromSiblingResult) {
            RemoveResult<K, V> removeResult = this.handleBorrowedResult((BorrowedFromSiblingResult)deleteResult, pos);
            return removeResult;
        }
        if (deleteResult instanceof MergedWithSiblingResult) {
            MergedWithSiblingResult mergedResult = (MergedWithSiblingResult)deleteResult;
            if (parent == null) {
                RemoveResult<K, V> result = this.handleRootRemove(mergedResult, pos, found);
                return result;
            }
            int halfSize = this.btree.getPageSize() / 2;
            if (this.nbElems > halfSize) {
                RemoveResult<K, V> result = this.removeKey(mergedResult, revision, pos);
                return result;
            }
            int siblingPos = this.selectSibling((InMemoryNode)parent, parentPos);
            InMemoryNode sibling = (InMemoryNode)((InMemoryNode)parent).children[siblingPos].getValue();
            if (sibling.getNbElems() > halfSize) {
                if (siblingPos < parentPos) {
                    DeleteResult<K, V> result = this.borrowFromLeft(revision, mergedResult, sibling, pos);
                    return result;
                }
                DeleteResult<K, V> result = this.borrowFromRight(revision, mergedResult, sibling, pos);
                return result;
            }
            DeleteResult<K, V> result = this.mergeWithSibling(revision, mergedResult, sibling, siblingPos < parentPos, pos);
            return result;
        }
        return null;
    }

    private RemoveResult<K, V> handleBorrowedResult(BorrowedFromSiblingResult<K, V> borrowedResult, int pos) throws IOException {
        Page modifiedPage = borrowedResult.getModifiedPage();
        Page<K, V> modifiedSibling = borrowedResult.getModifiedSibling();
        InMemoryNode newPage = this.copy(this.revision);
        if (pos < 0) {
            pos = -(pos + 1);
            if (borrowedResult.isFromRight()) {
                newPage.setKey(pos, new KeyHolder(modifiedPage.findLeftMost().getKey()));
                newPage.setKey(pos + 1, new KeyHolder<K>(modifiedSibling.findLeftMost().getKey()));
                newPage.children[pos + 1] = new PageHolder(this.btree, modifiedPage);
                newPage.children[pos + 2] = new PageHolder<K, V>(this.btree, modifiedSibling);
            } else {
                newPage.setKey(pos, new KeyHolder(modifiedPage.findLeftMost().getKey()));
                newPage.children[pos] = new PageHolder<K, V>(this.btree, modifiedSibling);
                newPage.children[pos + 1] = new PageHolder(this.btree, modifiedPage);
            }
        } else if (borrowedResult.isFromRight()) {
            newPage.setKey(pos, new KeyHolder<K>(modifiedSibling.findLeftMost().getKey()));
            newPage.children[pos] = new PageHolder(this.btree, modifiedPage);
            newPage.children[pos + 1] = new PageHolder<K, V>(this.btree, modifiedSibling);
        } else {
            newPage.setKey(pos - 1, new KeyHolder(modifiedPage.findLeftMost().getKey()));
            newPage.children[pos - 1] = new PageHolder<K, V>(this.btree, modifiedSibling);
            newPage.children[pos] = new PageHolder(this.btree, modifiedPage);
        }
        RemoveResult removeResult = new RemoveResult(borrowedResult.getCopiedPages(), newPage, borrowedResult.getRemovedElement());
        removeResult.addCopiedPage(this);
        return removeResult;
    }

    private RemoveResult<K, V> removeKey(MergedWithSiblingResult<K, V> mergedResult, long revision, int pos) throws IOException {
        Page modifiedPage;
        InMemoryNode newNode = new InMemoryNode(this.btree, revision, this.nbElems - 1);
        int index = Math.abs(pos) - 2;
        if (index < 0) {
            System.arraycopy(this.getKeys(), 1, newNode.getKeys(), 0, newNode.nbElems);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[0] = new PageHolder(this.btree, modifiedPage);
            System.arraycopy(this.children, 2, newNode.children, 1, this.nbElems - 1);
        } else {
            if (index > 0) {
                System.arraycopy(this.getKeys(), 0, newNode.getKeys(), 0, index);
            }
            newNode.setKey(index, new KeyHolder(mergedResult.getModifiedPage().findLeftMost().getKey()));
            if (index < this.nbElems - 2) {
                System.arraycopy(this.getKeys(), index + 2, newNode.getKeys(), index + 1, this.nbElems - index - 2);
            }
            System.arraycopy(this.children, 0, newNode.children, 0, index + 1);
            modifiedPage = mergedResult.getModifiedPage();
            newNode.children[index + 1] = new PageHolder(this.btree, modifiedPage);
            if (index < this.nbElems - 2) {
                System.arraycopy(this.children, index + 3, newNode.children, index + 2, this.nbElems - index - 2);
            }
        }
        RemoveResult result = new RemoveResult(mergedResult.getCopiedPages(), newNode, mergedResult.getRemovedElement());
        result.addCopiedPage(this);
        return result;
    }

    void setValue(int pos, Page<K, V> value) {
        this.children[pos] = new PageHolder<K, V>(this.btree, value);
    }

    private InsertResult<K, V> replaceChild(long revision, ModifyResult<K, V> result, int pos) throws IOException {
        InMemoryNode<K, V> newPage = this.copy(revision);
        Page<K, V> modifiedPage = result.getModifiedPage();
        newPage.children[pos] = new PageHolder<K, V>(this.btree, modifiedPage);
        result.setModifiedPage(newPage);
        result.addCopiedPage(this);
        return result;
    }

    private InsertResult<K, V> insertChild(List<Page<K, V>> copiedPages, long revision, K key, Page<K, V> leftPage, Page<K, V> rightPage, int pos) throws IOException {
        InMemoryNode<K, V> newNode = new InMemoryNode<K, V>(this.btree, revision, this.nbElems + 1);
        if (this.nbElems > 0) {
            System.arraycopy(this.getKeys(), 0, newNode.getKeys(), 0, pos);
            System.arraycopy(this.children, 0, newNode.children, 0, pos);
        }
        newNode.setKey(pos, new KeyHolder<K>(key));
        newNode.children[pos] = new PageHolder<K, V>(this.btree, leftPage);
        newNode.children[pos + 1] = new PageHolder<K, V>(this.btree, rightPage);
        if (this.nbElems > 0) {
            System.arraycopy(this.getKeys(), pos, newNode.getKeys(), pos + 1, this.getKeys().length - pos);
            System.arraycopy(this.children, pos + 1, newNode.children, pos + 2, this.children.length - pos - 1);
        }
        ModifyResult<K, Object> result = new ModifyResult<K, Object>(copiedPages, newNode, null);
        result.addCopiedPage(this);
        return result;
    }

    private InsertResult<K, V> addAndSplit(List<Page<K, V>> copiedPages, long revision, K pivot, Page<K, V> leftPage, Page<K, V> rightPage, int pos) throws IOException {
        int middle = this.btree.getPageSize() >> 1;
        InMemoryNode<K, V> newLeftPage = new InMemoryNode<K, V>(this.btree, revision, middle);
        InMemoryNode<K, V> newRightPage = new InMemoryNode<K, V>(this.btree, revision, middle);
        if (pos < middle) {
            System.arraycopy(this.getKeys(), 0, newLeftPage.getKeys(), 0, pos);
            System.arraycopy(this.children, 0, newLeftPage.children, 0, pos);
            newLeftPage.setKey(pos, new KeyHolder<K>(pivot));
            newLeftPage.children[pos] = new PageHolder<K, V>(this.btree, leftPage);
            newLeftPage.children[pos + 1] = new PageHolder<K, V>(this.btree, rightPage);
            System.arraycopy(this.getKeys(), pos, newLeftPage.getKeys(), pos + 1, middle - pos - 1);
            System.arraycopy(this.children, pos + 1, newLeftPage.children, pos + 2, middle - pos - 1);
            System.arraycopy(this.getKeys(), middle, newRightPage.getKeys(), 0, middle);
            System.arraycopy(this.children, middle, newRightPage.children, 0, middle + 1);
            SplitResult<K, V> result = new SplitResult<K, V>(copiedPages, this.getKey(middle - 1), newLeftPage, newRightPage);
            result.addCopiedPage(this);
            return result;
        }
        if (pos == middle) {
            System.arraycopy(this.getKeys(), 0, newLeftPage.getKeys(), 0, middle);
            System.arraycopy(this.children, 0, newLeftPage.children, 0, middle);
            newLeftPage.children[middle] = new PageHolder<K, V>(this.btree, leftPage);
            System.arraycopy(this.getKeys(), middle, newRightPage.getKeys(), 0, middle);
            System.arraycopy(this.children, middle + 1, newRightPage.children, 1, middle);
            newRightPage.children[0] = new PageHolder<K, V>(this.btree, rightPage);
            SplitResult<K, V> result = new SplitResult<K, V>(copiedPages, pivot, newLeftPage, newRightPage);
            result.addCopiedPage(this);
            return result;
        }
        System.arraycopy(this.getKeys(), 0, newLeftPage.getKeys(), 0, middle);
        System.arraycopy(this.children, 0, newLeftPage.children, 0, middle + 1);
        System.arraycopy(this.getKeys(), middle + 1, newRightPage.getKeys(), 0, pos - middle - 1);
        System.arraycopy(this.children, middle + 1, newRightPage.children, 0, pos - middle - 1);
        newRightPage.setKey(pos - middle - 1, new KeyHolder<K>(pivot));
        newRightPage.children[pos - middle - 1] = new PageHolder<K, V>(this.btree, leftPage);
        newRightPage.children[pos - middle] = new PageHolder<K, V>(this.btree, rightPage);
        System.arraycopy(this.getKeys(), pos, newRightPage.getKeys(), pos - middle, this.nbElems - pos);
        System.arraycopy(this.children, pos + 1, newRightPage.children, pos + 1 - middle, this.nbElems - pos);
        SplitResult<K, V> result = new SplitResult<K, V>(copiedPages, this.getKey(middle), newLeftPage, newRightPage);
        result.addCopiedPage(this);
        return result;
    }

    protected InMemoryNode<K, V> copy(long revision) {
        InMemoryNode<K, V> newPage = new InMemoryNode<K, V>(this.btree, revision, this.nbElems);
        System.arraycopy(this.getKeys(), 0, newPage.getKeys(), 0, this.nbElems);
        System.arraycopy(this.children, 0, newPage.children, 0, this.nbElems + 1);
        return newPage;
    }

    @Override
    public K getLeftMostKey() {
        return this.children[0].getValue().getLeftMostKey();
    }

    @Override
    public K getRightMostKey() {
        int index = this.nbElems + 1 - 1;
        if (this.children[index] != null) {
            return this.children[index].getValue().getRightMostKey();
        }
        return this.children[this.nbElems - 1].getValue().getRightMostKey();
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    @Override
    public boolean isNode() {
        return true;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Node[");
        sb.append(super.toString());
        sb.append("] -> {");
        if (this.nbElems > 0) {
            if (this.children[0] == null) {
                sb.append("null");
            } else {
                sb.append('r').append(this.children[0].getValue().getRevision());
            }
            for (int i = 0; i < this.nbElems; ++i) {
                sb.append("|<").append(this.getKey(i)).append(">|");
                if (this.children[i + 1] == null) {
                    sb.append("null");
                    continue;
                }
                sb.append('r').append(this.children[i + 1].getValue().getRevision());
            }
        }
        sb.append("}");
        return sb.toString();
    }
}

