/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.Attribute;
import org.apache.directory.api.ldap.model.entry.DefaultAttribute;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeValueException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidDnException;
import org.apache.directory.api.ldap.model.ldif.LdapLdifException;
import org.apache.directory.api.ldap.model.ldif.LdifAttributesReader;
import org.apache.directory.api.ldap.model.message.ResultCodeEnum;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Base64;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultEntry
implements Entry {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntry.class);
    private Dn dn;
    private Map<String, Attribute> attributes = new HashMap<String, Attribute>();
    private static AttributeType objectClassAttributeType;
    private SchemaManager schemaManager;
    private volatile int h;
    private static final Object MUTEX;

    public DefaultEntry() {
        this((SchemaManager)null);
    }

    public DefaultEntry(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
        this.dn = Dn.EMPTY_DN;
        if (schemaManager != null) {
            this.initObjectClassAT();
        }
    }

    public DefaultEntry(String dn) throws LdapInvalidDnException {
        this.dn = new Dn(dn);
    }

    public DefaultEntry(Dn dn) {
        this.dn = dn;
    }

    public DefaultEntry(SchemaManager schemaManager, String dn) throws LdapInvalidDnException {
        this.schemaManager = schemaManager;
        if (Strings.isEmpty(dn)) {
            this.dn = Dn.EMPTY_DN;
        } else {
            this.dn = new Dn(dn);
            this.normalizeDN(this.dn);
        }
        this.initObjectClassAT();
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn) {
        this.schemaManager = schemaManager;
        if (dn == null) {
            this.dn = Dn.EMPTY_DN;
        } else {
            this.dn = dn;
            this.normalizeDN(this.dn);
        }
        this.initObjectClassAT();
    }

    public DefaultEntry(String dn, Object ... elements) throws LdapException {
        this(null, dn, elements);
    }

    public DefaultEntry(Dn dn, Object ... elements) throws LdapException {
        this(null, dn, elements);
    }

    public DefaultEntry(SchemaManager schemaManager, String dn, Object ... elements) throws LdapException {
        this(schemaManager, new Dn(schemaManager, dn), elements);
    }

    public DefaultEntry(SchemaManager schemaManager, Dn dn, Object ... elements) throws LdapException {
        DefaultEntry entry = (DefaultEntry)this.createEntry(schemaManager, elements);
        this.dn = dn;
        this.attributes = entry.attributes;
        this.schemaManager = schemaManager;
        if (schemaManager != null) {
            this.dn.apply(schemaManager);
            this.initObjectClassAT();
        }
    }

    public DefaultEntry(SchemaManager schemaManager, Entry entry) throws LdapException {
        this.schemaManager = schemaManager;
        this.initObjectClassAT();
        if (entry.getDn() != null) {
            this.dn = entry.getDn();
            this.normalizeDN(this.dn);
        } else {
            this.dn = Dn.EMPTY_DN;
        }
        this.attributes = new HashMap<String, Attribute>(entry.size());
        for (Attribute attribute : entry) {
            try {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType == null) {
                    attributeType = schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                }
                DefaultAttribute serverAttribute = new DefaultAttribute(attributeType, attribute);
                this.add(serverAttribute);
            }
            catch (LdapException ne) {
                LOG.warn("The attribute '" + attribute.getId() + "' cannot be stored");
                throw ne;
            }
        }
    }

    private Entry createEntry(SchemaManager schemaManager, Object ... elements) throws LdapInvalidAttributeValueException, LdapLdifException {
        StringBuilder sb = new StringBuilder();
        int pos = 0;
        boolean valueExpected = false;
        for (Object element : elements) {
            if (!valueExpected) {
                if (!(element instanceof String)) {
                    throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_12085, pos + 1));
                }
                String attribute = (String)element;
                sb.append(attribute);
                if (attribute.indexOf(58) != -1) {
                    sb.append('\n');
                    continue;
                }
                valueExpected = true;
                continue;
            }
            if (element instanceof String) {
                sb.append(": ").append((String)element).append('\n');
            } else if (element instanceof byte[]) {
                sb.append(":: ");
                sb.append(new String(Base64.encode((byte[])element)));
                sb.append('\n');
            } else {
                throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_12086, pos + 1));
            }
            valueExpected = false;
        }
        if (valueExpected) {
            throw new LdapInvalidAttributeValueException(ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX, I18n.err(I18n.ERR_12087, new Object[0]));
        }
        LdifAttributesReader reader = new LdifAttributesReader();
        Entry entry = reader.parseEntry(schemaManager, sb.toString());
        return entry;
    }

    private String getId(String upId) {
        String id = Strings.trim(Strings.toLowerCase(upId));
        if (Strings.isEmpty(id)) {
            String message = I18n.err(I18n.ERR_04133, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return id;
    }

    private String getUpId(String upId, AttributeType attributeType) {
        String normUpId = Strings.trim(upId);
        if (attributeType == null) {
            if (Strings.isEmpty(normUpId)) {
                String message = I18n.err(I18n.ERR_04458, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
            return upId;
        }
        if (Strings.isEmpty(normUpId)) {
            String id = attributeType.getName();
            if (Strings.isEmpty(id)) {
                id = attributeType.getOid();
            }
            return id;
        }
        return upId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initObjectClassAT() {
        if (this.schemaManager == null) {
            return;
        }
        try {
            Object object = MUTEX;
            synchronized (object) {
                if (objectClassAttributeType == null) {
                    objectClassAttributeType = this.schemaManager.lookupAttributeTypeRegistry("objectClass");
                }
            }
        }
        catch (LdapException ldapException) {
            // empty catch block
        }
    }

    private void normalizeDN(Dn dn) {
        if (!dn.isSchemaAware()) {
            try {
                dn.apply(this.schemaManager);
            }
            catch (LdapException ne) {
                LOG.warn("The Dn '{}' cannot be normalized", (Object)dn);
            }
        }
    }

    private void rehash() {
        this.h = 37;
        this.h = this.h * 17 + this.dn.hashCode();
    }

    protected void createAttribute(String upId, AttributeType attributeType, byte[] ... values) throws LdapInvalidAttributeValueException {
        DefaultAttribute attribute = new DefaultAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType.getOid(), attribute);
    }

    protected void createAttribute(String upId, AttributeType attributeType, String ... values) throws LdapInvalidAttributeValueException {
        DefaultAttribute attribute = new DefaultAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType.getOid(), attribute);
    }

    protected void createAttribute(String upId, AttributeType attributeType, Value<?> ... values) throws LdapInvalidAttributeValueException {
        DefaultAttribute attribute = new DefaultAttribute(attributeType, values);
        attribute.setUpId(upId, attributeType);
        this.attributes.put(attributeType.getOid(), attribute);
    }

    protected AttributeType getAttributeType(String upId) throws LdapException {
        if (Strings.isEmpty(Strings.trim(upId))) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        return this.schemaManager.lookupAttributeTypeRegistry(upId);
    }

    @Override
    public void add(AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (values == null || values.length == 0) {
            String message = I18n.err(I18n.ERR_04478_NO_VALUE_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (attributeType.equals(objectClassAttributeType)) {
            String message = I18n.err(I18n.ERR_04461, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
        } else {
            this.createAttribute(null, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType.equals(objectClassAttributeType)) {
            String message = I18n.err(I18n.ERR_04461, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        String id = this.getUpId(upId, attributeType);
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(id, attributeType);
        } else {
            this.createAttribute(id, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getUpId(upId, attributeType);
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(id, attributeType);
        } else {
            this.createAttribute(id, attributeType, values);
        }
    }

    @Override
    public void add(String upId, AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getUpId(upId, attributeType);
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            attribute.add(values);
            attribute.setUpId(id, attributeType);
        } else {
            this.createAttribute(id, attributeType, values);
        }
    }

    @Override
    public void add(Attribute ... attributes) throws LdapException {
        for (Attribute attribute : attributes) {
            AttributeType attributeType = attribute.getAttributeType();
            if (attributeType != null) {
                String oid = attributeType.getOid();
                if (this.attributes.containsKey(oid)) {
                    Attribute existingAttribute = this.attributes.get(oid);
                    for (Value value : attribute) {
                        existingAttribute.add(value);
                    }
                    existingAttribute.setUpId(attribute.getUpId());
                    continue;
                }
                this.attributes.put(oid, attribute);
                continue;
            }
            if (this.contains(attribute)) {
                Attribute existingAttribute = this.get(attribute.getId());
                for (Value value : attribute) {
                    existingAttribute.add(value);
                }
                continue;
            }
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    @Override
    public void add(String upId, byte[] ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            this.add(upId, this.schemaManager.lookupAttributeTypeRegistry(id), values);
        } else {
            Attribute attribute = this.attributes.get(id);
            if (attribute != null) {
                attribute.add(values);
                attribute.setUpId(upId);
            } else {
                this.attributes.put(id, new DefaultAttribute(upId, values));
            }
        }
    }

    @Override
    public void add(String upId, String ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            this.add(upId, this.schemaManager.lookupAttributeTypeRegistry(upId), values);
        } else {
            Attribute attribute = this.attributes.get(id);
            if (attribute != null) {
                attribute.add(values);
                attribute.setUpId(upId);
            } else {
                this.attributes.put(id, new DefaultAttribute(upId, values));
            }
        }
    }

    @Override
    public void add(String upId, Value<?> ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            this.add(upId, this.schemaManager.lookupAttributeTypeRegistry(upId), values);
        } else {
            Attribute attribute = this.attributes.get(id);
            if (attribute != null) {
                attribute.add(values);
                attribute.setUpId(upId);
            } else {
                this.attributes.put(id, new DefaultAttribute(upId, values));
            }
        }
    }

    @Override
    public Entry clone() {
        DefaultEntry clone = (DefaultEntry)this.shallowClone();
        clone.attributes.clear();
        if (this.schemaManager != null) {
            for (Attribute attribute : this.attributes.values()) {
                String oid = attribute.getAttributeType().getOid();
                clone.attributes.put(oid, attribute.clone());
            }
        } else {
            for (Attribute attribute : this.attributes.values()) {
                clone.attributes.put(attribute.getId(), attribute.clone());
            }
        }
        return clone;
    }

    @Override
    public Entry shallowClone() {
        try {
            DefaultEntry clone = (DefaultEntry)super.clone();
            if (clone == null) {
                return null;
            }
            clone.dn = this.dn;
            clone.attributes = (Map)((HashMap)this.attributes).clone();
            return clone;
        }
        catch (CloneNotSupportedException cnse) {
            return null;
        }
    }

    @Override
    public boolean contains(Attribute ... attributes) {
        if (this.schemaManager == null) {
            for (Attribute attribute : attributes) {
                if (attribute == null) {
                    return this.attributes.size() == 0;
                }
                if (this.attributes.containsKey(attribute.getId())) continue;
                return false;
            }
        } else {
            for (Attribute entryAttribute : attributes) {
                if (entryAttribute == null) {
                    return this.attributes.size() == 0;
                }
                AttributeType attributeType = entryAttribute.getAttributeType();
                if (attributeType != null && this.attributes.containsKey(attributeType.getOid())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAttribute(String ... attributes) {
        if (this.schemaManager == null) {
            for (String attribute : attributes) {
                String id = this.getId(attribute);
                if (this.attributes.containsKey(id)) continue;
                return false;
            }
            return true;
        }
        for (String attribute : attributes) {
            try {
                if (this.containsAttribute(this.schemaManager.lookupAttributeTypeRegistry(attribute))) continue;
                return false;
            }
            catch (LdapException ne) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean containsAttribute(AttributeType attributeType) {
        if (attributeType == null) {
            return false;
        }
        return this.attributes.containsKey(attributeType.getOid());
    }

    @Override
    public boolean contains(AttributeType attributeType, byte[] ... values) {
        if (attributeType == null) {
            return false;
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, String ... values) {
        if (attributeType == null) {
            return false;
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(AttributeType attributeType, Value<?> ... values) {
        if (attributeType == null) {
            return false;
        }
        Attribute attribute = this.attributes.get(attributeType.getOid());
        if (attribute != null) {
            return attribute.contains(values);
        }
        return false;
    }

    @Override
    public boolean contains(String upId, byte[] ... values) {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.contains(this.schemaManager.lookupAttributeTypeRegistry(id), values);
            }
            catch (LdapException le) {
                return false;
            }
        }
        Attribute attribute = this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean contains(String upId, String ... values) {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.contains(this.schemaManager.lookupAttributeTypeRegistry(id), values);
            }
            catch (LdapException le) {
                return false;
            }
        }
        Attribute attribute = this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public boolean contains(String upId, Value<?> ... values) {
        if (Strings.isEmpty(upId)) {
            return false;
        }
        String id = this.getId(upId);
        if (this.schemaManager != null) {
            try {
                return this.contains(this.schemaManager.lookupAttributeTypeRegistry(id), values);
            }
            catch (LdapException le) {
                return false;
            }
        }
        Attribute attribute = this.attributes.get(id);
        if (attribute == null) {
            return false;
        }
        return attribute.contains(values);
    }

    @Override
    public Attribute get(String alias) {
        try {
            String id = this.getId(alias);
            if (this.schemaManager != null) {
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(id);
                    return this.attributes.get(attributeType.getOid());
                }
                catch (LdapException ne) {
                    String message = ne.getLocalizedMessage();
                    LOG.error(message);
                    return null;
                }
            }
            return this.attributes.get(id);
        }
        catch (IllegalArgumentException iea) {
            LOG.error(I18n.err(I18n.ERR_04134, alias));
            return null;
        }
    }

    @Override
    public Attribute get(AttributeType attributeType) {
        if (attributeType != null) {
            return this.attributes.get(attributeType.getOid());
        }
        return null;
    }

    @Override
    public Collection<Attribute> getAttributes() {
        return Collections.unmodifiableMap(this.attributes).values();
    }

    @Override
    public Attribute put(String upId, byte[] ... values) {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            DefaultAttribute clientAttribute = new DefaultAttribute(upId, values);
            return this.attributes.put(id, clientAttribute);
        }
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (LdapException ne) {
            String message = I18n.err(I18n.ERR_04464, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public Attribute put(String upId, String ... values) {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            DefaultAttribute clientAttribute = new DefaultAttribute(upId, values);
            return this.attributes.put(id, clientAttribute);
        }
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (LdapException ne) {
            String message = I18n.err(I18n.ERR_04464, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public Attribute put(String upId, Value<?> ... values) {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            DefaultAttribute clientAttribute = new DefaultAttribute(upId, values);
            return this.attributes.put(id, clientAttribute);
        }
        try {
            return this.put(upId, this.getAttributeType(upId), values);
        }
        catch (LdapException ne) {
            String message = I18n.err(I18n.ERR_04464, upId, ne.getLocalizedMessage());
            LOG.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    @Override
    public List<Attribute> put(Attribute ... attributes) throws LdapException {
        ArrayList<Attribute> previous = new ArrayList<Attribute>();
        if (this.schemaManager == null) {
            for (Attribute attribute : attributes) {
                String id = attribute.getId();
                if (this.containsAttribute(id)) {
                    previous.add(this.get(id));
                    this.attributes.remove(id);
                }
                this.attributes.put(id, attribute);
            }
        } else {
            for (Attribute attribute : attributes) {
                Attribute removed;
                if (attribute == null) {
                    String message = I18n.err(I18n.ERR_04462, new Object[0]);
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
                if (attribute.getAttributeType() == null) {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                    attribute.apply(attributeType);
                }
                if ((removed = this.attributes.put(attribute.getAttributeType().getOid(), attribute)) == null) continue;
                previous.add(removed);
            }
        }
        return previous;
    }

    @Override
    public Attribute put(AttributeType attributeType, byte[] ... values) throws LdapException {
        return this.put(null, attributeType, values);
    }

    @Override
    public Attribute put(AttributeType attributeType, String ... values) throws LdapException {
        return this.put(null, attributeType, values);
    }

    @Override
    public Attribute put(AttributeType attributeType, Value<?> ... values) throws LdapException {
        return this.put(null, attributeType, values);
    }

    @Override
    public Attribute put(String upId, AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (Exception e) {
                String message = I18n.err(I18n.ERR_04477_NO_VALID_AT_FOR_THIS_ID, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!Strings.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_04463, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = this.getUpId(upId, attributeType);
        }
        if (attributeType.equals(objectClassAttributeType)) {
            String message = I18n.err(I18n.ERR_04461, new Object[0]);
            LOG.error(message);
            throw new UnsupportedOperationException(message);
        }
        DefaultAttribute attribute = new DefaultAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType.getOid(), attribute);
    }

    @Override
    public Attribute put(String upId, AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (Exception e) {
                String message = I18n.err(I18n.ERR_04477_NO_VALID_AT_FOR_THIS_ID, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!Strings.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_04463, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = this.getUpId(upId, attributeType);
        }
        DefaultAttribute attribute = new DefaultAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType.getOid(), attribute);
    }

    @Override
    public Attribute put(String upId, AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            try {
                attributeType = this.getAttributeType(upId);
            }
            catch (Exception e) {
                String message = I18n.err(I18n.ERR_04477_NO_VALID_AT_FOR_THIS_ID, new Object[0]);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else if (!Strings.isEmpty(upId)) {
            AttributeType tempAT = this.getAttributeType(upId);
            if (!tempAT.equals(attributeType)) {
                String message = I18n.err(I18n.ERR_04463, upId, attributeType);
                LOG.error(message);
                throw new IllegalArgumentException(message);
            }
        } else {
            upId = this.getUpId(upId, attributeType);
        }
        DefaultAttribute attribute = new DefaultAttribute(upId, attributeType, values);
        return this.attributes.put(attributeType.getOid(), attribute);
    }

    @Override
    public List<Attribute> remove(Attribute ... attributes) throws LdapException {
        ArrayList<Attribute> removedAttributes = new ArrayList<Attribute>();
        if (this.schemaManager == null) {
            for (Attribute attribute : attributes) {
                if (!this.containsAttribute(attribute.getId())) continue;
                this.attributes.remove(attribute.getId());
                removedAttributes.add(attribute);
            }
        } else {
            for (Attribute attribute : attributes) {
                AttributeType attributeType = attribute.getAttributeType();
                if (attributeType == null) {
                    String message = I18n.err(I18n.ERR_04460_ATTRIBUTE_TYPE_NULL_NOT_ALLOWED, new Object[0]);
                    LOG.error(message);
                    throw new IllegalArgumentException(message);
                }
                if (!this.attributes.containsKey(attributeType.getOid())) continue;
                this.attributes.remove(attributeType.getOid());
                removedAttributes.add(attribute);
            }
        }
        return removedAttributes;
    }

    @Override
    public boolean remove(AttributeType attributeType, byte[] ... values) throws LdapException {
        if (attributeType == null) {
            return false;
        }
        try {
            Attribute attribute = this.attributes.get(attributeType.getOid());
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType.getOid());
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04465, attributeType));
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, String ... values) throws LdapException {
        if (attributeType == null) {
            return false;
        }
        try {
            Attribute attribute = this.attributes.get(attributeType.getOid());
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType.getOid());
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04465, attributeType));
            return false;
        }
    }

    @Override
    public boolean remove(AttributeType attributeType, Value<?> ... values) throws LdapException {
        if (attributeType == null) {
            return false;
        }
        try {
            Attribute attribute = this.attributes.get(attributeType.getOid());
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(attributeType.getOid());
                return true;
            }
            return nbOldValues != attribute.size();
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04465, attributeType));
            return false;
        }
    }

    @Override
    public void removeAttributes(AttributeType ... attributes) {
        if (attributes == null || attributes.length == 0 || this.schemaManager == null) {
            return;
        }
        for (AttributeType attributeType : attributes) {
            if (attributeType == null) continue;
            this.attributes.remove(attributeType.getOid());
        }
    }

    @Override
    public void removeAttributes(String ... attributes) {
        if (attributes.length == 0) {
            return;
        }
        if (this.schemaManager == null) {
            for (String attribute : attributes) {
                Attribute attr = this.get(attribute);
                if (attr != null) {
                    this.attributes.remove(attr.getId());
                    continue;
                }
                String message = I18n.err(I18n.ERR_04137, attribute);
                LOG.warn(message);
            }
        } else {
            for (String attribute : attributes) {
                AttributeType attributeType = null;
                try {
                    attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute);
                }
                catch (LdapException ne) {
                    String message = "The attribute '" + attribute + "' does not exist in the entry";
                    LOG.warn(message);
                    continue;
                }
                this.attributes.remove(attributeType.getOid());
            }
        }
    }

    @Override
    public boolean remove(String upId, byte[] ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.info(message);
            return false;
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            Attribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04465, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04466, upId));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, String ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.info(message);
            return false;
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            Attribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04465, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04466, upId));
            return false;
        }
    }

    @Override
    public boolean remove(String upId, Value<?> ... values) throws LdapException {
        if (Strings.isEmpty(upId)) {
            String message = I18n.err(I18n.ERR_04457_NULL_ATTRIBUTE_ID, new Object[0]);
            LOG.info(message);
            return false;
        }
        if (this.schemaManager == null) {
            String id = this.getId(upId);
            Attribute attribute = this.get(id);
            if (attribute == null) {
                return false;
            }
            int nbOldValues = attribute.size();
            attribute.remove(values);
            if (attribute.size() == 0) {
                this.attributes.remove(id);
                return true;
            }
            return nbOldValues != attribute.size();
        }
        try {
            AttributeType attributeType = this.getAttributeType(upId);
            return this.remove(attributeType, values);
        }
        catch (LdapException ne) {
            LOG.error(I18n.err(I18n.ERR_04465, upId));
            return false;
        }
        catch (IllegalArgumentException iae) {
            LOG.error(I18n.err(I18n.ERR_04466, upId));
            return false;
        }
    }

    @Override
    public Dn getDn() {
        return this.dn;
    }

    @Override
    public void setDn(Dn dn) {
        this.dn = dn;
        this.rehash();
    }

    @Override
    public void setDn(String dn) throws LdapInvalidDnException {
        this.setDn(new Dn(dn));
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    public Iterator<Attribute> iterator() {
        return Collections.unmodifiableMap(this.attributes).values().iterator();
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        if (this.dn == null) {
            Dn.EMPTY_DN.writeExternal(out);
        } else {
            this.dn.writeExternal(out);
        }
        out.writeInt(this.attributes.size());
        for (Attribute attribute : this.attributes.values()) {
            attribute.writeExternal(out);
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dn = new Dn(this.schemaManager);
        this.dn.readExternal(in);
        int nbAttributes = in.readInt();
        for (int i = 0; i < nbAttributes; ++i) {
            DefaultAttribute attribute = new DefaultAttribute();
            attribute.readExternal(in);
            if (this.schemaManager != null) {
                try {
                    AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(attribute.getId());
                    attribute.apply(attributeType);
                    this.attributes.put(attributeType.getOid(), attribute);
                    continue;
                }
                catch (LdapException le) {
                    String message = le.getLocalizedMessage();
                    LOG.error(message);
                    throw new IOException(message);
                }
            }
            this.attributes.put(attribute.getId(), attribute);
        }
    }

    public int hashCode() {
        if (this.h == 0) {
            this.rehash();
        }
        return this.h;
    }

    @Override
    public boolean hasObjectClass(String ... objectClasses) {
        if (objectClasses == null || objectClasses.length == 0 || objectClasses[0] == null) {
            return false;
        }
        for (String objectClass : objectClasses) {
            if (!(this.schemaManager != null ? !this.contains(objectClassAttributeType, objectClass) : !this.contains("objectclass", objectClass))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasObjectClass(Attribute ... objectClasses) {
        if (objectClasses == null || objectClasses.length == 0 || objectClasses[0] == null) {
            return false;
        }
        for (Attribute objectClass : objectClasses) {
            if (!objectClass.getAttributeType().equals(objectClassAttributeType)) {
                return false;
            }
            Attribute attribute = this.attributes.get(objectClassAttributeType.getOid());
            if (attribute == null) {
                return false;
            }
            for (Value value : objectClass) {
                if (attribute.contains(value.getString())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isSchemaAware() {
        return this.schemaManager != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Entry)) {
            return false;
        }
        Entry other = (Entry)o;
        if (this.dn == null ? other.getDn() != null : !this.dn.equals(other.getDn())) {
            return false;
        }
        if (this.size() != other.size()) {
            return false;
        }
        for (Attribute attribute : other) {
            if (attribute.equals(this.get(attribute.getId()))) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.toString("");
    }

    @Override
    public String toString(String tabs) {
        Attribute objectClass;
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("Entry\n");
        sb.append(tabs).append("    dn");
        if (this.dn.isSchemaAware()) {
            sb.append("[n]");
        }
        sb.append(": ");
        sb.append(this.dn.getName());
        sb.append('\n');
        if (this.schemaManager != null) {
            if (this.containsAttribute(objectClassAttributeType.getOid())) {
                objectClass = this.get(objectClassAttributeType);
                sb.append(objectClass.toString(tabs + "    "));
            }
        } else if (this.containsAttribute("objectClass")) {
            objectClass = this.get("objectclass");
            sb.append(objectClass.toString(tabs + "    "));
        }
        sb.append('\n');
        if (this.attributes.size() != 0) {
            boolean isFirst = true;
            for (Attribute attribute : this.attributes.values()) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    sb.append('\n');
                }
                String id = attribute.getId();
                if (this.schemaManager != null) {
                    AttributeType attributeType = this.schemaManager.getAttributeType(id);
                    if (attributeType == null) {
                        sb.append(tabs + "id: " + id);
                        continue;
                    }
                    if (attributeType.equals(objectClassAttributeType)) continue;
                    sb.append(attribute.toString(tabs + "    "));
                    continue;
                }
                if (id.equalsIgnoreCase("objectClass") || id.equals("2.5.4.0")) continue;
                sb.append(attribute.toString(tabs + "    "));
            }
        }
        return sb.toString();
    }

    static {
        MUTEX = new Object();
    }
}

