/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.standalone;

import java.util.Map;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.ExtendedOperationFactory;
import org.apache.directory.api.ldap.codec.api.LdapApiService;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeDecorator;
import org.apache.directory.api.ldap.codec.controls.cascade.CascadeFactory;
import org.apache.directory.api.ldap.codec.controls.manageDsaIT.ManageDsaITFactory;
import org.apache.directory.api.ldap.codec.controls.search.entryChange.EntryChangeFactory;
import org.apache.directory.api.ldap.codec.controls.search.pagedSearch.PagedResultsFactory;
import org.apache.directory.api.ldap.codec.controls.search.persistentSearch.PersistentSearchFactory;
import org.apache.directory.api.ldap.codec.controls.search.subentries.SubentriesFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortRequestFactory;
import org.apache.directory.api.ldap.codec.controls.sort.SortResponseFactory;
import org.apache.directory.api.ldap.extras.controls.ppolicy_impl.PasswordPolicyFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncDoneValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncInfoValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncRequestValueFactory;
import org.apache.directory.api.ldap.extras.controls.syncrepl_impl.SyncStateValueFactory;
import org.apache.directory.api.ldap.extras.extended.CancelRequest;
import org.apache.directory.api.ldap.extras.extended.CancelResponse;
import org.apache.directory.api.ldap.extras.extended.ads_impl.cancel.CancelFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.certGeneration.CertGenerationFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulDisconnect.GracefulDisconnectFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.gracefulShutdown.GracefulShutdownFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.pwdModify.PasswordModifyFactory;
import org.apache.directory.api.ldap.extras.extended.ads_impl.storedProcedure.StoredProcedureFactory;
import org.apache.directory.api.ldap.model.message.controls.Cascade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CodecFactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(CodecFactoryUtil.class);

    public static void loadStockControls(Map<String, ControlFactory<?, ?>> controlFactories, LdapApiService apiService) {
        ControlFactory<Cascade, CascadeDecorator> factory = new CascadeFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new EntryChangeFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new ManageDsaITFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PagedResultsFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PersistentSearchFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SubentriesFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new PasswordPolicyFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SyncDoneValueFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SyncInfoValueFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SyncRequestValueFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SyncStateValueFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SortRequestFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
        factory = new SortResponseFactory(apiService);
        controlFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled control factory: {}", (Object)factory.getOid());
    }

    public static void loadStockExtendedOperations(Map<String, ExtendedOperationFactory<?, ?>> extendendOperationsFactories, LdapApiService apiService) {
        ExtendedOperationFactory<CancelRequest, CancelResponse> factory = new CancelFactory(apiService);
        extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
        factory = new CertGenerationFactory(apiService);
        extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
        factory = new GracefulShutdownFactory(apiService);
        extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
        factory = new StoredProcedureFactory(apiService);
        extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
        factory = new GracefulDisconnectFactory(apiService);
        extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
        factory = new PasswordModifyFactory(apiService);
        extendendOperationsFactories.put(factory.getOid(), factory);
        LOG.info("Registered pre-bundled extended operation factory: {}", (Object)factory.getOid());
    }
}

