/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.normalization;

import org.apache.directory.api.ldap.model.cursor.EmptyCursor;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.entry.Modification;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.exception.LdapInvalidAttributeTypeException;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.NotNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.OrNode;
import org.apache.directory.api.ldap.model.filter.PresenceNode;
import org.apache.directory.api.ldap.model.name.Ava;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.name.Rdn;
import org.apache.directory.api.ldap.model.schema.AttributeType;
import org.apache.directory.api.ldap.model.schema.normalizers.ConcreteNameComponentNormalizer;
import org.apache.directory.server.core.api.DirectoryService;
import org.apache.directory.server.core.api.InterceptorEnum;
import org.apache.directory.server.core.api.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.api.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.api.interceptor.BaseInterceptor;
import org.apache.directory.server.core.api.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.api.interceptor.context.CompareOperationContext;
import org.apache.directory.server.core.api.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.api.interceptor.context.HasEntryOperationContext;
import org.apache.directory.server.core.api.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.api.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.api.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.normalization.FilterNormalizingVisitor;
import org.apache.directory.server.i18n.I18n;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(NormalizationInterceptor.class);
    private FilterNormalizingVisitor normVisitor;

    public NormalizationInterceptor() {
        super(InterceptorEnum.NORMALIZATION_INTERCEPTOR);
    }

    @Override
    public void init(DirectoryService directoryService) throws LdapException {
        LOG.debug("Initialiazing the NormalizationInterceptor");
        super.init(directoryService);
        ConcreteNameComponentNormalizer ncn = new ConcreteNameComponentNormalizer(this.schemaManager);
        this.normVisitor = new FilterNormalizingVisitor(ncn, this.schemaManager);
    }

    @Override
    public void destroy() {
    }

    @Override
    public void add(AddOperationContext addContext) throws LdapException {
        addContext.getDn().apply(this.schemaManager);
        addContext.getEntry().getDn().apply(this.schemaManager);
        this.addRdnAttributesToEntry(addContext.getDn(), addContext.getEntry());
        this.next(addContext);
    }

    @Override
    public boolean compare(CompareOperationContext compareContext) throws LdapException {
        compareContext.getDn().apply(this.schemaManager);
        try {
            AttributeType attributeType = this.schemaManager.lookupAttributeTypeRegistry(compareContext.getOid());
            if (attributeType.getSyntax().isHumanReadable() && !compareContext.getValue().isHumanReadable()) {
                String value = compareContext.getValue().getString();
                compareContext.setValue(new StringValue(value));
            }
            compareContext.setAttributeType(attributeType);
        }
        catch (LdapException le) {
            throw new LdapInvalidAttributeTypeException(I18n.err(I18n.ERR_266, compareContext.getOid()));
        }
        return this.next(compareContext);
    }

    @Override
    public void delete(DeleteOperationContext deleteContext) throws LdapException {
        Dn dn = deleteContext.getDn();
        dn.apply(this.schemaManager);
        this.next(deleteContext);
    }

    @Override
    public boolean hasEntry(HasEntryOperationContext hasEntryContext) throws LdapException {
        hasEntryContext.getDn().apply(this.schemaManager);
        return this.next(hasEntryContext);
    }

    @Override
    public Entry lookup(LookupOperationContext lookupContext) throws LdapException {
        lookupContext.getDn().apply(this.schemaManager);
        return this.next(lookupContext);
    }

    @Override
    public void modify(ModifyOperationContext modifyContext) throws LdapException {
        modifyContext.getDn().apply(this.schemaManager);
        if (modifyContext.getModItems() != null) {
            for (Modification modification : modifyContext.getModItems()) {
                AttributeType attributeType = this.schemaManager.getAttributeType(modification.getAttribute().getId());
                modification.apply(attributeType);
            }
        }
        this.next(modifyContext);
    }

    @Override
    public void move(MoveOperationContext moveContext) throws LdapException {
        moveContext.getDn().apply(this.schemaManager);
        moveContext.getOldSuperior().apply(this.schemaManager);
        moveContext.getNewSuperior().apply(this.schemaManager);
        moveContext.getNewDn().apply(this.schemaManager);
        if (!moveContext.getRdn().isSchemaAware()) {
            moveContext.getRdn().apply(this.schemaManager);
        }
        this.next(moveContext);
    }

    @Override
    public void moveAndRename(MoveAndRenameOperationContext moveAndRenameContext) throws LdapException {
        if (!moveAndRenameContext.getNewRdn().isSchemaAware()) {
            moveAndRenameContext.getNewRdn().apply(this.schemaManager);
        }
        moveAndRenameContext.getDn().apply(this.schemaManager);
        moveAndRenameContext.getNewDn().apply(this.schemaManager);
        moveAndRenameContext.getNewSuperiorDn().apply(this.schemaManager);
        this.next(moveAndRenameContext);
    }

    @Override
    public void rename(RenameOperationContext renameContext) throws LdapException {
        renameContext.getDn().apply(this.schemaManager);
        renameContext.getNewRdn().apply(this.schemaManager);
        renameContext.getNewDn().apply(this.schemaManager);
        this.next(renameContext);
    }

    @Override
    public EntryFilteringCursor search(SearchOperationContext searchContext) throws LdapException {
        Dn dn = searchContext.getDn();
        dn.apply(this.schemaManager);
        ExprNode filter = searchContext.getFilter();
        if (filter == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext, this.schemaManager);
        }
        if ((filter = (ExprNode)filter.accept(this.normVisitor)) == null) {
            LOG.warn("undefined filter based on undefined attributeType not evaluted at all.  Returning empty enumeration.");
            return new BaseEntryFilteringCursor(new EmptyCursor<Entry>(), searchContext, this.schemaManager);
        }
        ExprNode modifiedFilter = this.removeObjectClass(filter);
        searchContext.setFilter(modifiedFilter);
        return this.next(searchContext);
    }

    private ExprNode handleBranchNode(ExprNode node, BranchNode newBranchNode) {
        int nbNodes = 0;
        for (ExprNode child : ((BranchNode)node).getChildren()) {
            ExprNode modifiedNode = this.removeObjectClass(child);
            if (modifiedNode instanceof ObjectClassNode) continue;
            newBranchNode.addNode(modifiedNode);
            ++nbNodes;
        }
        switch (nbNodes) {
            case 0: {
                return ObjectClassNode.OBJECT_CLASS_NODE;
            }
            case 1: {
                if (newBranchNode instanceof NotNode) {
                    return newBranchNode;
                }
                return newBranchNode.getFirstChild();
            }
        }
        return newBranchNode;
    }

    private ExprNode removeObjectClass(ExprNode node) {
        if (node instanceof PresenceNode && ((PresenceNode)node).getAttributeType() == OBJECT_CLASS_AT) {
            return ObjectClassNode.OBJECT_CLASS_NODE;
        }
        if (node instanceof AndNode) {
            AndNode newAndNode = new AndNode();
            return this.handleBranchNode(node, newAndNode);
        }
        if (node instanceof OrNode) {
            OrNode newOrNode = new OrNode();
            return this.handleBranchNode(node, newOrNode);
        }
        if (node instanceof NotNode) {
            NotNode newNotNode = new NotNode();
            return this.handleBranchNode(node, newNotNode);
        }
        return node;
    }

    private void addRdnAttributesToEntry(Dn dn, Entry entry) throws LdapException {
        if (dn == null || entry == null) {
            return;
        }
        Rdn rdn = dn.getRdn();
        for (Ava ava : rdn) {
            Value<?> value = ava.getNormValue();
            Value<?> upValue = ava.getValue();
            String upId = ava.getType();
            if (entry.contains(upId, value)) continue;
            String message = "The Rdn '" + upId + "=" + upValue + "' is not present in the entry";
            LOG.warn(message);
            if (!entry.containsAttribute(upId)) {
                entry.add(upId, upValue);
                continue;
            }
            AttributeType at = this.schemaManager.lookupAttributeTypeRegistry(upId);
            if (at.isSingleValued()) {
                entry.removeAttributes(upId);
                entry.add(upId, upValue);
                continue;
            }
            entry.add(upId, upValue);
        }
    }
}

