/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.modifyRequest;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoder;
import org.apache.directory.api.asn1.ber.tlv.IntegerDecoderException;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.codec.decorators.ModifyRequestDecorator;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreOperationType
extends GrammarAction<LdapMessageContainer<ModifyRequestDecorator>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreOperationType.class);
    private static final boolean IS_DEBUG = LOG.isDebugEnabled();

    public StoreOperationType() {
        super("Store Modify request operation type");
    }

    @Override
    public void action(LdapMessageContainer<ModifyRequestDecorator> container) throws DecoderException {
        ModifyRequestDecorator modifyRequestDecorator = container.getMessage();
        TLV tlv = container.getCurrentTLV();
        int operation = 0;
        try {
            operation = IntegerDecoder.parse(tlv.getValue(), 0, 2);
        }
        catch (IntegerDecoderException ide) {
            String msg = I18n.err(I18n.ERR_04082, Strings.dumpBytes(tlv.getValue().getData()));
            LOG.error(msg);
            throw new DecoderException(msg);
        }
        modifyRequestDecorator.setCurrentOperation(operation);
        if (IS_DEBUG) {
            switch (operation) {
                case 0: {
                    LOG.debug("Modification operation : ADD");
                    break;
                }
                case 1: {
                    LOG.debug("Modification operation : DELETE");
                    break;
                }
                case 2: {
                    LOG.debug("Modification operation : REPLACE");
                }
            }
        }
    }
}

