/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.HashSet;
import org.apache.directory.api.ldap.model.entry.Entry;
import org.apache.directory.api.ldap.model.exception.LdapNoSuchObjectException;
import org.apache.directory.api.ldap.model.filter.AbstractExprNode;
import org.apache.directory.api.ldap.model.filter.AndNode;
import org.apache.directory.api.ldap.model.filter.BranchNode;
import org.apache.directory.api.ldap.model.filter.ExprNode;
import org.apache.directory.api.ldap.model.filter.ObjectClassNode;
import org.apache.directory.api.ldap.model.filter.ScopeNode;
import org.apache.directory.api.ldap.model.message.AliasDerefMode;
import org.apache.directory.api.ldap.model.message.SearchScope;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.server.core.api.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.api.partition.Partition;
import org.apache.directory.server.core.partition.impl.btree.IndexCursorAdaptor;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.server.xdbm.search.Optimizer;
import org.apache.directory.server.xdbm.search.PartitionSearchResult;
import org.apache.directory.server.xdbm.search.SearchEngine;
import org.apache.directory.server.xdbm.search.evaluator.BaseLevelScopeEvaluator;
import org.apache.directory.server.xdbm.search.impl.CursorBuilder;
import org.apache.directory.server.xdbm.search.impl.EvaluatorBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSearchEngine
implements SearchEngine {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSearchEngine.class);
    private final Optimizer optimizer;
    private final Store db;
    private final CursorBuilder cursorBuilder;
    private final EvaluatorBuilder evaluatorBuilder;

    public DefaultSearchEngine(Store db, CursorBuilder cursorBuilder, EvaluatorBuilder evaluatorBuilder, Optimizer optimizer) {
        this.db = db;
        this.optimizer = optimizer;
        this.cursorBuilder = cursorBuilder;
        this.evaluatorBuilder = evaluatorBuilder;
    }

    @Override
    public Optimizer getOptimizer() {
        return this.optimizer;
    }

    @Override
    public PartitionSearchResult computeResult(SchemaManager schemaManager, SearchOperationContext searchContext) throws Exception {
        SearchScope scope = searchContext.getScope();
        Dn baseDn = searchContext.getDn();
        AliasDerefMode aliasDerefMode = searchContext.getAliasDerefMode();
        ExprNode filter = searchContext.getFilter();
        String baseId = this.db.getEntryId(baseDn);
        PartitionSearchResult searchResult = new PartitionSearchResult(schemaManager);
        HashSet<IndexEntry<String, String>> resultSet = new HashSet<IndexEntry<String, String>>();
        if (baseId == null) {
            if (((Partition)((Object)this.db)).getSuffixDn().equals(baseDn)) {
                searchResult.setResultSet(resultSet);
                return searchResult;
            }
            throw new LdapNoSuchObjectException(I18n.err(I18n.ERR_648, baseDn));
        }
        Dn aliasedBase = this.db.getAliasIndex().reverseLookup(baseId);
        Dn effectiveBase = baseDn;
        String effectiveBaseId = baseId;
        if (aliasedBase != null && aliasDerefMode.isDerefFindingBase()) {
            effectiveBase = aliasedBase.apply(schemaManager);
            effectiveBaseId = this.db.getEntryId(effectiveBase);
        }
        if (scope == SearchScope.OBJECT) {
            IndexEntry indexEntry = new IndexEntry();
            indexEntry.setId(effectiveBaseId);
            Entry entry = this.db.fetch((String)indexEntry.getId(), effectiveBase);
            Evaluator<ExprNode> evaluator = null;
            if (filter instanceof ObjectClassNode) {
                ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
                evaluator = new BaseLevelScopeEvaluator(this.db, node);
            } else {
                this.optimizer.annotate(filter);
                evaluator = this.evaluatorBuilder.build(filter);
                if (evaluator == null) {
                    ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
                    evaluator = new BaseLevelScopeEvaluator(this.db, node);
                }
            }
            indexEntry.setEntry(entry);
            resultSet.add(indexEntry);
            searchResult.setEvaluator(evaluator);
            searchResult.setResultSet(resultSet);
            return searchResult;
        }
        AbstractExprNode root = null;
        if (filter instanceof ObjectClassNode) {
            root = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
        } else {
            root = new AndNode();
            ((BranchNode)root).getChildren().add(filter);
            ScopeNode node = new ScopeNode(aliasDerefMode, effectiveBase, effectiveBaseId, scope);
            ((BranchNode)root).getChildren().add(node);
        }
        this.optimizer.annotate(root);
        Evaluator<ExprNode> evaluator = this.evaluatorBuilder.build(root);
        HashSet<String> uuidSet = new HashSet<String>();
        searchResult.setAliasDerefMode(aliasDerefMode);
        searchResult.setCandidateSet(uuidSet);
        long nbResults = this.cursorBuilder.build(root, searchResult);
        LOG.debug("Nb results : {} for filter : {}", (Object)nbResults, (Object)root);
        if (nbResults < Long.MAX_VALUE) {
            for (String uuid : uuidSet) {
                IndexEntry indexEntry = new IndexEntry();
                indexEntry.setId(uuid);
                resultSet.add(indexEntry);
            }
        } else {
            IndexCursorAdaptor cursor = new IndexCursorAdaptor(this.db.getMasterTable().cursor(), true);
            while (cursor.next()) {
                IndexEntry indexEntry = (IndexEntry)cursor.get();
                IndexEntry forwardIndexEntry = new IndexEntry();
                forwardIndexEntry.setKey(indexEntry.getKey());
                forwardIndexEntry.setId(indexEntry.getKey());
                forwardIndexEntry.setEntry(null);
                resultSet.add(forwardIndexEntry);
            }
        }
        searchResult.setEvaluator(evaluator);
        searchResult.setResultSet(resultSet);
        return searchResult;
    }

    @Override
    public Evaluator<? extends ExprNode> evaluator(ExprNode filter) throws Exception {
        return this.evaluatorBuilder.build(filter);
    }
}

