/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.model.schema.normalizers;

import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.model.entry.StringValue;
import org.apache.directory.api.ldap.model.entry.Value;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.api.ldap.model.name.Dn;
import org.apache.directory.api.ldap.model.schema.Normalizer;
import org.apache.directory.api.ldap.model.schema.SchemaManager;
import org.apache.directory.api.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UniqueMemberNormalizer
extends Normalizer {
    private SchemaManager schemaManager;

    public UniqueMemberNormalizer() {
        super("2.5.13.23");
    }

    @Override
    public Value<?> normalize(Value<?> value) throws LdapException {
        String nameAndUid = value.getString();
        if (nameAndUid.length() == 0) {
            return null;
        }
        int sharpPos = nameAndUid.lastIndexOf(35);
        if (sharpPos != -1) {
            if (nameAndUid.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = nameAndUid.substring(sharpPos + 1);
            if (sharpPos > 0) {
                Dn dn = new Dn(this.schemaManager, nameAndUid.substring(0, sharpPos));
                return new StringValue(dn.getNormName() + '#' + uid);
            }
            throw new IllegalStateException(I18n.err(I18n.ERR_04226, value.getClass()));
        }
        return new StringValue(new Dn(nameAndUid).getNormName());
    }

    @Override
    public String normalize(String value) throws LdapException {
        if (Strings.isEmpty(value)) {
            return null;
        }
        int sharpPos = value.lastIndexOf(35);
        if (sharpPos != -1) {
            if (value.indexOf(35) != sharpPos) {
                return null;
            }
            String uid = value.substring(sharpPos + 1);
            if (sharpPos > 0) {
                Dn dn = new Dn(this.schemaManager, value.substring(0, sharpPos));
                return dn.getNormName() + '#' + uid;
            }
            throw new IllegalStateException(I18n.err(I18n.ERR_04226, value.getClass()));
        }
        return new Dn(this.schemaManager, value).getNormName();
    }

    @Override
    public void setSchemaManager(SchemaManager schemaManager) {
        this.schemaManager = schemaManager;
    }
}

