/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.cursor;

import java.io.IOException;
import org.apache.directory.api.ldap.model.cursor.Cursor;
import org.apache.directory.api.ldap.model.cursor.CursorException;
import org.apache.directory.api.ldap.model.exception.LdapException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.ParentIdAndRdn;
import org.apache.directory.server.xdbm.Store;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenCursor
extends AbstractIndexCursor<String> {
    private static final Logger LOG_CURSOR = LoggerFactory.getLogger("CURSOR");
    private static final boolean IS_DEBUG = LOG_CURSOR.isDebugEnabled();
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_719, new Object[0]);
    private final Cursor<IndexEntry<ParentIdAndRdn, String>> cursor;
    private String parentId;
    private IndexEntry<String, String> prefetched;

    public ChildrenCursor(Store db, String parentId, Cursor<IndexEntry<ParentIdAndRdn, String>> cursor) throws Exception {
        this.parentId = parentId;
        this.cursor = cursor;
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Creating ChildrenCursor {}", (Object)this);
        }
    }

    @Override
    protected String getUnsupportedMessage() {
        return UNSUPPORTED_MSG;
    }

    @Override
    public void beforeFirst() throws LdapException, CursorException, IOException {
        this.checkNotClosed("beforeFirst()");
        this.setAvailable(false);
    }

    @Override
    public void afterLast() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean first() throws LdapException, CursorException, IOException {
        this.beforeFirst();
        return this.next();
    }

    @Override
    public boolean last() throws LdapException, CursorException, IOException {
        throw new UnsupportedOperationException(this.getUnsupportedMessage());
    }

    @Override
    public boolean previous() throws LdapException, CursorException, IOException {
        IndexEntry<ParentIdAndRdn, String> entry;
        this.checkNotClosed("next()");
        boolean hasPrevious = this.cursor.previous();
        if (hasPrevious && (entry = this.cursor.get()).getTuple().getKey().getParentId().equals(this.parentId)) {
            this.prefetched = entry;
            return true;
        }
        return false;
    }

    @Override
    public boolean next() throws LdapException, CursorException, IOException {
        this.checkNotClosed("next()");
        boolean hasNext = this.cursor.next();
        if (hasNext) {
            IndexEntry<ParentIdAndRdn, String> cursorEntry = this.cursor.get();
            IndexEntry<String, String> entry = new IndexEntry<String, String>();
            entry.setId(cursorEntry.getId());
            entry.setKey(cursorEntry.getTuple().getKey().getParentId());
            if (((String)entry.getKey()).equals(this.parentId)) {
                this.prefetched = entry;
                return true;
            }
        }
        return false;
    }

    @Override
    public IndexEntry<String, String> get() throws CursorException, IOException {
        this.checkNotClosed("get()");
        return this.prefetched;
    }

    @Override
    public void close() {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        this.cursor.close();
        super.close();
    }

    @Override
    public void close(Exception cause) {
        if (IS_DEBUG) {
            LOG_CURSOR.debug("Closing ChildrenCursor {}", (Object)this);
        }
        this.cursor.close(cause);
        super.close(cause);
    }

    @Override
    public String toString(String tabs) {
        StringBuilder sb = new StringBuilder();
        sb.append(tabs).append("ChildrenCursor (");
        if (this.available()) {
            sb.append("available)");
        } else {
            sb.append("absent)");
        }
        sb.append("#parent<").append(this.parentId).append("> :\n");
        sb.append(this.cursor.toString(tabs + "  "));
        return sb.toString();
    }

    public String toString() {
        return this.toString("");
    }
}

