/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.converter.schema;

import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.converter.schema.SchemaElement;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.exception.LdapException;
import org.apache.directory.shared.ldap.ldif.LdifUtils;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SchemaElementImpl
implements SchemaElement {
    protected String oid;
    protected String description;
    protected List<String> names = new ArrayList<String>();
    protected boolean obsolete = false;
    protected List<String> extensions = new ArrayList<String>();

    @Override
    public boolean isObsolete() {
        return this.obsolete;
    }

    @Override
    public void setObsolete(boolean obsolete) {
        this.obsolete = obsolete;
    }

    @Override
    public String getOid() {
        return this.oid;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public List<String> getNames() {
        return this.names;
    }

    @Override
    public void setNames(List<String> names) {
        this.names = names;
    }

    @Override
    public List<String> getExtensions() {
        return this.extensions;
    }

    @Override
    public void setExtensions(List<String> extensions) {
        this.extensions = extensions;
    }

    private String oidToLdif() {
        return "m-oid: " + this.oid + '\n';
    }

    private String nameToLdif() throws LdapException {
        if (this.names.size() == 0) {
            return "";
        }
        DefaultClientEntry entry = new DefaultClientEntry();
        DefaultClientAttribute attribute = new DefaultClientAttribute("m-name");
        for (String name : this.names) {
            attribute.add(name);
        }
        entry.put(attribute);
        return LdifUtils.convertAttributesToLdif(entry);
    }

    private String descToLdif() throws LdapException {
        if (StringTools.isEmpty(this.description)) {
            return "";
        }
        DefaultClientEntry entry = new DefaultClientEntry();
        DefaultClientAttribute attribute = new DefaultClientAttribute("m-description", this.description);
        entry.put(attribute);
        return LdifUtils.convertAttributesToLdif(entry);
    }

    public abstract String dnToLdif(String var1) throws LdapException;

    protected String extensionsToLdif(String ID) throws LdapException {
        StringBuilder sb = new StringBuilder();
        DefaultClientEntry entry = new DefaultClientEntry();
        DefaultClientAttribute attribute = new DefaultClientAttribute(ID);
        for (String extension : this.extensions) {
            attribute.add(extension);
        }
        sb.append(LdifUtils.convertAttributesToLdif(entry));
        return sb.toString();
    }

    protected String schemaToLdif(String schemaName, String type) throws LdapException {
        StringBuilder sb = new StringBuilder();
        sb.append(this.dnToLdif(schemaName));
        sb.append("objectclass: ").append(type).append('\n');
        sb.append("objectclass: metaTop\n");
        sb.append("objectclass: top\n");
        sb.append(this.oidToLdif());
        sb.append(this.nameToLdif());
        sb.append(this.descToLdif());
        if (this.obsolete) {
            sb.append("m-obsolete: TRUE\n");
        }
        return sb.toString();
    }
}

