/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import org.apache.directory.server.i18n.I18n;
import org.apache.directory.server.xdbm.AbstractIndexCursor;
import org.apache.directory.server.xdbm.ForwardIndexEntry;
import org.apache.directory.server.xdbm.IndexCursor;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.impl.SubstringEvaluator;
import org.apache.directory.shared.ldap.cursor.InvalidCursorPositionException;
import org.apache.directory.shared.ldap.entry.ServerEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubstringCursor<ID>
extends AbstractIndexCursor<String, ServerEntry, ID> {
    private static final String UNSUPPORTED_MSG = I18n.err(I18n.ERR_725, new Object[0]);
    private final boolean hasIndex;
    private final IndexCursor<String, ServerEntry, ID> wrapped;
    private final SubstringEvaluator<ID> evaluator;
    private final ForwardIndexEntry<String, ServerEntry, ID> indexEntry = new ForwardIndexEntry();
    private boolean available = false;

    public SubstringCursor(Store<ServerEntry, ID> db, SubstringEvaluator<ID> substringEvaluator) throws Exception {
        this.evaluator = substringEvaluator;
        this.hasIndex = db.hasIndexOn(this.evaluator.getExpression().getAttribute());
        this.wrapped = this.hasIndex ? db.getIndex(this.evaluator.getExpression().getAttribute()).forwardCursor() : db.getNdnIndex().forwardCursor();
    }

    @Override
    public boolean available() {
        return this.available;
    }

    @Override
    public void beforeValue(ID id, String value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void afterValue(ID id, String value) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void before(IndexEntry<String, ServerEntry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void after(IndexEntry<String, ServerEntry, ID> element) throws Exception {
        throw new UnsupportedOperationException(UNSUPPORTED_MSG);
    }

    @Override
    public void beforeFirst() throws Exception {
        this.checkNotClosed("beforeFirst()");
        if (this.evaluator.getExpression().getInitial() != null && this.hasIndex) {
            ForwardIndexEntry indexEntry = new ForwardIndexEntry();
            indexEntry.setValue(this.evaluator.getExpression().getInitial());
            this.wrapped.before((ServerEntry)((Object)indexEntry));
        } else {
            this.wrapped.beforeFirst();
        }
        this.clear();
    }

    private void clear() {
        this.available = false;
        this.indexEntry.setObject(null);
        this.indexEntry.setId(null);
        this.indexEntry.setValue(null);
    }

    @Override
    public void afterLast() throws Exception {
        this.checkNotClosed("afterLast()");
        this.wrapped.afterLast();
        this.clear();
    }

    @Override
    public boolean first() throws Exception {
        this.beforeFirst();
        return this.next();
    }

    private boolean evaluateCandidate(IndexEntry<String, ServerEntry, ID> indexEntry) throws Exception {
        if (this.hasIndex) {
            return this.evaluator.getPattern().matcher(indexEntry.getValue()).matches();
        }
        return this.evaluator.evaluate(indexEntry);
    }

    @Override
    public boolean last() throws Exception {
        this.afterLast();
        return this.previous();
    }

    @Override
    public boolean previous() throws Exception {
        while (this.wrapped.previous()) {
            this.checkNotClosed("previous()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.available = true;
            this.indexEntry.setId(entry.getId());
            this.indexEntry.setValue((String)entry.getValue());
            this.indexEntry.setObject((ServerEntry)entry.getObject());
            return true;
        }
        this.clear();
        return false;
    }

    @Override
    public boolean next() throws Exception {
        while (this.wrapped.next()) {
            this.checkNotClosed("next()");
            IndexEntry entry = (IndexEntry)this.wrapped.get();
            if (!this.evaluateCandidate(entry)) continue;
            this.available = true;
            this.indexEntry.setId(entry.getId());
            this.indexEntry.setValue((String)entry.getValue());
            this.indexEntry.setObject((ServerEntry)entry.getObject());
            return true;
        }
        this.clear();
        return false;
    }

    @Override
    public IndexEntry<String, ServerEntry, ID> get() throws Exception {
        this.checkNotClosed("get()");
        if (this.available) {
            return this.indexEntry;
        }
        throw new InvalidCursorPositionException(I18n.err(I18n.ERR_708, new Object[0]));
    }

    @Override
    public boolean isElementReused() {
        return this.wrapped.isElementReused();
    }

    @Override
    public void close() throws Exception {
        super.close();
        this.wrapped.close();
        this.clear();
    }
}

