/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers.bind.ntlm;

import javax.security.sasl.SaslServer;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.bind.AbstractMechanismHandler;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmProvider;
import org.apache.directory.server.ldap.handlers.bind.ntlm.NtlmSaslServer;
import org.apache.directory.shared.ldap.message.internal.InternalBindRequest;

public class NtlmMechanismHandler
extends AbstractMechanismHandler {
    private String providerFqcn;
    private NtlmProvider provider;

    public void setNtlmProvider(NtlmProvider provider) {
        this.provider = provider;
    }

    public void setNtlmProviderFqcn(String fqcnProvider) {
        this.providerFqcn = fqcnProvider;
    }

    public SaslServer handleMechanism(LdapSession ldapSession, InternalBindRequest bindRequest) throws Exception {
        SaslServer ss = (SaslServer)ldapSession.getSaslProperty("saslServer");
        if (ss == null) {
            if (this.provider == null) {
                this.initProvider();
            }
            ss = new NtlmSaslServer(this.provider, bindRequest, ldapSession);
            ldapSession.putSaslProperty("saslServer", ss);
        }
        return ss;
    }

    private void initProvider() throws Exception {
        this.provider = (NtlmProvider)Class.forName(this.providerFqcn).newInstance();
    }

    public void init(LdapSession ldapSession) {
        String saslHost = ldapSession.getLdapServer().getSaslHost();
        ldapSession.putSaslProperty("host", saslHost);
    }

    public void cleanup(LdapSession ldapSession) {
        ldapSession.removeSaslProperty("host");
        ldapSession.removeSaslProperty("userBaseDn");
        ldapSession.removeSaslProperty("saslMech");
        ldapSession.removeSaslProperty("saslProps");
        ldapSession.removeSaslProperty("saslAuthentUser");
    }
}

