/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.ldap.LdapSession;
import org.apache.directory.server.ldap.handlers.LdapRequestHandler;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.message.internal.InternalLdapResult;
import org.apache.directory.shared.ldap.message.internal.InternalModifyDnRequest;
import org.apache.directory.shared.ldap.name.DN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModifyDnHandler
extends LdapRequestHandler<InternalModifyDnRequest> {
    private static final Logger LOG = LoggerFactory.getLogger(ModifyDnHandler.class);

    @Override
    public void handle(LdapSession session, InternalModifyDnRequest req) {
        InternalLdapResult result = req.getResultResponse().getLdapResult();
        LOG.debug("Handling modify dn request while ignoring referrals: {}", req);
        if (req.getName().isEmpty()) {
            String msg = "Modify DN is not allowed on Root DSE.";
            result.setResultCode(ResultCodeEnum.PROTOCOL_ERROR);
            result.setErrorMessage(msg);
            session.getIoSession().write(req.getResultResponse());
            return;
        }
        try {
            DN newRdn = new DN(req.getNewRdn().getName());
            newRdn.normalize(session.getCoreSession().getDirectoryService().getSchemaManager().getNormalizerMapping());
            DN oldRdn = new DN(req.getName().getRdn().getName());
            oldRdn.normalize(session.getCoreSession().getDirectoryService().getSchemaManager().getNormalizerMapping());
            boolean rdnChanged = req.getNewRdn() != null && !newRdn.getNormName().equals(oldRdn.getNormName());
            CoreSession coreSession = session.getCoreSession();
            if (rdnChanged) {
                if (req.getNewSuperior() != null) {
                    coreSession.moveAndRename(req);
                } else {
                    coreSession.rename(req);
                }
            } else if (req.getNewSuperior() != null) {
                req.setNewRdn(null);
                coreSession.move(req);
            } else {
                result.setErrorMessage("Attempt to move entry onto itself.");
                result.setResultCode(ResultCodeEnum.ENTRY_ALREADY_EXISTS);
                result.setMatchedDn(req.getName());
                session.getIoSession().write(req.getResultResponse());
                return;
            }
            result.setResultCode(ResultCodeEnum.SUCCESS);
            session.getIoSession().write(req.getResultResponse());
        }
        catch (Exception e) {
            this.handleException(session, req, e);
        }
    }
}

