/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.factory;

import java.io.File;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.directory.server.core.DefaultDirectoryService;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.factory.DirectoryServiceFactory;
import org.apache.directory.server.core.factory.JdbmPartitionFactory;
import org.apache.directory.server.core.factory.PartitionFactory;
import org.apache.directory.server.core.partition.Partition;
import org.apache.directory.server.core.partition.ldif.LdifPartition;
import org.apache.directory.server.core.schema.SchemaPartition;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.DefaultSchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.loader.ldif.LdifSchemaLoader;
import org.apache.directory.shared.ldap.schema.manager.impl.DefaultSchemaManager;
import org.apache.directory.shared.ldap.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDirectoryServiceFactory
implements DirectoryServiceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDirectoryServiceFactory.class);
    public static final DirectoryServiceFactory DEFAULT = new DefaultDirectoryServiceFactory();
    private DirectoryService directoryService;
    private PartitionFactory partitionFactory;

    DefaultDirectoryServiceFactory() {
        try {
            this.directoryService = new DefaultDirectoryService();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String typeName = System.getProperty("apacheds.partition.factory");
            if (typeName != null) {
                Class<?> type = Class.forName(typeName);
                this.partitionFactory = (PartitionFactory)type.newInstance();
            } else {
                this.partitionFactory = new JdbmPartitionFactory();
            }
        }
        catch (Exception e) {
            LOG.error("Error instantiating custom partiton factory", e);
            throw new RuntimeException(e);
        }
    }

    public void init(String name) throws Exception {
        if (this.directoryService != null && this.directoryService.isStarted()) {
            return;
        }
        this.build(name);
    }

    private void buildWorkingDirectory(String name) {
        String workingDirectory = System.getProperty("workingDirectory");
        if (workingDirectory == null) {
            workingDirectory = System.getProperty("java.io.tmpdir") + "/server-work-" + name;
        }
        this.directoryService.setWorkingDirectory(new File(workingDirectory));
    }

    private void initSchema() throws Exception {
        SchemaPartition schemaPartition = this.directoryService.getSchemaService().getSchemaPartition();
        LdifPartition ldifPartition = new LdifPartition();
        String workingDirectory = this.directoryService.getWorkingDirectory().getPath();
        ldifPartition.setWorkingDirectory(workingDirectory + "/schema");
        File schemaRepository = new File(workingDirectory, "schema");
        DefaultSchemaLdifExtractor extractor = new DefaultSchemaLdifExtractor(new File(workingDirectory));
        extractor.extractOrCopy();
        schemaPartition.setWrappedPartition(ldifPartition);
        LdifSchemaLoader loader = new LdifSchemaLoader(schemaRepository);
        DefaultSchemaManager schemaManager = new DefaultSchemaManager(loader);
        this.directoryService.setSchemaManager(schemaManager);
        schemaManager.loadAllEnabled();
        schemaPartition.setSchemaManager(schemaManager);
        List<Throwable> errors = schemaManager.getErrors();
        if (errors.size() != 0) {
            throw new Exception(I18n.err(I18n.ERR_317, ExceptionUtils.printErrors(errors)));
        }
    }

    private void initSystemPartition() throws Exception {
        Partition systemPartition = this.partitionFactory.createPartition("system", "ou=system", 500, new File(this.directoryService.getWorkingDirectory(), "system"));
        systemPartition.setSchemaManager(this.directoryService.getSchemaManager());
        this.partitionFactory.addIndex(systemPartition, "objectClass", 100);
        this.directoryService.setSystemPartition(systemPartition);
    }

    private void build(String name) throws Exception {
        this.directoryService.setInstanceId(name);
        this.buildWorkingDirectory(name);
        String workingDirectoryPath = this.directoryService.getWorkingDirectory().getPath();
        File workingDirectory = new File(workingDirectoryPath);
        FileUtils.deleteDirectory((File)workingDirectory);
        this.initSchema();
        this.initSystemPartition();
        this.directoryService.startup();
    }

    public DirectoryService getDirectoryService() throws Exception {
        return this.directoryService;
    }

    public PartitionFactory getPartitionFactory() throws Exception {
        return this.partitionFactory;
    }
}

