/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.parsers;

import antlr.RecognitionException;
import antlr.TokenStreamException;
import java.text.ParseException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.schema.parsers.AbstractSchemaParser;
import org.apache.directory.shared.ldap.schema.parsers.NormalizerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NormalizerDescriptionSchemaParser
extends AbstractSchemaParser {
    protected static final Logger LOG = LoggerFactory.getLogger(NormalizerDescriptionSchemaParser.class);

    public synchronized NormalizerDescription parseNormalizerDescription(String normalizerDescription) throws ParseException {
        LOG.debug("Parsing a Normalizer : {}", (Object)normalizerDescription);
        if (normalizerDescription == null) {
            LOG.error(I18n.err("ERR_04251", new Object[0]));
            throw new ParseException("Null", 0);
        }
        this.reset(normalizerDescription);
        try {
            NormalizerDescription normalizer = this.parser.normalizerDescription();
            this.setSchemaName(normalizer);
            return normalizer;
        }
        catch (RecognitionException re) {
            String msg = I18n.err("ERR_04252", normalizerDescription, re.getMessage(), re.getColumn());
            LOG.error(msg);
            throw new ParseException(msg, re.getColumn());
        }
        catch (TokenStreamException tse) {
            String msg = I18n.err("ERR_04253", normalizerDescription, tse.getMessage());
            LOG.error(msg);
            throw new ParseException(msg, 0);
        }
    }

    public NormalizerDescription parse(String schemaDescription) throws ParseException {
        return this.parseNormalizerDescription(schemaDescription);
    }
}

