/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.ldif.extractor.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.ldif.LdifReader;
import org.apache.directory.shared.ldap.schema.ldif.extractor.SchemaLdifExtractor;
import org.apache.directory.shared.ldap.schema.ldif.extractor.UniqueResourceException;
import org.apache.directory.shared.ldap.schema.ldif.extractor.impl.ResourceMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSchemaLdifExtractor
implements SchemaLdifExtractor {
    private static final String BASE_PATH = "";
    private static final String SCHEMA_SUBDIR = "schema";
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchemaLdifExtractor.class);
    private boolean extracted;
    private File outputDirectory;
    private File schemaDirectory;

    public DefaultSchemaLdifExtractor(File outputDirectory) {
        LOG.debug("BASE_PATH set to {}, outputDirectory set to {}", (Object)BASE_PATH, (Object)outputDirectory);
        this.outputDirectory = outputDirectory;
        this.schemaDirectory = new File(outputDirectory, SCHEMA_SUBDIR);
        if (!outputDirectory.exists()) {
            LOG.debug("Creating output directory: {}", outputDirectory);
            if (!outputDirectory.mkdir()) {
                LOG.error("Failed to create outputDirectory: {}", outputDirectory);
            }
        } else {
            LOG.debug("Output directory exists: no need to create.");
        }
        if (!this.schemaDirectory.exists()) {
            LOG.info("Schema directory '{}' does NOT exist: extracted state set to false.", this.schemaDirectory);
            this.extracted = false;
        } else {
            LOG.info("Schema directory '{}' does exist: extracted state set to true.", this.schemaDirectory);
            this.extracted = true;
        }
    }

    @Override
    public boolean isExtracted() {
        return this.extracted;
    }

    @Override
    public void extractOrCopy(boolean overwrite) throws IOException {
        File schemaDirectory;
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdir();
        }
        if (!(schemaDirectory = new File(this.outputDirectory, SCHEMA_SUBDIR)).exists()) {
            schemaDirectory.mkdir();
        } else if (!overwrite) {
            throw new IOException(I18n.err("ERR_08001", schemaDirectory.getAbsolutePath()));
        }
        Pattern pattern = Pattern.compile(".*schema/ou=schema.*\\.ldif");
        Map<String, Boolean> list = ResourceMap.getResources(pattern);
        for (Map.Entry<String, Boolean> entry : list.entrySet()) {
            if (entry.getValue().booleanValue()) {
                this.extractFromJar(entry.getKey());
                continue;
            }
            File resource = new File(entry.getKey());
            this.copyFile(resource, this.getDestinationFile(resource));
        }
    }

    @Override
    public void extractOrCopy() throws IOException {
        this.extractOrCopy(false);
    }

    private void copyFile(File source, File destination) throws IOException {
        LOG.debug("copyFile(): source = {}, destination = {}", source, (Object)destination);
        if (!destination.getParentFile().exists()) {
            destination.getParentFile().mkdirs();
        }
        if (!source.getParentFile().exists()) {
            throw new FileNotFoundException(I18n.err("ERR_08002", source.getAbsolutePath()));
        }
        FileWriter out = new FileWriter(destination);
        try {
            LdifReader ldifReader = new LdifReader(source);
            boolean first = true;
            LdifEntry ldifEntry = null;
            while (ldifReader.hasNext()) {
                if (first) {
                    ldifEntry = ldifReader.next();
                    if (ldifEntry.get("entryUUID") == null) {
                        UUID entryUuid = UUID.randomUUID();
                        ldifEntry.addAttribute("entryUUID", entryUuid.toString());
                    }
                    first = false;
                    continue;
                }
                String msg = I18n.err("ERR_08003", source);
                LOG.error(msg);
                throw new InvalidObjectException(msg);
            }
            ldifReader.close();
            String ldifString = "version: 1\n" + ldifEntry.toString();
            out.write(ldifString);
            out.flush();
        }
        catch (NamingException ne) {
            String msg = I18n.err("ERR_08004", source, ne.getLocalizedMessage());
            LOG.error(msg);
            throw new InvalidObjectException(msg);
        }
        finally {
            out.close();
        }
    }

    private File assembleDestinationFile(Stack<String> fileComponentStack) {
        File destinationFile = this.outputDirectory.getAbsoluteFile();
        while (!fileComponentStack.isEmpty()) {
            destinationFile = new File(destinationFile, fileComponentStack.pop());
        }
        return destinationFile;
    }

    private File getDestinationFile(File resource) {
        Stack<String> fileComponentStack = new Stack<String>();
        fileComponentStack.push(resource.getName());
        for (File parent = resource.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (parent.getName().equals(SCHEMA_SUBDIR)) {
                fileComponentStack.push(SCHEMA_SUBDIR);
                return this.assembleDestinationFile(fileComponentStack);
            }
            fileComponentStack.push(parent.getName());
            if (!parent.equals(parent.getParentFile()) && parent.getParentFile() != null) continue;
            throw new IllegalStateException(I18n.err("ERR_08005", new Object[0]));
        }
        throw new IllegalStateException(I18n.err("ERR_08006", new Object[0]));
    }

    public static InputStream getUniqueResourceAsStream(String resourceName, String resourceDescription) throws IOException {
        resourceName = BASE_PATH + resourceName;
        URL result = DefaultSchemaLdifExtractor.getUniqueResource(resourceName, resourceDescription);
        return result.openStream();
    }

    public static URL getUniqueResource(String resourceName, String resourceDescription) throws IOException {
        Enumeration<URL> resources = DefaultSchemaLdifExtractor.class.getClassLoader().getResources(resourceName);
        if (!resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, resourceDescription);
        }
        URL result = resources.nextElement();
        if (resources.hasMoreElements()) {
            throw new UniqueResourceException(resourceName, result, resources, resourceDescription);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFromJar(String resource) throws IOException {
        byte[] buf = new byte[512];
        InputStream in = DefaultSchemaLdifExtractor.getUniqueResourceAsStream(resource, "LDIF file in schema repository");
        try {
            File destination = new File(this.outputDirectory, resource);
            if (destination.exists()) {
                return;
            }
            if (!destination.getParentFile().exists()) {
                destination.getParentFile().mkdirs();
            }
            FileOutputStream out = new FileOutputStream(destination);
            try {
                while (in.available() > 0) {
                    int readCount = in.read(buf);
                    out.write(buf, 0, readCount);
                }
                out.flush();
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }
}

