/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema;

import java.util.HashSet;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.schema.AbstractSchemaObject;
import org.apache.directory.shared.ldap.schema.DescriptionUtils;
import org.apache.directory.shared.ldap.schema.LdapSyntax;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.SchemaObjectType;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.schema.registries.Registries;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AttributeType
extends AbstractSchemaObject
implements Cloneable {
    private static final Logger LOG = LoggerFactory.getLogger(AttributeType.class);
    public static final long serialVersionUID = 1L;
    private String syntaxOid;
    private LdapSyntax syntax;
    private String equalityOid;
    private MatchingRule equality;
    private String substringOid;
    private MatchingRule substring;
    private String orderingOid;
    private MatchingRule ordering;
    private String superiorOid;
    private AttributeType superior;
    private boolean isSingleValued = false;
    private boolean isCollective = false;
    private boolean canUserModify = true;
    private UsageEnum usage = UsageEnum.USER_APPLICATIONS;
    private int syntaxLength = 0;

    public AttributeType(String oid) {
        super(SchemaObjectType.ATTRIBUTE_TYPE, oid);
    }

    private boolean buildSuperior(List<Throwable> errors, Registries registries) {
        AttributeType superior = null;
        AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
        if (this.superiorOid != null) {
            try {
                superior = (AttributeType)attributeTypeRegistry.lookup(this.superiorOid);
            }
            catch (Exception e) {
                String msg = I18n.err("ERR_04303", this.superiorOid, this.getName());
                LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                errors.add(error);
                LOG.info(msg);
                return false;
            }
            if (superior != null) {
                this.superior = superior;
                if (superior.getSuperior() == null) {
                    registries.buildReference(errors, superior);
                }
                try {
                    attributeTypeRegistry.registerDescendants(this, superior);
                }
                catch (NamingException ne) {
                    errors.add(ne);
                    LOG.info(ne.getMessage());
                    return false;
                }
                HashSet<String> superiors = new HashSet<String>();
                superiors.add(this.oid);
                boolean isOk = true;
                for (AttributeType tmp = superior; tmp != null; tmp = tmp.getSuperior()) {
                    if (superiors.contains(tmp.getOid())) {
                        String msg = I18n.err("ERR_04304", this.getName());
                        LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                        errors.add(error);
                        LOG.info(msg);
                        isOk = false;
                        break;
                    }
                    superiors.add(tmp.getOid());
                }
                superiors.clear();
                return isOk;
            }
            String msg = I18n.err("ERR_04305", this.superiorOid, this.getName());
            LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            errors.add(error);
            LOG.info(msg);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildSyntax(List<Throwable> errors, Registries registries) {
        if (this.syntaxOid != null) {
            LdapSyntax syntax = null;
            try {
                syntax = (LdapSyntax)registries.getLdapSyntaxRegistry().lookup(this.syntaxOid);
            }
            catch (NamingException ne) {
                String msg = I18n.err("ERR_04306", this.syntaxOid, this.getName());
                LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                errors.add(error);
                LOG.info(msg);
                return;
            }
            if (syntax != null) {
                this.syntax = syntax;
                return;
            }
            String msg = I18n.err("ERR_04306", this.syntaxOid, this.getName());
            LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            errors.add(error);
            LOG.info(msg);
            return;
        }
        if (this.superior != null) {
            this.syntax = this.superior.getSyntax();
            this.syntaxOid = this.syntax.getOid();
            return;
        }
        String msg = I18n.err("ERR_04307", this.getName());
        LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
        errors.add(error);
        LOG.info(msg);
    }

    private void buildEquality(List<Throwable> errors, Registries registries) {
        if (this.equalityOid != null) {
            MatchingRule equality = null;
            try {
                equality = (MatchingRule)registries.getMatchingRuleRegistry().lookup(this.equalityOid);
            }
            catch (NamingException ne) {
                String msg = I18n.err("ERR_04308", this.equalityOid, this.getName());
                LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                errors.add(error);
                LOG.info(msg);
                return;
            }
            if (equality != null) {
                this.equality = equality;
            } else {
                String msg = I18n.err("ERR_04309", this.equalityOid, this.getName());
                LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                errors.add(error);
                LOG.info(msg);
            }
        } else if (this.superior != null && this.superior.getEquality() != null) {
            this.equality = this.superior.getEquality();
            this.equalityOid = this.equality.getOid();
        }
    }

    private void buildOrdering(List<Throwable> errors, Registries registries) {
        if (this.orderingOid != null) {
            MatchingRule ordering = null;
            try {
                ordering = (MatchingRule)registries.getMatchingRuleRegistry().lookup(this.orderingOid);
            }
            catch (NamingException ne) {
                String msg = I18n.err("ERR_04310", this.orderingOid, this.getName());
                LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                errors.add(error);
                LOG.info(msg);
                return;
            }
            if (ordering != null) {
                this.ordering = ordering;
            } else {
                String msg = I18n.err("ERR_04311", this.orderingOid, this.getName());
                LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
                errors.add(error);
                LOG.info(msg);
            }
        } else if (this.superior != null && this.superior.getOrdering() != null) {
            this.ordering = this.superior.getOrdering();
            this.orderingOid = this.ordering.getOid();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildSubstring(List<Throwable> errors, Registries registries) {
        if (this.substringOid == null) {
            if (this.superior == null) return;
            if (this.superior.getSubstring() == null) return;
            this.substring = this.superior.getSubstring();
            this.substringOid = this.substring.getOid();
            return;
        }
        MatchingRule substring = null;
        try {
            substring = (MatchingRule)registries.getMatchingRuleRegistry().lookup(this.substringOid);
        }
        catch (NamingException ne) {
            String msg = I18n.err("ERR_04312", this.substringOid, this.getName());
            LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            errors.add(error);
            LOG.info(msg);
            return;
        }
        if (substring != null) {
            this.substring = substring;
            return;
        }
        String msg = I18n.err("ERR_04313", this.substringOid, this.getName());
        LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
        errors.add(error);
        LOG.info(msg);
    }

    private void checkUsage(List<Throwable> errors, Registries registries) {
        if (this.superior != null && this.usage != this.superior.getUsage()) {
            String msg = I18n.err("ERR_04314", this.getName());
            LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            errors.add(error);
            LOG.info(msg);
            return;
        }
        if (!this.isUserModifiable() && this.usage == UsageEnum.USER_APPLICATIONS) {
            String msg = I18n.err("ERR_04315", this.getName());
            LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            errors.add(error);
            LOG.info(msg);
        }
    }

    private void checkCollective(List<Throwable> errors, Registries registries) {
        if (this.superior != null && this.superior.isCollective()) {
            this.isCollective = true;
        }
        if (this.isCollective() && this.usage != UsageEnum.USER_APPLICATIONS) {
            String msg = I18n.err("ERR_04316", this.getName());
            LdapSchemaViolationException error = new LdapSchemaViolationException(msg, ResultCodeEnum.INVALID_ATTRIBUTE_SYNTAX);
            errors.add(error);
            LOG.info(msg);
        }
    }

    @Override
    public void addToRegistries(List<Throwable> errors, Registries registries) throws NamingException {
        if (registries != null) {
            AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
            if (!this.buildSuperior(errors, registries)) {
                return;
            }
            this.buildSyntax(errors, registries);
            this.buildEquality(errors, registries);
            this.buildOrdering(errors, registries);
            this.buildSubstring(errors, registries);
            this.checkUsage(errors, registries);
            this.checkCollective(errors, registries);
            attributeTypeRegistry.addMappingFor(this);
            attributeTypeRegistry.registerDescendants(this, this.superior);
            if (this.equality != null) {
                registries.addReference(this, this.equality);
            }
            if (this.ordering != null) {
                registries.addReference(this, this.ordering);
            }
            if (this.substring != null) {
                registries.addReference(this, this.substring);
            }
            if (this.syntax != null) {
                registries.addReference(this, this.syntax);
            }
            if (this.superior != null) {
                registries.addReference(this, this.superior);
            }
        }
    }

    @Override
    public void removeFromRegistries(List<Throwable> errors, Registries registries) throws NamingException {
        if (registries != null) {
            AttributeTypeRegistry attributeTypeRegistry = registries.getAttributeTypeRegistry();
            attributeTypeRegistry.removeMappingFor(this);
            attributeTypeRegistry.unregisterDescendants(this, this.superior);
            if (this.equality != null) {
                registries.delReference(this, this.equality);
            }
            if (this.ordering != null) {
                registries.delReference(this, this.ordering);
            }
            if (this.substring != null) {
                registries.delReference(this, this.substring);
            }
            if (this.syntax != null) {
                registries.delReference(this, this.syntax);
            }
            if (this.superior != null) {
                registries.delReference(this, this.superior);
            }
        }
    }

    public boolean isSingleValued() {
        return this.isSingleValued;
    }

    public void setSingleValued(boolean singleValued) {
        if (!this.isReadOnly) {
            this.isSingleValued = singleValued;
        }
    }

    public boolean isUserModifiable() {
        return this.canUserModify;
    }

    public void setUserModifiable(boolean canUserModify) {
        if (!this.isReadOnly) {
            this.canUserModify = canUserModify;
        }
    }

    public boolean isCollective() {
        return this.isCollective;
    }

    public void updateCollective(boolean collective) {
        this.isCollective = collective;
    }

    public void setCollective(boolean collective) {
        if (!this.isReadOnly) {
            this.isCollective = collective;
        }
    }

    public UsageEnum getUsage() {
        return this.usage;
    }

    public void setUsage(UsageEnum usage) {
        if (!this.isReadOnly) {
            this.usage = usage;
        }
    }

    public void updateUsage(UsageEnum usage) {
        this.usage = usage;
    }

    public int getSyntaxLength() {
        return this.syntaxLength;
    }

    public void setSyntaxLength(int length) {
        if (!this.isReadOnly) {
            this.syntaxLength = length;
        }
    }

    public AttributeType getSuperior() {
        return this.superior;
    }

    public String getSuperiorOid() {
        return this.superiorOid;
    }

    public String getSuperiorName() {
        if (this.superior != null) {
            return this.superior.getName();
        }
        return this.superiorOid;
    }

    public void setSuperiorOid(String superiorOid) {
        if (!this.isReadOnly) {
            this.superiorOid = superiorOid;
        }
    }

    public void setSuperior(AttributeType superior) {
        if (!this.isReadOnly) {
            this.superior = superior;
            this.superiorOid = superior.getOid();
        }
    }

    public void setSuperior(String superiorOid) {
        if (!this.isReadOnly) {
            this.superiorOid = superiorOid;
        }
    }

    public void updateSuperior(AttributeType superior) {
        this.superior = superior;
        this.superiorOid = superior.getOid();
    }

    public LdapSyntax getSyntax() {
        return this.syntax;
    }

    public String getSyntaxName() {
        if (this.syntax != null) {
            return this.syntax.getName();
        }
        return null;
    }

    public String getSyntaxOid() {
        return this.syntaxOid;
    }

    public void setSyntaxOid(String syntaxOid) {
        if (!this.isReadOnly) {
            this.syntaxOid = syntaxOid;
        }
    }

    public void setSyntax(LdapSyntax syntax) {
        if (!this.isReadOnly) {
            this.syntax = syntax;
            this.syntaxOid = syntax.getOid();
        }
    }

    public void updateSyntax(LdapSyntax syntax) {
        this.syntax = syntax;
        this.syntaxOid = syntax.getOid();
    }

    public MatchingRule getEquality() {
        return this.equality;
    }

    public String getEqualityOid() {
        return this.equalityOid;
    }

    public String getEqualityName() {
        if (this.equality != null) {
            return this.equality.getName();
        }
        return this.equalityOid;
    }

    public void setEqualityOid(String equalityOid) {
        if (!this.isReadOnly) {
            this.equalityOid = equalityOid;
        }
    }

    public void setEquality(MatchingRule equality) {
        if (!this.isReadOnly) {
            this.equality = equality;
            this.equalityOid = equality.getOid();
        }
    }

    public void updateEquality(MatchingRule equality) {
        this.equality = equality;
        this.equalityOid = equality.getOid();
    }

    public MatchingRule getOrdering() {
        return this.ordering;
    }

    public String getOrderingName() {
        if (this.ordering != null) {
            return this.ordering.getName();
        }
        return this.orderingOid;
    }

    public String getOrderingOid() {
        return this.orderingOid;
    }

    public void setOrderingOid(String orderingOid) {
        if (!this.isReadOnly) {
            this.orderingOid = orderingOid;
        }
    }

    public void setOrdering(MatchingRule ordering) {
        if (!this.isReadOnly) {
            this.ordering = ordering;
            this.orderingOid = ordering.getOid();
        }
    }

    public void updateOrdering(MatchingRule ordering) {
        this.ordering = ordering;
        this.orderingOid = ordering.getOid();
    }

    public MatchingRule getSubstring() {
        return this.substring;
    }

    public String getSubstringName() {
        if (this.substring != null) {
            return this.substring.getName();
        }
        return this.substringOid;
    }

    public String getSubstringOid() {
        return this.substringOid;
    }

    public void setSubstringOid(String substrOid) {
        if (!this.isReadOnly) {
            this.substringOid = substrOid;
        }
    }

    public void setSubstring(MatchingRule substring) {
        if (!this.isReadOnly) {
            this.substring = substring;
            this.substringOid = substring.getOid();
        }
    }

    public void updateSubstring(MatchingRule substring) {
        this.substring = substring;
        this.substringOid = substring.getOid();
    }

    public boolean isAncestorOf(AttributeType descendant) {
        if (descendant == null || this.equals(descendant)) {
            return false;
        }
        return this.isAncestorOrEqual(this, descendant);
    }

    public boolean isDescendantOf(AttributeType ancestor) {
        if (ancestor == null || this.equals(ancestor)) {
            return false;
        }
        return this.isAncestorOrEqual(ancestor, this);
    }

    private boolean isAncestorOrEqual(AttributeType ancestor, AttributeType descendant) {
        if (ancestor == null || descendant == null) {
            return false;
        }
        if (ancestor.equals(descendant)) {
            return true;
        }
        return this.isAncestorOrEqual(ancestor, descendant.getSuperior());
    }

    public String toString() {
        return (Object)((Object)this.objectType) + " " + DescriptionUtils.getDescription(this);
    }

    @Override
    public AttributeType copy() {
        AttributeType copy = new AttributeType(this.oid);
        copy.copy(this);
        copy.canUserModify = this.canUserModify;
        copy.isCollective = this.isCollective;
        copy.isSingleValued = this.isSingleValued;
        copy.usage = this.usage;
        copy.equality = null;
        copy.equalityOid = this.equalityOid;
        copy.ordering = null;
        copy.orderingOid = this.orderingOid;
        copy.substring = null;
        copy.substringOid = this.substringOid;
        copy.superior = null;
        copy.superiorOid = this.superiorOid;
        copy.syntax = null;
        copy.syntaxOid = this.syntaxOid;
        copy.syntaxLength = this.syntaxLength;
        return copy;
    }

    @Override
    public void clear() {
        super.clear();
        this.equality = null;
        this.ordering = null;
        this.substring = null;
        this.superior = null;
        this.syntax = null;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (!(o instanceof AttributeType)) {
            return false;
        }
        AttributeType that = (AttributeType)o;
        if (this.isCollective != that.isCollective) {
            return false;
        }
        if (this.isSingleValued != that.isSingleValued) {
            return false;
        }
        if (this.canUserModify != that.canUserModify) {
            return false;
        }
        if (this.usage != that.usage) {
            return false;
        }
        if (!this.compareOid(this.equalityOid, that.equalityOid)) {
            return false;
        }
        if (this.equality != null ? !this.equality.equals(that.equality) : that.equality != null) {
            return false;
        }
        if (!this.compareOid(this.orderingOid, that.orderingOid)) {
            return false;
        }
        if (this.ordering != null ? !this.ordering.equals(that.ordering) : that.ordering != null) {
            return false;
        }
        if (!this.compareOid(this.substringOid, that.substringOid)) {
            return false;
        }
        if (this.substring != null ? !this.substring.equals(that.substring) : that.substring != null) {
            return false;
        }
        if (!this.compareOid(this.superiorOid, that.superiorOid)) {
            return false;
        }
        if (this.superior != null ? !this.superior.equals(that.superior) : that.superior != null) {
            return false;
        }
        if (!this.compareOid(this.syntaxOid, that.syntaxOid)) {
            return false;
        }
        if (this.syntaxLength != that.syntaxLength) {
            return false;
        }
        if (this.syntax == null) {
            return that.syntax == null;
        }
        if (this.syntax.equals(that.syntax)) {
            return this.syntaxLength == that.syntaxLength;
        }
        return false;
    }
}

