/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.ldif;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.NamingException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.client.ClientModification;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.ldif.ChangeType;
import org.apache.directory.shared.ldap.ldif.LdifEntry;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.util.AttributeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdifRevertor {
    public static final boolean DELETE_OLD_RDN = true;
    public static final boolean KEEP_OLD_RDN = false;

    public static LdifEntry reverseAdd(DN dn) {
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Delete);
        entry.setDn(dn);
        return entry;
    }

    public static LdifEntry reverseDel(DN dn, Entry deletedEntry) throws NamingException {
        LdifEntry entry = new LdifEntry();
        entry.setDn(dn);
        entry.setChangeType(ChangeType.Add);
        for (EntryAttribute attribute : deletedEntry) {
            entry.addAttribute(attribute);
        }
        return entry;
    }

    public static LdifEntry reverseModify(DN dn, List<Modification> forwardModifications, Entry modifiedEntry) throws NamingException {
        Entry clonedEntry = modifiedEntry.clone();
        LdifEntry entry = new LdifEntry();
        entry.setChangeType(ChangeType.Modify);
        entry.setDn(dn);
        ArrayList<ClientModification> reverseModifications = new ArrayList<ClientModification>();
        block5: for (Modification modification : forwardModifications) {
            switch (modification.getOperation()) {
                case ADD_ATTRIBUTE: {
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = clonedEntry.get(mod.getId());
                    if (mod.equals(previous)) continue block5;
                    ClientModification reverseModification = new ClientModification(ModificationOperation.REMOVE_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REMOVE_ATTRIBUTE: {
                    ClientModification reverseModification;
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = clonedEntry.get(mod.getId());
                    if (previous == null) continue block5;
                    if (mod.get() == null) {
                        reverseModification = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        break;
                    }
                    reverseModification = new ClientModification(ModificationOperation.ADD_ATTRIBUTE, mod);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
                case REPLACE_ATTRIBUTE: {
                    ClientModification reverseModification;
                    EntryAttribute mod = modification.getAttribute();
                    EntryAttribute previous = clonedEntry.get(mod.getId());
                    if (mod.get() == null && previous == null) {
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)new DefaultClientAttribute(mod.getId()));
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (mod.get() == null) {
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    if (previous == null) {
                        DefaultClientAttribute emptyAttribute = new DefaultClientAttribute(mod.getId());
                        reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, (EntryAttribute)emptyAttribute);
                        reverseModifications.add(0, reverseModification);
                        continue block5;
                    }
                    reverseModification = new ClientModification(ModificationOperation.REPLACE_ATTRIBUTE, previous);
                    reverseModifications.add(0, reverseModification);
                    break;
                }
            }
            AttributeUtils.applyModification(clonedEntry, modification);
        }
        if (reverseModifications.size() == 0) {
            throw new IllegalArgumentException(I18n.err("ERR_12073", forwardModifications));
        }
        for (Modification modification : reverseModifications) {
            entry.addModificationItem(modification);
        }
        return entry;
    }

    public static LdifEntry reverseMove(DN newSuperiorDn, DN modifiedDn) throws NamingException {
        LdifEntry entry = new LdifEntry();
        DN currentParent = null;
        RDN currentRdn = null;
        DN newDn = null;
        if (newSuperiorDn == null) {
            throw new NullPointerException(I18n.err("ERR_12074", new Object[0]));
        }
        if (modifiedDn == null) {
            throw new NullPointerException(I18n.err("ERR_12075", new Object[0]));
        }
        if (modifiedDn.size() == 0) {
            throw new IllegalArgumentException(I18n.err("ERR_12076", new Object[0]));
        }
        currentParent = (DN)modifiedDn.clone();
        currentRdn = currentParent.getRdn();
        currentParent.remove(currentParent.size() - 1);
        newDn = (DN)newSuperiorDn.clone();
        newDn.add(modifiedDn.getRdn());
        entry.setChangeType(ChangeType.ModDn);
        entry.setDn(newDn);
        entry.setNewRdn(currentRdn.getUpName());
        entry.setNewSuperior(currentParent.getName());
        entry.setDeleteOldRdn(false);
        return entry;
    }

    private static LdifEntry revertEntry(List<LdifEntry> entries, Entry entry, DN newDn, DN newSuperior, RDN oldRdn, RDN newRdn) throws InvalidNameException {
        LdifEntry reverted = new LdifEntry();
        reverted.setChangeType(ChangeType.ModRdn);
        if (newSuperior != null) {
            DN restoredDn = (DN)((DN)newSuperior.clone()).add(newRdn);
            reverted.setDn(restoredDn);
        } else {
            reverted.setDn(newDn);
        }
        reverted.setNewRdn(oldRdn.getUpName());
        boolean keepOldRdn = entry.contains(newRdn.getNormType(), newRdn.getNormValue());
        reverted.setDeleteOldRdn(!keepOldRdn);
        if (newSuperior != null) {
            DN oldSuperior = (DN)entry.getDn().clone();
            oldSuperior.remove(oldSuperior.size() - 1);
            reverted.setNewSuperior(oldSuperior.getName());
        }
        return reverted;
    }

    private static LdifEntry generateModify(DN parentDn, Entry entry, RDN oldRdn, RDN newRdn) {
        LdifEntry restored = new LdifEntry();
        restored.setChangeType(ChangeType.Modify);
        restored.setDn(parentDn);
        for (AVA ava : newRdn) {
            if (entry.contains(ava.getNormType(), ava.getNormValue().getString()) || ava.getNormType().equals(oldRdn.getNormType()) && ava.getNormValue().equals(oldRdn.getNormValue())) continue;
            ClientModification modification = new ClientModification(ModificationOperation.REMOVE_ATTRIBUTE, (EntryAttribute)new DefaultClientAttribute(ava.getUpType(), ava.getUpValue().getString()));
            restored.addModificationItem(modification);
        }
        return restored;
    }

    private static LdifEntry generateReverted(DN newSuperior, RDN newRdn, DN newDn, RDN oldRdn, boolean deleteOldRdn) throws InvalidNameException {
        LdifEntry reverted = new LdifEntry();
        reverted.setChangeType(ChangeType.ModRdn);
        if (newSuperior != null) {
            DN restoredDn = (DN)((DN)newSuperior.clone()).add(newRdn);
            reverted.setDn(restoredDn);
        } else {
            reverted.setDn(newDn);
        }
        reverted.setNewRdn(oldRdn.getUpName());
        if (newSuperior != null) {
            DN oldSuperior = (DN)newDn.clone();
            oldSuperior.remove(oldSuperior.size() - 1);
            reverted.setNewSuperior(oldSuperior.getName());
        }
        reverted.setDeleteOldRdn(deleteOldRdn);
        return reverted;
    }

    public static List<LdifEntry> reverseRename(Entry entry, RDN newRdn, boolean deleteOldRdn) throws NamingException {
        return LdifRevertor.reverseMoveAndRename(entry, null, newRdn, deleteOldRdn);
    }

    public static List<LdifEntry> reverseMoveAndRename(Entry entry, DN newSuperior, RDN newRdn, boolean deleteOldRdn) throws NamingException {
        DN parentDn = entry.getDn();
        DN newDn = null;
        if (newRdn == null) {
            throw new NullPointerException(I18n.err("ERR_12077", new Object[0]));
        }
        if (parentDn == null) {
            throw new NullPointerException(I18n.err("ERR_12078", new Object[0]));
        }
        if (parentDn.size() == 0) {
            throw new IllegalArgumentException(I18n.err("ERR_12079", new Object[0]));
        }
        parentDn = (DN)entry.getDn().clone();
        RDN oldRdn = parentDn.getRdn();
        newDn = (DN)parentDn.clone();
        newDn.remove(newDn.size() - 1);
        newDn.add(newRdn);
        ArrayList<LdifEntry> entries = new ArrayList<LdifEntry>(1);
        LdifEntry reverted = new LdifEntry();
        if (newRdn.size() == 1) {
            if (oldRdn.size() == 1 && oldRdn.equals(newRdn)) {
                throw new NamingException(I18n.err("ERR_12080", new Object[0]));
            }
            reverted = LdifRevertor.revertEntry(entries, entry, newDn, newSuperior, oldRdn, newRdn);
            entries.add(reverted);
        } else if (oldRdn.size() == 1) {
            LdifEntry restored;
            boolean overlapping = false;
            boolean existInEntry = false;
            for (AVA atav : newRdn) {
                if (atav.equals(oldRdn.getAtav())) {
                    overlapping = true;
                    continue;
                }
                if (!entry.contains(atav.getNormType(), atav.getNormValue().getString())) continue;
                existInEntry = true;
            }
            if (overlapping) {
                if (existInEntry) {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                    entries.add(reverted);
                    restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                    entries.add(restored);
                } else {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                    entries.add(reverted);
                }
            } else if (existInEntry) {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                entries.add(reverted);
                restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                entries.add(restored);
            } else {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                entries.add(reverted);
            }
        } else {
            boolean overlapping = false;
            boolean existInEntry = false;
            HashSet<AVA> oldAtavs = new HashSet<AVA>();
            for (AVA atav : oldRdn) {
                oldAtavs.add(atav);
            }
            for (AVA atav : newRdn) {
                if (oldAtavs.contains(atav)) {
                    overlapping = true;
                    continue;
                }
                if (!entry.contains(atav.getNormType(), atav.getNormValue().getString())) continue;
                existInEntry = true;
            }
            if (overlapping) {
                if (existInEntry) {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                    entries.add(reverted);
                } else {
                    reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                    entries.add(reverted);
                }
            } else if (existInEntry) {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, false);
                entries.add(reverted);
                LdifEntry restored = LdifRevertor.generateModify(parentDn, entry, oldRdn, newRdn);
                entries.add(restored);
            } else {
                reverted = LdifRevertor.generateReverted(newSuperior, newRdn, newDn, oldRdn, true);
                entries.add(reverted);
            }
        }
        return entries;
    }
}

