/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.jndi;

import javax.naming.NamingException;
import javax.naming.ldap.BasicControl;
import org.apache.directory.shared.ldap.codec.controls.ControlImpl;
import org.apache.directory.shared.ldap.message.control.Control;

public class JndiUtils {
    public static javax.naming.ldap.Control toJndiControl(Control control) {
        byte[] value = control.getValue();
        BasicControl jndiControl = new BasicControl(control.getOid(), control.isCritical(), value);
        return jndiControl;
    }

    public static javax.naming.ldap.Control[] toJndiControls(Control ... controls) {
        if (controls != null) {
            javax.naming.ldap.Control[] jndiControls = new javax.naming.ldap.Control[controls.length];
            int i = 0;
            for (Control control : controls) {
                jndiControls[i++] = JndiUtils.toJndiControl(control);
            }
            return jndiControls;
        }
        return null;
    }

    public static Control fromJndiControl(javax.naming.ldap.Control jndiControl) {
        ControlImpl control = new ControlImpl(jndiControl.getID());
        control.setValue(jndiControl.getEncodedValue());
        return control;
    }

    public static Control[] fromJndiControls(javax.naming.ldap.Control ... jndiControls) {
        if (jndiControls != null) {
            Control[] controls = new Control[jndiControls.length];
            int i = 0;
            for (javax.naming.ldap.Control jndiControl : jndiControls) {
                controls[i++] = JndiUtils.fromJndiControl(jndiControl);
            }
            return controls;
        }
        return null;
    }

    public static void wrap(Throwable t) throws NamingException {
        if (t instanceof NamingException) {
            throw (NamingException)t;
        }
        NamingException ne = new NamingException(t.getLocalizedMessage());
        ne.setRootCause(t);
        throw ne;
    }
}

