/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue;

import org.apache.directory.shared.asn1.ber.IAsn1Container;
import org.apache.directory.shared.asn1.ber.grammar.AbstractGrammar;
import org.apache.directory.shared.asn1.ber.grammar.GrammarAction;
import org.apache.directory.shared.asn1.ber.grammar.GrammarTransition;
import org.apache.directory.shared.asn1.ber.grammar.IGrammar;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.DecoderException;
import org.apache.directory.shared.asn1.util.IntegerDecoder;
import org.apache.directory.shared.asn1.util.IntegerDecoderException;
import org.apache.directory.shared.i18n.I18n;
import org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue.SyncStateValueControlContainer;
import org.apache.directory.shared.ldap.codec.controls.replication.syncStateValue.SyncStateValueControlStatesEnum;
import org.apache.directory.shared.ldap.message.control.replication.SyncStateTypeEnum;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncStateValueControlGrammar
extends AbstractGrammar {
    static final Logger LOG = LoggerFactory.getLogger(SyncStateValueControlGrammar.class);
    static final boolean IS_DEBUG = LOG.isDebugEnabled();
    private static IGrammar instance = new SyncStateValueControlGrammar();

    private SyncStateValueControlGrammar() {
        this.name = SyncStateValueControlGrammar.class.getName();
        this.statesEnum = SyncStateValueControlStatesEnum.getInstance();
        this.transitions = new GrammarTransition[5][256];
        this.transitions[0][48] = new GrammarTransition(0, 1, 48, null);
        this.transitions[1][10] = new GrammarTransition(1, 2, 10, new GrammarAction("Set SyncStateValueControl state type"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncStateValueControlContainer syncStateValueContainer = (SyncStateValueControlContainer)container;
                Value value = syncStateValueContainer.getCurrentTLV().getValue();
                try {
                    int syncStateType = IntegerDecoder.parse(value, SyncStateTypeEnum.PRESENT.getValue(), SyncStateTypeEnum.DELETE.getValue());
                    SyncStateTypeEnum syncStateTypeEnum = SyncStateTypeEnum.getSyncStateType(syncStateType);
                    if (IS_DEBUG) {
                        LOG.debug("SyncStateType = {}", (Object)syncStateTypeEnum);
                    }
                    syncStateValueContainer.getSyncStateValueControl().setSyncStateType(syncStateTypeEnum);
                    syncStateValueContainer.grammarEndAllowed(false);
                }
                catch (IntegerDecoderException e) {
                    String msg = I18n.err("ERR_04030", new Object[0]);
                    LOG.error(msg, e);
                    throw new DecoderException(msg);
                }
            }
        });
        this.transitions[2][4] = new GrammarTransition(2, 3, 4, new GrammarAction("Set SyncStateValueControl entryUUID"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncStateValueControlContainer syncStateValueContainer = (SyncStateValueControlContainer)container;
                Value value = syncStateValueContainer.getCurrentTLV().getValue();
                byte[] entryUUID = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("entryUUID = {}", (Object)StringTools.dumpBytes(entryUUID));
                }
                syncStateValueContainer.getSyncStateValueControl().setEntryUUID(entryUUID);
                syncStateValueContainer.grammarEndAllowed(true);
            }
        });
        this.transitions[3][4] = new GrammarTransition(3, 4, 4, new GrammarAction("Set SyncStateValueControl cookie value"){

            public void action(IAsn1Container container) throws DecoderException {
                SyncStateValueControlContainer syncStateValueContainer = (SyncStateValueControlContainer)container;
                Value value = syncStateValueContainer.getCurrentTLV().getValue();
                byte[] cookie = value.getData();
                if (IS_DEBUG) {
                    LOG.debug("cookie = {}", (Object)cookie);
                }
                syncStateValueContainer.getSyncStateValueControl().setCookie(cookie);
                syncStateValueContainer.grammarEndAllowed(true);
            }
        });
    }

    public static IGrammar getInstance() {
        return instance;
    }
}

