/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.schema.registries.synchronizers;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.schema.registries.synchronizers.AbstractRegistrySynchronizer;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.exception.LdapInvalidNameException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.registries.Schema;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyntaxCheckerSynchronizer
extends AbstractRegistrySynchronizer {
    private static final Logger LOG = LoggerFactory.getLogger(SyntaxCheckerSynchronizer.class);

    public SyntaxCheckerSynchronizer(SchemaManager schemaManager) throws Exception {
        super(schemaManager);
    }

    public boolean modify(ModifyOperationContext opContext, ServerEntry targetEntry, boolean cascade) throws Exception {
        DN name = opContext.getDn();
        ClonedServerEntry entry = opContext.getEntry();
        String schemaName = this.getSchemaName(name);
        String oid = this.getOid(entry);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
        if (this.isSchemaEnabled(schemaName)) {
            syntaxChecker.setSchemaName(schemaName);
            this.schemaManager.unregisterSyntaxChecker(oid);
            this.schemaManager.add(syntaxChecker);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void add(ServerEntry entry) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "SyntaxChecker");
        this.checkOidIsUniqueForSyntaxChecker(entry);
        String schemaName = this.getSchemaName(dn);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isEnabled() && syntaxChecker.isEnabled()) {
            if (this.schemaManager.add(syntaxChecker)) {
                LOG.debug("Added {} into the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_386, entry.getDn().getName(), StringTools.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        LOG.debug("The SyntaxChecker {} cannot be added in the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void delete(ServerEntry entry, boolean cascade) throws Exception {
        DN dn = entry.getDn();
        DN parentDn = (DN)dn.clone();
        parentDn.remove(parentDn.size() - 1);
        this.checkParent(parentDn, this.schemaManager, "SyntaxChecker");
        String schemaName = this.getSchemaName(entry.getDn());
        Schema schema = this.schemaManager.getLoadedSchema(schemaName);
        if (schema.isDisabled()) {
            LOG.debug("The SyntaxChecker {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
            return;
        }
        SyntaxChecker syntaxChecker = null;
        try {
            syntaxChecker = this.checkSyntaxCheckerOidExists(entry);
        }
        catch (LdapSchemaViolationException lsve) {
            syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, entry, this.schemaManager.getRegistries(), schemaName);
            if (this.schemaManager.getRegistries().contains(syntaxChecker)) {
                this.schemaManager.getRegistries().dissociateFromSchema(syntaxChecker);
                return;
            }
            String msg = I18n.err(I18n.ERR_387, entry.getDn().getName());
            LOG.info(msg);
            throw new LdapSchemaViolationException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (schema.isEnabled() && syntaxChecker.isEnabled()) {
            if (this.schemaManager.delete(syntaxChecker)) {
                LOG.debug("Deleted {} from the enabled schema {}", (Object)dn.getName(), (Object)schemaName);
                return;
            }
            String msg = I18n.err(I18n.ERR_386, entry.getDn().getName(), StringTools.listToString(this.schemaManager.getErrors()));
            LOG.info(msg);
            throw new LdapOperationNotSupportedException(msg, ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        LOG.debug("The syntaxChecker {} cannot be deleted from the disabled schema {}", (Object)dn.getName(), (Object)schemaName);
    }

    public void rename(ServerEntry entry, RDN newRdn, boolean cascade) throws Exception {
        String oldOid = this.getOid(entry);
        String schemaName = this.getSchemaName(entry.getDn());
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oldOid)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_389, oldOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = newRdn.getNormValue();
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(newOid)) {
            throw new LdapNamingException(I18n.err(I18n.ERR_390, newOid), ResultCodeEnum.OTHER);
        }
        targetEntry.put("m-oid", newOid);
        if (this.isSchemaEnabled(schemaName)) {
            SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), schemaName);
            this.schemaManager.unregisterSyntaxChecker(oldOid);
            this.schemaManager.add(syntaxChecker);
        }
    }

    public void moveAndRename(DN oriChildName, DN newParentName, RDN newRdn, boolean deleteOldRn, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oldOid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oldOid)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_391, oldOid), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        ServerEntry targetEntry = (ServerEntry)entry.clone();
        String newOid = newRdn.getNormValue();
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(newOid)) {
            throw new LdapNamingException(I18n.err(I18n.ERR_390, newOid), ResultCodeEnum.OTHER);
        }
        targetEntry.put("m-oid", newOid);
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, targetEntry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterSyntaxChecker(oldOid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(syntaxChecker);
        }
    }

    public void move(DN oriChildName, DN newParentName, ServerEntry entry, boolean cascade) throws Exception {
        this.checkNewParent(newParentName);
        String oid = this.getOid(entry);
        String oldSchemaName = this.getSchemaName(oriChildName);
        String newSchemaName = this.getSchemaName(newParentName);
        if (this.schemaManager.getLdapSyntaxRegistry().contains(oid)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_393, oid), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        SyntaxChecker syntaxChecker = this.factory.getSyntaxChecker(this.schemaManager, entry, this.schemaManager.getRegistries(), newSchemaName);
        if (this.isSchemaEnabled(oldSchemaName)) {
            this.schemaManager.unregisterSyntaxChecker(oid);
        }
        if (this.isSchemaEnabled(newSchemaName)) {
            this.schemaManager.add(syntaxChecker);
        }
    }

    private void checkOidIsUniqueForSyntaxChecker(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getNormalizerRegistry().contains(oid)) {
            throw new LdapNamingException(I18n.err(I18n.ERR_390, oid), ResultCodeEnum.OTHER);
        }
    }

    protected SyntaxChecker checkSyntaxCheckerOidExists(ServerEntry entry) throws Exception {
        String oid = this.getOid(entry);
        if (this.schemaManager.getSyntaxCheckerRegistry().contains(oid)) {
            return (SyntaxChecker)this.schemaManager.getSyntaxCheckerRegistry().get(oid);
        }
        throw new LdapSchemaViolationException(I18n.err(I18n.ERR_336, oid), ResultCodeEnum.OTHER);
    }

    private void checkNewParent(DN newParent) throws NamingException {
        if (newParent.size() != 3) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_396, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
        RDN rdn = newParent.getRdn();
        if (!this.schemaManager.getAttributeTypeRegistry().getOidByName(rdn.getNormType()).equals("2.5.4.11")) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_397, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
        if (!rdn.getNormValue().equalsIgnoreCase("syntaxCheckers")) {
            throw new LdapInvalidNameException(I18n.err(I18n.ERR_372, new Object[0]), ResultCodeEnum.NAMING_VIOLATION);
        }
    }
}

