/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.operational;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.DefaultServerAttribute;
import org.apache.directory.server.core.entry.DefaultServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.entry.ServerModification;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.AVA;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.name.RDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.UsageEnum;
import org.apache.directory.shared.ldap.util.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationalAttributeInterceptor
extends BaseInterceptor {
    private static Logger LOG = LoggerFactory.getLogger(OperationalAttributeInterceptor.class);
    private final EntryFilter DENORMALIZING_SEARCH_FILTER = new EntryFilter(){

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry serverEntry) throws Exception {
            if (operation.getSearchControls().getReturningAttributes() == null) {
                return true;
            }
            return OperationalAttributeInterceptor.this.filterDenormalized(serverEntry);
        }
    };
    private final EntryFilter SEARCH_FILTER = new EntryFilter(){

        public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
            return operation.getSearchControls().getReturningAttributes() != null || OperationalAttributeInterceptor.this.filterOperationalAttributes(entry);
        }
    };
    private DirectoryService service;
    private DN subschemaSubentryDn;
    private SchemaManager schemaManager;
    private static AttributeType CREATE_TIMESTAMP_ATTRIBUTE_TYPE;
    private static AttributeType MODIFIERS_NAME_ATTRIBUTE_TYPE;
    private static AttributeType MODIFY_TIMESTAMP_ATTRIBUTE_TYPE;

    public void init(DirectoryService directoryService) throws Exception {
        this.service = directoryService;
        this.schemaManager = directoryService.getSchemaManager();
        Value<?> subschemaSubentry = this.service.getPartitionNexus().getRootDSE(null).get("subschemaSubentry").get();
        this.subschemaSubentryDn = new DN(subschemaSubentry.getString());
        this.subschemaSubentryDn.normalize(this.schemaManager.getNormalizerMapping());
        CREATE_TIMESTAMP_ATTRIBUTE_TYPE = this.schemaManager.lookupAttributeTypeRegistry("createTimestamp");
        MODIFIERS_NAME_ATTRIBUTE_TYPE = this.schemaManager.lookupAttributeTypeRegistry("modifiersName");
        MODIFY_TIMESTAMP_ATTRIBUTE_TYPE = this.schemaManager.lookupAttributeTypeRegistry("modifyTimestamp");
    }

    public void destroy() {
    }

    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        String principal = OperationalAttributeInterceptor.getPrincipal().getName();
        ClonedServerEntry entry = opContext.getEntry();
        boolean isAdmin = opContext.getSession().getAuthenticatedPrincipal().getName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        if (entry.containsAttribute("entryUUID")) {
            if (!isAdmin) {
                String message = I18n.err(I18n.ERR_30, "entryUUID");
                LOG.error(message);
                throw new LdapSchemaViolationException(message, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS);
            }
        } else {
            entry.put("entryUUID", UUID.randomUUID().toString());
        }
        if (entry.containsAttribute("entryCSN")) {
            if (!isAdmin) {
                String message = I18n.err(I18n.ERR_30, "entryCSN");
                LOG.error(message);
                throw new LdapSchemaViolationException(message, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS);
            }
        } else {
            entry.put("entryCSN", this.service.getCSN().toString());
        }
        entry.put("creatorsName", principal);
        entry.put("createTimestamp", DateUtils.getGeneralizedTime());
        nextInterceptor.add(opContext);
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        List<Modification> mods = opContext.getModItems();
        for (Modification modification : mods) {
            AttributeType attributeType = ((ServerAttribute)modification.getAttribute()).getAttributeType();
            if (attributeType.equals(MODIFIERS_NAME_ATTRIBUTE_TYPE)) {
                String message = I18n.err(I18n.ERR_31, new Object[0]);
                LOG.error(message);
                throw new LdapSchemaViolationException(message, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS);
            }
            if (!attributeType.equals(MODIFY_TIMESTAMP_ATTRIBUTE_TYPE)) continue;
            String message = I18n.err(I18n.ERR_32, new Object[0]);
            LOG.error(message);
            throw new LdapSchemaViolationException(message, ResultCodeEnum.INSUFFICIENT_ACCESS_RIGHTS);
        }
        DefaultServerAttribute attribute = new DefaultServerAttribute(MODIFIERS_NAME_ATTRIBUTE_TYPE, OperationalAttributeInterceptor.getPrincipal().getName());
        ServerModification modifiersName = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
        mods.add(modifiersName);
        attribute = new DefaultServerAttribute(MODIFY_TIMESTAMP_ATTRIBUTE_TYPE, DateUtils.getGeneralizedTime());
        ServerModification timestamp = new ServerModification(ModificationOperation.REPLACE_ATTRIBUTE, attribute);
        mods.add(timestamp);
        nextInterceptor.modify(opContext);
        if (opContext.getDn().getNormName().equals(this.subschemaSubentryDn.getNormName())) {
            return;
        }
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        nextInterceptor.rename(opContext);
        DN newDn = opContext.getNewDn();
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, newDn);
        serverEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        serverEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        List<Modification> items = ModifyOperationContext.createModItems(serverEntry, ModificationOperation.REPLACE_ATTRIBUTE);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), newDn, items);
        newModify.setEntry(opContext.getAlteredEntry());
        this.service.getPartitionNexus().modify(newModify);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        nextInterceptor.move(opContext);
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, opContext.getDn());
        serverEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        serverEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        List<Modification> items = ModifyOperationContext.createModItems(serverEntry, ModificationOperation.REPLACE_ATTRIBUTE);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), opContext.getParent(), items);
        this.service.getPartitionNexus().modify(newModify);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        nextInterceptor.moveAndRename(opContext);
        DefaultServerEntry serverEntry = new DefaultServerEntry(this.schemaManager, opContext.getDn());
        serverEntry.put("modifiersName", OperationalAttributeInterceptor.getPrincipal().getName());
        serverEntry.put("modifyTimestamp", DateUtils.getGeneralizedTime());
        List<Modification> items = ModifyOperationContext.createModItems(serverEntry, ModificationOperation.REPLACE_ATTRIBUTE);
        ModifyOperationContext newModify = new ModifyOperationContext(opContext.getSession(), opContext.getParent(), items);
        this.service.getPartitionNexus().modify(newModify);
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry result = nextInterceptor.lookup(opContext);
        if (result == null) {
            return null;
        }
        if (opContext.getAttrsId() == null) {
            this.filterOperationalAttributes(result);
        } else if (opContext.getAllOperational() == null || !opContext.getAllOperational().booleanValue()) {
            this.filter(opContext, result);
        }
        this.denormalizeEntryOpAttrs(result);
        return result;
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        if (opContext.isAllOperationalAttributes() || opContext.getReturningAttributes() != null && !opContext.getReturningAttributes().isEmpty()) {
            if (this.service.isDenormalizeOpAttrsEnabled()) {
                cursor.addEntryFilter(this.DENORMALIZING_SEARCH_FILTER);
            }
            return cursor;
        }
        cursor.addEntryFilter(this.SEARCH_FILTER);
        return cursor;
    }

    private boolean filterOperationalAttributes(ServerEntry attributes) throws Exception {
        HashSet<AttributeType> removedAttributes = new HashSet<AttributeType>();
        for (AttributeType attributeType : attributes.getAttributeTypes()) {
            if (attributeType.getUsage() == UsageEnum.USER_APPLICATIONS) continue;
            removedAttributes.add(attributeType);
        }
        for (AttributeType attributeType : removedAttributes) {
            attributes.removeAttributes(attributeType);
        }
        return true;
    }

    private void filter(LookupOperationContext lookupContext, ServerEntry entry) throws Exception {
        DN dn = lookupContext.getDn();
        List<String> ids = lookupContext.getAttrsId();
        if (ids == null || ids.isEmpty()) {
            this.filterOperationalAttributes(entry);
            return;
        }
        Set<AttributeType> attributeTypes = entry.getAttributeTypes();
        if (dn.size() == 0) {
            for (AttributeType attributeType : attributeTypes) {
                if (ids.contains(attributeType.getOid())) continue;
                entry.removeAttributes(attributeType);
            }
        }
        this.denormalizeEntryOpAttrs(entry);
    }

    public void denormalizeEntryOpAttrs(ServerEntry entry) throws Exception {
        if (this.service.isDenormalizeOpAttrsEnabled()) {
            DN modifiersName;
            EntryAttribute attr = entry.get("creatorsName");
            if (attr != null) {
                DN creatorsName = new DN(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(creatorsName).getName());
            }
            if ((attr = entry.get("modifiersName")) != null) {
                modifiersName = new DN(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
            if ((attr = entry.get("schemaModifiersName")) != null) {
                modifiersName = new DN(attr.getString());
                attr.clear();
                attr.add(this.denormalizeTypes(modifiersName).getName());
            }
        }
    }

    public DN denormalizeTypes(DN dn) throws Exception {
        DN newDn = new DN();
        for (int ii = 0; ii < dn.size(); ++ii) {
            RDN rdn = dn.getRdn(ii);
            if (rdn.size() == 0) {
                newDn.add(new RDN());
                continue;
            }
            if (rdn.size() == 1) {
                String name = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                String value = rdn.getAtav().getNormValue().getString();
                newDn.add(new RDN(name, name, value, value));
                continue;
            }
            StringBuffer buf = new StringBuffer();
            Iterator<AVA> atavs = rdn.iterator();
            while (atavs.hasNext()) {
                AVA atav = atavs.next();
                String type = this.schemaManager.lookupAttributeTypeRegistry(rdn.getNormType()).getName();
                buf.append(type).append('=').append(atav.getNormValue());
                if (!atavs.hasNext()) continue;
                buf.append('+');
            }
            newDn.add(new RDN(buf.toString()));
        }
        return newDn;
    }

    private boolean filterDenormalized(ServerEntry entry) throws Exception {
        this.denormalizeEntryOpAttrs(entry);
        return true;
    }
}

