/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.exception;

import java.util.List;
import org.apache.commons.collections.map.LRUMap;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.BaseEntryFilteringCursor;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.AddOperationContext;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.EntryOperationContext;
import org.apache.directory.server.core.interceptor.context.GetMatchedNameOperationContext;
import org.apache.directory.server.core.interceptor.context.GetSuffixOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.partition.ByPassConstants;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.cursor.EmptyCursor;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.entry.ModificationOperation;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapAttributeInUseException;
import org.apache.directory.shared.ldap.exception.LdapContextNotEmptyException;
import org.apache.directory.shared.ldap.exception.LdapNameAlreadyBoundException;
import org.apache.directory.shared.ldap.exception.LdapNameNotFoundException;
import org.apache.directory.shared.ldap.exception.LdapNamingException;
import org.apache.directory.shared.ldap.exception.LdapOperationNotSupportedException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.DN;

public class ExceptionInterceptor
extends BaseInterceptor {
    private PartitionNexus nexus;
    private DirectoryService directoryService;
    private DN subschemSubentryDn;
    private final LRUMap notAliasCache = new LRUMap(100);
    private static final int DEFAULT_CACHE_SIZE = 100;

    public void init(DirectoryService directoryService) throws Exception {
        this.directoryService = directoryService;
        this.nexus = directoryService.getPartitionNexus();
        Value<?> attr = this.nexus.getRootDSE(null).get("subschemaSubentry").get();
        this.subschemSubentryDn = new DN(attr.getString());
        this.subschemSubentryDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(NextInterceptor nextInterceptor, AddOperationContext opContext) throws Exception {
        boolean notAnAlias;
        DN name = opContext.getDn();
        if (this.subschemSubentryDn.getNormName().equals(name.getNormName())) {
            throw new LdapNameAlreadyBoundException(I18n.err(I18n.ERR_249, new Object[0]));
        }
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), name))) {
            LdapNameAlreadyBoundException ne = new LdapNameAlreadyBoundException(I18n.err(I18n.ERR_250, name.getName()));
            ne.setResolvedName(new DN(name.getName()));
            throw ne;
        }
        DN suffix = this.nexus.getSuffix(new GetSuffixOperationContext(this.directoryService.getAdminSession(), name));
        if (suffix.equals(name)) {
            nextInterceptor.add(opContext);
            return;
        }
        DN parentDn = (DN)name.clone();
        parentDn.remove(name.size() - 1);
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            notAnAlias = this.notAliasCache.containsKey(parentDn.getNormName());
        }
        if (!notAnAlias) {
            ClonedServerEntry attrs;
            try {
                attrs = opContext.lookup(parentDn, ByPassConstants.LOOKUP_BYPASS);
            }
            catch (Exception e) {
                LdapNameNotFoundException e2 = new LdapNameNotFoundException(I18n.err(I18n.ERR_251, parentDn.getName()));
                e2.setResolvedName(new DN(this.nexus.getMatchedName(new GetMatchedNameOperationContext(opContext.getSession(), parentDn)).getName()));
                throw e2;
            }
            EntryAttribute objectClass = attrs.getOriginalEntry().get("objectClass");
            if (objectClass.contains("alias")) {
                String msg = I18n.err(I18n.ERR_252, name.getName());
                ResultCodeEnum rc = ResultCodeEnum.ALIAS_PROBLEM;
                LdapNamingException e = new LdapNamingException(msg, rc);
                e.setResolvedName(new DN(parentDn.getName()));
                throw e;
            }
            LRUMap lRUMap2 = this.notAliasCache;
            synchronized (lRUMap2) {
                this.notAliasCache.put(parentDn.getNormName(), parentDn);
            }
        }
        nextInterceptor.add(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        if (name.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_253, this.subschemSubentryDn), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to delete non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, name);
        boolean hasChildren = false;
        EntryFilteringCursor list = nextInterceptor.list(new ListOperationContext(opContext.getSession(), name));
        if (list.next()) {
            hasChildren = true;
        }
        list.close();
        if (hasChildren) {
            LdapContextNotEmptyException e = new LdapContextNotEmptyException();
            e.setResolvedName(new DN(name.getName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(name.getNormName())) {
                this.notAliasCache.remove(name.getNormName());
            }
        }
        nextInterceptor.delete(opContext);
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return new BaseEntryFilteringCursor(new EmptyCursor<ServerEntry>(), opContext);
        }
        String msg = "Attempt to search under non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, opContext.getDn());
        return nextInterceptor.list(opContext);
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        if (opContext.getDn().getNormName().equals(this.subschemSubentryDn.getNormName())) {
            return this.nexus.getRootDSE(null);
        }
        String msg = "Attempt to lookup non-existant entry: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, opContext.getDn());
        return nextInterceptor.lookup(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        String msg = "Attempt to modify non-existant entry: ";
        if (opContext.getDn().getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            nextInterceptor.modify(opContext);
            return;
        }
        this.assertHasEntry(nextInterceptor, opContext, msg, opContext.getDn());
        ClonedServerEntry entry = opContext.lookup(opContext.getDn(), ByPassConstants.LOOKUP_BYPASS);
        List<Modification> items = opContext.getModItems();
        for (Modification item : items) {
            ServerAttribute modAttr;
            EntryAttribute entryAttr;
            if (item.getOperation() != ModificationOperation.ADD_ATTRIBUTE || (entryAttr = entry.get((modAttr = (ServerAttribute)item.getAttribute()).getId())) == null) continue;
            for (Value value : modAttr) {
                if (!entryAttr.contains(value)) continue;
                throw new LdapAttributeInUseException(I18n.err(I18n.ERR_254, value, modAttr.getId()));
            }
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(opContext.getDn().getNormName())) {
                this.notAliasCache.remove(opContext.getDn().getNormName());
            }
        }
        nextInterceptor.modify(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        DN dn = opContext.getDn();
        if (dn.equals(this.subschemSubentryDn)) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_255, this.subschemSubentryDn, this.subschemSubentryDn), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        if (opContext.getEntry() == null) {
            LdapNameNotFoundException ldnfe = new LdapNameNotFoundException(I18n.err(I18n.ERR_256, dn.getName()));
            ldnfe.setResolvedName(new DN(dn.getName()));
            throw ldnfe;
        }
        DN newDn = opContext.getNewDn();
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), newDn))) {
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException(I18n.err(I18n.ERR_257, newDn.getName()));
            e.setResolvedName(new DN(newDn.getName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(dn.getNormName())) {
                this.notAliasCache.remove(dn.getNormName());
            }
        }
        nextInterceptor.rename(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN newParentName = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_258, this.subschemSubentryDn, this.subschemSubentryDn), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, newParentName);
        String rdn = oriChildName.get(oriChildName.size() - 1);
        DN target = (DN)newParentName.clone();
        target.add(rdn);
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), target))) {
            String upRdn = new DN(oriChildName.getName()).get(oriChildName.size() - 1);
            DN upTarget = (DN)newParentName.clone();
            upTarget.add(upRdn);
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException(I18n.err(I18n.ERR_257, upTarget.getName()));
            e.setResolvedName(new DN(upTarget.getName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(oriChildName.getNormName())) {
                this.notAliasCache.remove(oriChildName.getNormName());
            }
        }
        nextInterceptor.move(opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        DN oriChildName = opContext.getDn();
        DN parent = opContext.getParent();
        if (oriChildName.getNormName().equalsIgnoreCase(this.subschemSubentryDn.getNormName())) {
            throw new LdapOperationNotSupportedException(I18n.err(I18n.ERR_258, this.subschemSubentryDn, this.subschemSubentryDn), ResultCodeEnum.UNWILLING_TO_PERFORM);
        }
        String msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, oriChildName);
        msg = "Attempt to move to non-existant parent: ";
        this.assertHasEntry(nextInterceptor, opContext, msg, parent);
        DN target = (DN)parent.clone();
        target.add(opContext.getNewRdn());
        if (nextInterceptor.hasEntry(new EntryOperationContext(opContext.getSession(), target))) {
            DN upTarget = (DN)parent.clone();
            upTarget.add(opContext.getNewRdn());
            LdapNameAlreadyBoundException e = new LdapNameAlreadyBoundException(I18n.err(I18n.ERR_257, upTarget.getName()));
            e.setResolvedName(new DN(upTarget.getName()));
            throw e;
        }
        LRUMap lRUMap = this.notAliasCache;
        synchronized (lRUMap) {
            if (this.notAliasCache.containsKey(oriChildName.getNormName())) {
                this.notAliasCache.remove(oriChildName.getNormName());
            }
        }
        nextInterceptor.moveAndRename(opContext);
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        DN base = opContext.getDn();
        try {
            EntryFilteringCursor cursor = nextInterceptor.search(opContext);
            if (!(cursor.next() || base.isEmpty() || this.subschemSubentryDn.toNormName().equalsIgnoreCase(base.toNormName()))) {
                this.assertHasEntry(nextInterceptor, opContext, "Attempt to search under non-existant entry:", base);
            }
            return cursor;
        }
        catch (Exception ne) {
            String msg = I18n.err(I18n.ERR_259, new Object[0]);
            this.assertHasEntry(nextInterceptor, opContext, msg, base);
            throw ne;
        }
    }

    private void assertHasEntry(NextInterceptor nextInterceptor, OperationContext opContext, String msg, DN dn) throws Exception {
        if (this.subschemSubentryDn.getNormName().equals(dn.getNormName())) {
            return;
        }
        if (!opContext.hasEntry(dn, ByPassConstants.HAS_ENTRY_BYPASS)) {
            LdapNameNotFoundException e = msg != null ? new LdapNameNotFoundException(msg + dn.getName()) : new LdapNameNotFoundException(dn.getName());
            e.setResolvedName(new DN(opContext.getSession().getDirectoryService().getOperationManager().getMatchedName(new GetMatchedNameOperationContext(opContext.getSession(), dn)).getName()));
            throw e;
        }
    }
}

