/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.event;

import javax.naming.NamingException;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.event.Evaluator;
import org.apache.directory.server.core.event.LeafEvaluator;
import org.apache.directory.server.core.event.SubstringEvaluator;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.filter.AndNode;
import org.apache.directory.shared.ldap.filter.BranchNode;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.NotNode;
import org.apache.directory.shared.ldap.filter.OrNode;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.apache.directory.shared.ldap.schema.registries.OidRegistry;

public class ExpressionEvaluator
implements Evaluator {
    private LeafEvaluator leafEvaluator;

    public ExpressionEvaluator(LeafEvaluator leafEvaluator) {
        this.leafEvaluator = leafEvaluator;
    }

    public ExpressionEvaluator(OidRegistry oidRegistry, SchemaManager schemaManager) {
        SubstringEvaluator substringEvaluator = null;
        substringEvaluator = new SubstringEvaluator(schemaManager);
        this.leafEvaluator = new LeafEvaluator(schemaManager, substringEvaluator);
    }

    public LeafEvaluator getLeafEvaluator() {
        return this.leafEvaluator;
    }

    public boolean evaluate(ExprNode node, String dn, ServerEntry entry) throws NamingException {
        if (node.isLeaf()) {
            return this.leafEvaluator.evaluate(node, dn, entry);
        }
        BranchNode bnode = (BranchNode)node;
        if (bnode instanceof OrNode) {
            for (ExprNode child : bnode.getChildren()) {
                if (!this.evaluate(child, dn, entry)) continue;
                return true;
            }
            return false;
        }
        if (bnode instanceof AndNode) {
            for (ExprNode child : bnode.getChildren()) {
                boolean res = this.evaluate(child, dn, entry);
                if (res) continue;
                return false;
            }
            return true;
        }
        if (bnode instanceof NotNode) {
            if (null != bnode.getFirstChild()) {
                return !this.evaluate(bnode.getFirstChild(), dn, entry);
            }
            throw new NamingException(I18n.err(I18n.ERR_243, node));
        }
        throw new NamingException(I18n.err(I18n.ERR_244, bnode));
    }
}

