/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.naming.NamingException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientStringValue;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerStringValue
extends ClientStringValue {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerStringValue.class);
    private transient AttributeType attributeType;

    protected String logAssert(String message) {
        LOG.error(message);
        return message;
    }

    protected String checkAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            return "The AttributeType parameter should not be null";
        }
        if (attributeType.getSyntax() == null) {
            return "There is no Syntax associated with this attributeType";
        }
        return null;
    }

    public ServerStringValue(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_92, new Object[0]));
        }
        if (attributeType.getSyntax() == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_462, new Object[0]));
        }
        if (!attributeType.getSyntax().isHumanReadable()) {
            LOG.warn("Treating a value of a binary attribute {} as a String: \nthis could cause data corruption!", (Object)attributeType.getName());
        }
        this.attributeType = attributeType;
    }

    public ServerStringValue(AttributeType attributeType, String wrapped) {
        this(attributeType);
        this.wrapped = wrapped;
    }

    ServerStringValue(AttributeType attributeType, String wrapped, String normalizedValue, boolean valid) {
        super(wrapped);
        this.normalized = true;
        this.attributeType = attributeType;
        this.normalizedValue = normalizedValue;
        this.valid = valid;
    }

    @Override
    public ServerStringValue clone() {
        ServerStringValue clone = (ServerStringValue)super.clone();
        return clone;
    }

    @Override
    public void normalize() throws NamingException {
        if (this.normalized) {
            return;
        }
        Normalizer normalizer = this.getNormalizer();
        this.normalizedValue = normalizer == null ? this.wrapped : normalizer.normalize((String)this.wrapped);
        this.normalized = true;
    }

    @Override
    public String getNormalizedValue() {
        if (this.isNull()) {
            this.normalized = true;
            return null;
        }
        if (!this.normalized) {
            try {
                this.normalize();
            }
            catch (NamingException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.info(message);
                this.normalized = false;
            }
        }
        return (String)this.normalizedValue;
    }

    @Override
    public final boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        this.valid = this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(this.get());
        return this.valid;
    }

    @Override
    public int compareTo(Value<String> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (value instanceof ServerStringValue) {
            String message;
            ServerStringValue stringValue = (ServerStringValue)value;
            try {
                stringValue.normalize();
            }
            catch (NamingException ne) {
                message = I18n.err(I18n.ERR_112, stringValue);
                LOG.error(message);
            }
            try {
                this.normalize();
            }
            catch (NamingException ne) {
                message = I18n.err(I18n.ERR_112, this);
                LOG.error(message);
            }
            try {
                return this.getLdapComparator().compare(this.getNormalizedValue(), stringValue.getNormalizedValue());
            }
            catch (NamingException e) {
                String msg = I18n.err(I18n.ERR_109, this, value);
                LOG.error(msg, e);
                throw new IllegalStateException(msg, e);
            }
        }
        String message = I18n.err(I18n.ERR_114, new Object[0]);
        LOG.error(message);
        throw new NotImplementedException(message);
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean instanceOf(AttributeType attributeType) throws NamingException {
        if (this.attributeType.equals(attributeType)) {
            return true;
        }
        return this.attributeType.isDescendantOf(attributeType);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerStringValue)) {
            return false;
        }
        ServerStringValue other = (ServerStringValue)obj;
        if (!this.attributeType.equals(other.attributeType)) {
            return false;
        }
        if (this.isNull()) {
            return other.isNull();
        }
        if (((String)this.get()).equals(other.get())) {
            return true;
        }
        try {
            LdapComparator<? super Object> comparator = this.getLdapComparator();
            if (comparator == null) {
                return this.getNormalizedValue().equals(other.getNormalizedValue());
            }
            if (this.isNormalized()) {
                return comparator.compare(this.getNormalizedValue(), other.getNormalizedValue()) == 0;
            }
            Normalizer normalizer = this.attributeType.getEquality().getNormalizer();
            return comparator.compare(normalizer.normalize((String)this.get()), normalizer.normalize((String)other.get())) == 0;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    private MatchingRule getMatchingRule() throws NamingException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            mr = this.attributeType.getOrdering();
        }
        if (mr == null) {
            mr = this.attributeType.getSubstring();
        }
        return mr;
    }

    private Normalizer getNormalizer() throws NamingException {
        MatchingRule mr = this.getMatchingRule();
        if (mr == null) {
            return null;
        }
        return mr.getNormalizer();
    }

    @Override
    public int hashCode() {
        if (this.isNull()) {
            return this.attributeType.getOid().hashCode();
        }
        int h = 17;
        String normalized = this.getNormalizedValue();
        if (normalized != null) {
            h = h * 37 + normalized.hashCode();
        }
        h = h * 37 + this.attributeType.getOid().hashCode();
        return h;
    }

    private LdapComparator<? super Object> getLdapComparator() throws NamingException {
        MatchingRule mr = this.getMatchingRule();
        if (mr == null) {
            return null;
        }
        return mr.getLdapComparator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_463, new Object[0]));
    }

    public void serialize(ObjectOutput out) throws IOException {
        block5: {
            if (this.wrapped != null) {
                out.writeBoolean(true);
                out.writeUTF((String)this.wrapped);
                try {
                    this.normalize();
                    out.writeBoolean(true);
                    if (((String)this.wrapped).equals(this.normalizedValue)) {
                        out.writeBoolean(true);
                        break block5;
                    }
                    out.writeBoolean(false);
                    out.writeUTF((String)this.normalizedValue);
                }
                catch (NamingException ne) {
                    this.normalizedValue = null;
                    out.writeBoolean(false);
                }
            } else {
                out.writeBoolean(false);
            }
        }
        out.flush();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err(I18n.ERR_463, new Object[0]));
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        if (!in.readBoolean()) {
            this.set(null);
            this.normalizedValue = null;
            return;
        }
        String wrapped = in.readUTF();
        this.set(wrapped);
        this.normalized = in.readBoolean();
        if (this.normalized) {
            this.normalized = true;
            this.normalizedValue = in.readBoolean() ? wrapped : in.readUTF();
        }
    }
}

