/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.entry;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.naming.NamingException;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.NotImplementedException;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.ClientBinaryValue;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.LdapComparator;
import org.apache.directory.shared.ldap.schema.MatchingRule;
import org.apache.directory.shared.ldap.schema.Normalizer;
import org.apache.directory.shared.ldap.schema.comparators.ByteArrayComparator;
import org.apache.directory.shared.ldap.util.StringTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerBinaryValue
extends ClientBinaryValue {
    private static final long serialVersionUID = 2L;
    private static final Logger LOG = LoggerFactory.getLogger(ServerBinaryValue.class);
    private transient AttributeType attributeType;

    protected String logAssert(String message) {
        LOG.error(message);
        return message;
    }

    protected String checkAttributeType(AttributeType attributeType) {
        if (attributeType == null) {
            return "The AttributeType parameter should not be null";
        }
        if (attributeType.getSyntax() == null) {
            return "There is no Syntax associated with this attributeType";
        }
        return null;
    }

    public ServerBinaryValue(AttributeType attributeType) {
        if (attributeType == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_92, new Object[0]));
        }
        if (attributeType.getSyntax() == null) {
            throw new IllegalArgumentException(I18n.err(I18n.ERR_462, new Object[0]));
        }
        if (attributeType.getSyntax().isHumanReadable()) {
            LOG.warn("Treating a value of a human readible attribute {} as binary: ", (Object)attributeType.getName());
        }
        this.attributeType = attributeType;
    }

    public ServerBinaryValue(AttributeType attributeType, byte[] wrapped) {
        this(attributeType);
        this.wrapped = wrapped;
    }

    ServerBinaryValue(AttributeType attributeType, byte[] wrapped, byte[] normalizedValue, boolean same, boolean valid) {
        super(wrapped);
        this.normalized = true;
        this.attributeType = attributeType;
        this.normalizedValue = normalizedValue;
        this.valid = valid;
        this.same = same;
    }

    @Override
    public void normalize() throws NamingException {
        if (this.isNormalized()) {
            return;
        }
        if (this.wrapped != null) {
            Normalizer normalizer = this.getNormalizer();
            if (normalizer == null) {
                this.normalizedValue = this.wrapped;
                this.normalized = false;
                this.same = true;
            } else {
                this.normalizedValue = normalizer.normalize(this).getBytes();
                this.normalized = true;
                this.same = Arrays.equals((byte[])this.wrapped, (byte[])this.normalizedValue);
            }
        } else {
            this.normalizedValue = null;
            this.same = true;
            this.normalized = false;
        }
    }

    @Override
    public byte[] getNormalizedValueReference() {
        if (this.isNull()) {
            return null;
        }
        if (!this.isNormalized()) {
            try {
                this.normalize();
            }
            catch (NamingException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        return (byte[])this.normalizedValue;
    }

    @Override
    public byte[] getNormalizedValue() {
        if (this.isNull()) {
            return null;
        }
        if (!this.normalized) {
            try {
                this.normalize();
            }
            catch (NamingException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        return (byte[])this.normalizedValue;
    }

    @Override
    public byte[] getNormalizedValueCopy() {
        if (this.isNull()) {
            return null;
        }
        if (this.normalizedValue == null) {
            try {
                this.normalize();
            }
            catch (NamingException ne) {
                String message = "Cannot normalize the value :" + ne.getLocalizedMessage();
                LOG.warn(message);
                this.normalized = false;
            }
        }
        if (this.normalizedValue != null) {
            byte[] copy = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, copy, 0, ((byte[])this.normalizedValue).length);
            return copy;
        }
        return null;
    }

    @Override
    public final boolean isValid() {
        if (this.valid != null) {
            return this.valid;
        }
        this.valid = this.attributeType.getSyntax().getSyntaxChecker().isValidSyntax(this.getReference());
        return this.valid;
    }

    @Override
    public int compareTo(Value<byte[]> value) {
        if (this.isNull()) {
            if (value == null || value.isNull()) {
                return 0;
            }
            return -1;
        }
        if (value == null || value.isNull()) {
            return 1;
        }
        if (value instanceof ServerBinaryValue) {
            ServerBinaryValue binaryValue = (ServerBinaryValue)value;
            try {
                LdapComparator<?> comparator = this.getLdapComparator();
                if (comparator != null) {
                    return comparator.compare(this.getNormalizedValueReference(), binaryValue.getNormalizedValueReference());
                }
                return new ByteArrayComparator(null).compare(this.getNormalizedValueReference(), binaryValue.getNormalizedValueReference());
            }
            catch (NamingException e) {
                String msg = I18n.err(I18n.ERR_109, Arrays.toString((byte[])this.getReference()), value);
                LOG.error(msg, e);
                throw new IllegalStateException(msg, e);
            }
        }
        String message = I18n.err(I18n.ERR_110, new Object[0]);
        LOG.error(message);
        throw new NotImplementedException(message);
    }

    public AttributeType getAttributeType() {
        return this.attributeType;
    }

    public boolean instanceOf(AttributeType attributeType) throws NamingException {
        if (this.attributeType.equals(attributeType)) {
            return true;
        }
        return this.attributeType.isDescendantOf(attributeType);
    }

    @Override
    public int hashCode() {
        if (this.isNull()) {
            return 0;
        }
        return Arrays.hashCode(this.getNormalizedValueReference());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ServerBinaryValue)) {
            return false;
        }
        ServerBinaryValue other = (ServerBinaryValue)obj;
        if (!this.attributeType.equals(other.attributeType)) {
            return false;
        }
        if (this.isNull()) {
            return other.isNull();
        }
        if (Arrays.equals((byte[])this.wrapped, (byte[])other.get())) {
            return true;
        }
        try {
            LdapComparator<?> comparator = this.getLdapComparator();
            if (comparator == null) {
                return Arrays.equals(this.getNormalizedValueReference(), other.getNormalizedValueReference());
            }
            return comparator.compare(this.getNormalizedValueReference(), other.getNormalizedValueReference()) == 0;
        }
        catch (NamingException ne) {
            return false;
        }
    }

    private MatchingRule getMatchingRule() throws NamingException {
        MatchingRule mr = this.attributeType.getEquality();
        if (mr == null) {
            mr = this.attributeType.getOrdering();
        }
        if (mr == null) {
            mr = this.attributeType.getSubstring();
        }
        return mr;
    }

    private Normalizer getNormalizer() throws NamingException {
        MatchingRule mr = this.getMatchingRule();
        if (mr == null) {
            return null;
        }
        return mr.getNormalizer();
    }

    private LdapComparator<?> getLdapComparator() throws NamingException {
        MatchingRule mr = this.getMatchingRule();
        if (mr == null) {
            return null;
        }
        return mr.getLdapComparator();
    }

    @Override
    public ServerBinaryValue clone() {
        ServerBinaryValue clone = (ServerBinaryValue)super.clone();
        if (this.normalizedValue != null) {
            clone.normalizedValue = new byte[((byte[])this.normalizedValue).length];
            System.arraycopy(this.normalizedValue, 0, clone.normalizedValue, 0, ((byte[])this.normalizedValue).length);
        }
        return clone;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        throw new IllegalStateException(I18n.err(I18n.ERR_463, new Object[0]));
    }

    public void serialize(ObjectOutput out) throws IOException {
        if (this.wrapped != null) {
            out.writeInt(((byte[])this.wrapped).length);
            if (((byte[])this.wrapped).length > 0) {
                out.write((byte[])this.wrapped);
                try {
                    this.normalize();
                    if (!this.normalized) {
                        out.writeBoolean(false);
                    } else {
                        out.writeBoolean(true);
                        if (Arrays.equals((byte[])this.getReference(), (byte[])this.normalizedValue)) {
                            out.writeBoolean(true);
                        } else {
                            out.writeBoolean(false);
                            out.writeInt(((byte[])this.normalizedValue).length);
                            if (((byte[])this.normalizedValue).length > 0) {
                                out.write((byte[])this.normalizedValue);
                            }
                        }
                    }
                }
                catch (NamingException ne) {
                    this.normalizedValue = null;
                    out.writeBoolean(false);
                }
            }
        } else {
            out.writeInt(-1);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        throw new IllegalStateException(I18n.err(I18n.ERR_463, new Object[0]));
    }

    public void deserialize(ObjectInput in) throws IOException, ClassNotFoundException {
        int wrappedLength = in.readInt();
        if (wrappedLength == -1) {
            this.same = true;
            this.wrapped = null;
        } else if (wrappedLength == 0) {
            this.wrapped = StringTools.EMPTY_BYTES;
            this.same = true;
            this.normalized = true;
            this.normalizedValue = this.wrapped;
        } else {
            this.wrapped = new byte[wrappedLength];
            in.readFully((byte[])this.wrapped);
            this.normalized = in.readBoolean();
            if (this.normalized) {
                this.same = in.readBoolean();
                if (!this.same) {
                    int normalizedLength = in.readInt();
                    if (normalizedLength > 0) {
                        this.normalizedValue = new byte[normalizedLength];
                        in.read((byte[])this.normalizedValue, 0, normalizedLength);
                    } else {
                        this.normalizedValue = StringTools.EMPTY_BYTES;
                    }
                } else {
                    this.normalizedValue = new byte[wrappedLength];
                    System.arraycopy(this.wrapped, 0, this.normalizedValue, 0, wrappedLength);
                }
            }
        }
    }
}

