/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.authz;

import java.util.HashSet;
import java.util.Set;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DefaultCoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.filtering.EntryFilter;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.BaseInterceptor;
import org.apache.directory.server.core.interceptor.NextInterceptor;
import org.apache.directory.server.core.interceptor.context.DeleteOperationContext;
import org.apache.directory.server.core.interceptor.context.ListOperationContext;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.interceptor.context.ModifyOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveAndRenameOperationContext;
import org.apache.directory.server.core.interceptor.context.MoveOperationContext;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.server.core.interceptor.context.RenameOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchOperationContext;
import org.apache.directory.server.core.interceptor.context.SearchingOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.i18n.I18n;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.exception.LdapNoPermissionException;
import org.apache.directory.shared.ldap.name.DN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationInterceptor
extends BaseInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizationInterceptor.class);
    private static DN USER_BASE_DN;
    private static DN GROUP_BASE_DN;
    private static DN ADMIN_GROUP_DN;
    private Set<String> administrators = new HashSet<String>(2);
    private PartitionNexus nexus;
    private AttributeType uniqueMemberAT;

    public void init(DirectoryService directoryService) throws Exception {
        this.nexus = directoryService.getPartitionNexus();
        SchemaManager schemaManager = directoryService.getSchemaManager();
        USER_BASE_DN = new DN("uid=admin,ou=system");
        USER_BASE_DN.normalize(schemaManager.getNormalizerMapping());
        GROUP_BASE_DN = new DN("ou=groups,ou=system");
        GROUP_BASE_DN.normalize(schemaManager.getNormalizerMapping());
        ADMIN_GROUP_DN = new DN("cn=Administrators,ou=groups,ou=system");
        ADMIN_GROUP_DN.normalize(schemaManager.getNormalizerMapping());
        this.uniqueMemberAT = schemaManager.lookupAttributeTypeRegistry("2.5.4.50");
        this.loadAdministrators(directoryService);
    }

    private void loadAdministrators(DirectoryService directoryService) throws Exception {
        HashSet<String> newAdministrators = new HashSet<String>(2);
        DN adminDn = new DN("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
        adminDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
        DefaultCoreSession adminSession = new DefaultCoreSession(new LdapPrincipal(adminDn, AuthenticationLevel.STRONG), directoryService);
        ClonedServerEntry adminGroup = this.nexus.lookup(new LookupOperationContext((CoreSession)adminSession, ADMIN_GROUP_DN));
        if (adminGroup == null) {
            return;
        }
        EntryAttribute uniqueMember = adminGroup.get(this.uniqueMemberAT);
        for (Value value : uniqueMember) {
            DN memberDn = new DN(value.getString());
            memberDn.normalize(directoryService.getSchemaManager().getNormalizerMapping());
            newAdministrators.add(memberDn.getNormName());
        }
        this.administrators = newAdministrators;
    }

    public void delete(NextInterceptor nextInterceptor, DeleteOperationContext opContext) throws Exception {
        DN name = opContext.getDn();
        if (opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            nextInterceptor.delete(opContext);
            return;
        }
        DN principalDn = DefaultAuthorizationInterceptor.getPrincipal().getClonedName();
        if (name.isEmpty()) {
            String msg = I18n.err(I18n.ERR_12, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (name.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
            String msg = I18n.err(I18n.ERR_13, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(name)) {
            String msg = I18n.err(I18n.ERR_14, principalDn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (name.size() > 2 && !this.isAnAdministrator(principalDn)) {
            if (name.startsWith(USER_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_15, principalDn.getName(), name.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (name.startsWith(GROUP_BASE_DN)) {
                String msg = I18n.err(I18n.ERR_16, principalDn.getName(), name.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
        nextInterceptor.delete(opContext);
    }

    private boolean isTheAdministrator(DN normalizedDn) {
        return normalizedDn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system");
    }

    private boolean isAnAdministrator(DN normalizedDn) {
        return this.isTheAdministrator(normalizedDn) || this.administrators.contains(normalizedDn.getNormName());
    }

    public void modify(NextInterceptor nextInterceptor, ModifyOperationContext opContext) throws Exception {
        if (!opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            DN dn = opContext.getDn();
            this.protectModifyAlterations(dn);
            nextInterceptor.modify(opContext);
            if (dn.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
                this.loadAdministrators(opContext.getSession().getDirectoryService());
            }
        } else {
            nextInterceptor.modify(opContext);
        }
    }

    private void protectModifyAlterations(DN dn) throws Exception {
        DN principalDn = DefaultAuthorizationInterceptor.getPrincipal().getClonedName();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_17, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (!this.isAnAdministrator(principalDn)) {
            if (dn.getNormName().equals(DefaultAuthorizationInterceptor.getPrincipal().getName())) {
                return;
            }
            if (dn.getNormName().equals("0.9.2342.19200300.100.1.1=admin,2.5.4.11=system")) {
                String msg = I18n.err(I18n.ERR_18, principalDn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
            if (dn.size() > 2) {
                if (dn.startsWith(USER_BASE_DN)) {
                    String msg = I18n.err(I18n.ERR_19, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (dn.startsWith(GROUP_BASE_DN)) {
                    String msg = I18n.err(I18n.ERR_20, principalDn.getName(), dn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
        }
    }

    public void rename(NextInterceptor nextInterceptor, RenameOperationContext opContext) throws Exception {
        if (!opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.rename(opContext);
    }

    public void move(NextInterceptor nextInterceptor, MoveOperationContext opContext) throws Exception {
        if (!opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.move(opContext);
    }

    public void moveAndRename(NextInterceptor nextInterceptor, MoveAndRenameOperationContext opContext) throws Exception {
        if (!opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            this.protectDnAlterations(opContext.getDn());
        }
        nextInterceptor.moveAndRename(opContext);
    }

    private void protectDnAlterations(DN dn) throws Exception {
        DN principalDn = DefaultAuthorizationInterceptor.getPrincipal().getClonedName();
        if (dn.isEmpty()) {
            String msg = I18n.err(I18n.ERR_234, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.getNormName().equals(ADMIN_GROUP_DN.getNormName())) {
            String msg = I18n.err(I18n.ERR_21, new Object[0]);
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (this.isTheAdministrator(dn)) {
            String msg = I18n.err(I18n.ERR_22, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith(USER_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = I18n.err(I18n.ERR_23, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
        if (dn.size() > 2 && dn.startsWith(GROUP_BASE_DN) && !this.isAnAdministrator(principalDn)) {
            String msg = I18n.err(I18n.ERR_24, principalDn.getName(), dn.getName());
            LOG.error(msg);
            throw new LdapNoPermissionException(msg);
        }
    }

    public ClonedServerEntry lookup(NextInterceptor nextInterceptor, LookupOperationContext opContext) throws Exception {
        ClonedServerEntry serverEntry = nextInterceptor.lookup(opContext);
        if (opContext.getSession().getDirectoryService().isAccessControlEnabled() || serverEntry == null) {
            return serverEntry;
        }
        this.protectLookUp(opContext.getSession().getEffectivePrincipal().getClonedName(), opContext.getDn());
        return serverEntry;
    }

    private void protectLookUp(DN principalDn, DN normalizedDn) throws Exception {
        if (!this.isAnAdministrator(principalDn)) {
            if (normalizedDn.size() > 2) {
                if (normalizedDn.startsWith(USER_BASE_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = I18n.err(I18n.ERR_25, normalizedDn.getName(), principalDn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
                if (normalizedDn.startsWith(GROUP_BASE_DN)) {
                    if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                        return;
                    }
                    String msg = I18n.err(I18n.ERR_26, normalizedDn.getName(), principalDn.getName());
                    LOG.error(msg);
                    throw new LdapNoPermissionException(msg);
                }
            }
            if (this.isTheAdministrator(normalizedDn)) {
                if (normalizedDn.getNormName().equals(principalDn.getNormName())) {
                    return;
                }
                String msg = I18n.err(I18n.ERR_27, principalDn.getName());
                LOG.error(msg);
                throw new LdapNoPermissionException(msg);
            }
        }
    }

    public EntryFilteringCursor search(NextInterceptor nextInterceptor, SearchOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.search(opContext);
        if (opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return cursor;
        }
        cursor.addEntryFilter(new EntryFilter(){

            public boolean accept(SearchingOperationContext operation, ClonedServerEntry result) throws Exception {
                return DefaultAuthorizationInterceptor.this.isSearchable(operation, result);
            }
        });
        return cursor;
    }

    public EntryFilteringCursor list(NextInterceptor nextInterceptor, ListOperationContext opContext) throws Exception {
        EntryFilteringCursor cursor = nextInterceptor.list(opContext);
        if (opContext.getSession().getDirectoryService().isAccessControlEnabled()) {
            return cursor;
        }
        cursor.addEntryFilter(new EntryFilter(){

            public boolean accept(SearchingOperationContext operation, ClonedServerEntry entry) throws Exception {
                return DefaultAuthorizationInterceptor.this.isSearchable(operation, entry);
            }
        });
        return cursor;
    }

    private boolean isSearchable(OperationContext opContext, ClonedServerEntry result) throws Exception {
        DN principalDn = opContext.getSession().getEffectivePrincipal().getClonedName();
        DN dn = result.getDn();
        if (!dn.isNormalized()) {
            dn.normalize(opContext.getSession().getDirectoryService().getSchemaManager().getNormalizerMapping());
        }
        if (this.isAnAdministrator(principalDn)) {
            return true;
        }
        boolean isSelfRead = dn.getNormName().equals(principalDn.getNormName());
        if (isSelfRead) {
            return true;
        }
        if (dn.size() > 2 && (dn.getNormName().endsWith(USER_BASE_DN.getNormName()) || dn.getNormName().endsWith(GROUP_BASE_DN.getNormName()))) {
            return false;
        }
        return !this.isTheAdministrator(dn);
    }
}

