/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import javax.naming.NamingException;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.asn1.util.Asn1StringUtils;
import org.apache.directory.shared.ldap.codec.LdapMessageCodec;
import org.apache.directory.shared.ldap.entry.Entry;
import org.apache.directory.shared.ldap.entry.EntryAttribute;
import org.apache.directory.shared.ldap.entry.Value;
import org.apache.directory.shared.ldap.entry.client.DefaultClientAttribute;
import org.apache.directory.shared.ldap.entry.client.DefaultClientEntry;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.StringTools;

public class SearchResultEntryCodec
extends LdapMessageCodec {
    private byte[] objectNameBytes;
    private Entry entry = new DefaultClientEntry();
    private EntryAttribute currentAttributeValue;
    private int searchResultEntryLength;
    private int attributesLength;
    private List<Integer> attributeLength;
    private List<Integer> valsLength;

    public int getMessageType() {
        return 17;
    }

    public LdapDN getObjectName() {
        return this.entry.getDn();
    }

    public void setObjectName(LdapDN objectName) {
        this.entry.setDn(objectName);
    }

    public Entry getEntry() {
        return this.entry;
    }

    public void setEntry(Entry entry) {
        this.entry = entry;
    }

    public void addAttributeValues(String type) {
        this.currentAttributeValue = new DefaultClientAttribute(type);
        try {
            this.entry.put(this.currentAttributeValue);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public void addAttributeValue(Object value) {
        if (value instanceof String) {
            this.currentAttributeValue.add((String)value);
        } else {
            this.currentAttributeValue.add(new byte[][]{(byte[])value});
        }
    }

    public int computeLength() {
        this.objectNameBytes = StringTools.getBytesUtf8(this.entry.getDn().getUpName());
        this.searchResultEntryLength = 1 + TLV.getNbBytes(this.objectNameBytes.length) + this.objectNameBytes.length;
        this.attributesLength = 0;
        if (this.entry != null && this.entry.size() != 0) {
            this.attributeLength = new LinkedList<Integer>();
            this.valsLength = new LinkedList<Integer>();
            for (EntryAttribute attribute : this.entry) {
                int localAttributeLength = 0;
                int localValuesLength = 0;
                int idLength = attribute.getId().getBytes().length;
                localAttributeLength = 1 + TLV.getNbBytes(idLength) + idLength;
                if (attribute.size() != 0) {
                    if (attribute.size() > 0) {
                        localValuesLength = 0;
                        for (Value value : attribute) {
                            byte[] binaryValue = value.getBytes();
                            localValuesLength += 1 + TLV.getNbBytes(binaryValue.length) + binaryValue.length;
                        }
                        localAttributeLength += 1 + TLV.getNbBytes(localValuesLength) + localValuesLength;
                    } else {
                        localAttributeLength += 2;
                    }
                } else {
                    localAttributeLength += 2;
                }
                this.attributesLength += 1 + TLV.getNbBytes(localAttributeLength) + localAttributeLength;
                this.attributeLength.add(localAttributeLength);
                this.valsLength.add(localValuesLength);
            }
        }
        this.searchResultEntryLength += 1 + TLV.getNbBytes(this.attributesLength) + this.attributesLength;
        return 1 + TLV.getNbBytes(this.searchResultEntryLength) + this.searchResultEntryLength;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)100);
            buffer.put(TLV.getBytes(this.searchResultEntryLength));
            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, this.objectNameBytes);
            buffer.put((byte)48);
            buffer.put(TLV.getBytes(this.attributesLength));
            if (this.entry != null && this.entry.size() != 0) {
                int attributeNumber = 0;
                for (EntryAttribute attribute : this.entry) {
                    buffer.put((byte)48);
                    int localAttributeLength = this.attributeLength.get(attributeNumber);
                    buffer.put(TLV.getBytes(localAttributeLength));
                    org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, Asn1StringUtils.asciiStringToByte(attribute.getUpId()));
                    buffer.put((byte)49);
                    int localValuesLength = this.valsLength.get(attributeNumber);
                    buffer.put(TLV.getBytes(localValuesLength));
                    if (attribute.size() != 0 && attribute.size() > 0) {
                        for (Value value : attribute) {
                            if (!value.isBinary()) {
                                org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getString());
                                continue;
                            }
                            org.apache.directory.shared.asn1.ber.tlv.Value.encode(buffer, value.getBytes());
                        }
                    }
                    ++attributeNumber;
                }
            }
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("    Search Result Entry\n");
        sb.append("        entry\n");
        if (this.entry == null || this.entry.size() == 0) {
            sb.append("            No entry\n");
        } else {
            sb.append(this.entry);
        }
        return sb.toString();
    }

    public String getCurrentAttributeValueType() {
        return this.currentAttributeValue.getId();
    }
}

