/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.directory.shared.asn1.AbstractAsn1Object;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.ber.tlv.Value;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.LdapURL;
import org.apache.directory.shared.ldap.util.StringTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapResultCodec
extends AbstractAsn1Object {
    private ResultCodeEnum resultCode;
    private LdapDN matchedDN;
    private byte[] matchedDNBytes;
    private String errorMessage;
    private byte[] errorMessageBytes;
    private List<LdapURL> referrals;
    private int referralsLength;

    public void initReferrals() {
        this.referrals = new ArrayList<LdapURL>();
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getMatchedDN() {
        return this.matchedDN == null ? "" : this.matchedDN.toString();
    }

    public void setMatchedDN(LdapDN matchedDN) {
        this.matchedDN = matchedDN;
    }

    public List<LdapURL> getReferrals() {
        return this.referrals;
    }

    public void addReferral(LdapURL referral) {
        this.referrals.add(referral);
    }

    public ResultCodeEnum getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(ResultCodeEnum resultCode) {
        this.resultCode = resultCode;
    }

    @Override
    public int computeLength() {
        int ldapResultLength = 0;
        ldapResultLength = 3;
        if (this.matchedDN == null) {
            ldapResultLength += 2;
        } else {
            this.matchedDNBytes = StringTools.getBytesUtf8(StringTools.trimLeft(this.matchedDN.getUpName()));
            ldapResultLength += 1 + TLV.getNbBytes(this.matchedDNBytes.length) + this.matchedDNBytes.length;
        }
        this.errorMessageBytes = StringTools.getBytesUtf8(this.errorMessage);
        ldapResultLength += 1 + TLV.getNbBytes(this.errorMessageBytes.length) + this.errorMessageBytes.length;
        if (this.referrals != null && this.referrals.size() != 0) {
            this.referralsLength = 0;
            for (LdapURL referral : this.referrals) {
                this.referralsLength += 1 + TLV.getNbBytes(referral.getNbBytes()) + referral.getNbBytes();
            }
            ldapResultLength += 1 + TLV.getNbBytes(this.referralsLength) + this.referralsLength;
        }
        return ldapResultLength;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)10);
            buffer.put((byte)1);
            buffer.put((byte)this.resultCode.getValue());
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        Value.encode(buffer, this.matchedDNBytes);
        Value.encode(buffer, this.errorMessageBytes);
        if (this.referrals != null && this.referrals.size() != 0) {
            buffer.put((byte)-93);
            buffer.put(TLV.getBytes(this.referralsLength));
            for (LdapURL referral : this.referrals) {
                Value.encode(buffer, referral.getBytesReference());
            }
        }
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("        Ldap Result\n");
        sb.append("            Result code : (").append((Object)this.resultCode).append(')');
        block0 : switch (this.resultCode) {
            case SUCCESS: {
                sb.append(" success\n");
                break;
            }
            case OPERATIONS_ERROR: {
                sb.append(" operationsError\n");
                break;
            }
            case PROTOCOL_ERROR: {
                sb.append(" protocolError\n");
                break;
            }
            case TIME_LIMIT_EXCEEDED: {
                sb.append(" timeLimitExceeded\n");
                break;
            }
            case SIZE_LIMIT_EXCEEDED: {
                sb.append(" sizeLimitExceeded\n");
                break;
            }
            case COMPARE_FALSE: {
                sb.append(" compareFalse\n");
                break;
            }
            case COMPARE_TRUE: {
                sb.append(" compareTrue\n");
                break;
            }
            case AUTH_METHOD_NOT_SUPPORTED: {
                sb.append(" authMethodNotSupported\n");
                break;
            }
            case STRONG_AUTH_REQUIRED: {
                sb.append(" strongAuthRequired\n");
                break;
            }
            case REFERRAL: {
                sb.append(" referral -- new\n");
                break;
            }
            case ADMIN_LIMIT_EXCEEDED: {
                sb.append(" adminLimitExceeded -- new\n");
                break;
            }
            case UNAVAILABLE_CRITICAL_EXTENSION: {
                sb.append(" unavailableCriticalExtension -- new\n");
                break;
            }
            case CONFIDENTIALITY_REQUIRED: {
                sb.append(" confidentialityRequired -- new\n");
                break;
            }
            case SASL_BIND_IN_PROGRESS: {
                sb.append(" saslBindInProgress -- new\n");
                break;
            }
            case NO_SUCH_ATTRIBUTE: {
                sb.append(" noSuchAttribute\n");
                break;
            }
            case UNDEFINED_ATTRIBUTE_TYPE: {
                sb.append(" undefinedAttributeType\n");
                break;
            }
            case INAPPROPRIATE_MATCHING: {
                sb.append(" inappropriateMatching\n");
                break;
            }
            case CONSTRAINT_VIOLATION: {
                sb.append(" constraintViolation\n");
                break;
            }
            case ATTRIBUTE_OR_VALUE_EXISTS: {
                sb.append(" attributeOrValueExists\n");
                break;
            }
            case INVALID_ATTRIBUTE_SYNTAX: {
                sb.append(" invalidAttributeSyntax\n");
                break;
            }
            case NO_SUCH_OBJECT: {
                sb.append(" noSuchObject\n");
                break;
            }
            case ALIAS_PROBLEM: {
                sb.append(" aliasProblem\n");
                break;
            }
            case INVALID_DN_SYNTAX: {
                sb.append(" invalidDNSyntax\n");
                break;
            }
            case ALIAS_DEREFERENCING_PROBLEM: {
                sb.append(" aliasDereferencingProblem\n");
                break;
            }
            case INAPPROPRIATE_AUTHENTICATION: {
                sb.append(" inappropriateAuthentication\n");
                break;
            }
            case INVALID_CREDENTIALS: {
                sb.append(" invalidCredentials\n");
                break;
            }
            case INSUFFICIENT_ACCESS_RIGHTS: {
                sb.append(" insufficientAccessRights\n");
                break;
            }
            case BUSY: {
                sb.append(" busy\n");
                break;
            }
            case UNAVAILABLE: {
                sb.append(" unavailable\n");
                break;
            }
            case UNWILLING_TO_PERFORM: {
                sb.append(" unwillingToPerform\n");
                break;
            }
            case LOOP_DETECT: {
                sb.append(" loopDetect\n");
                break;
            }
            case NAMING_VIOLATION: {
                sb.append(" namingViolation\n");
                break;
            }
            case OBJECT_CLASS_VIOLATION: {
                sb.append(" objectClassViolation\n");
                break;
            }
            case NOT_ALLOWED_ON_NON_LEAF: {
                sb.append(" notAllowedOnNonLeaf\n");
                break;
            }
            case NOT_ALLOWED_ON_RDN: {
                sb.append(" notAllowedOnRDN\n");
                break;
            }
            case ENTRY_ALREADY_EXISTS: {
                sb.append(" entryAlreadyExists\n");
                break;
            }
            case OBJECT_CLASS_MODS_PROHIBITED: {
                sb.append(" objectClassModsProhibited\n");
                break;
            }
            case AFFECTS_MULTIPLE_DSAS: {
                sb.append(" affectsMultipleDSAs -- new\n");
                break;
            }
            case OTHER: {
                sb.append(" other\n");
                break;
            }
            default: {
                switch (this.resultCode.getResultCode()) {
                    case 9: {
                        sb.append(" -- 9 reserved --\n");
                        break block0;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: {
                        sb.append(" -- 22-31 unused --\n");
                        break block0;
                    }
                    case 35: {
                        sb.append(" -- 35 reserved for undefined isLeaf --\n");
                        break block0;
                    }
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: 
                    case 47: {
                        sb.append(" -- 37-47 unused --\n");
                        break block0;
                    }
                    case 55: 
                    case 56: 
                    case 57: 
                    case 58: 
                    case 59: 
                    case 60: 
                    case 61: 
                    case 62: 
                    case 63: {
                        sb.append(" -- 55-63 unused --\n");
                        break block0;
                    }
                    case 70: {
                        sb.append(" -- 70 reserved for CLDAP --\n");
                        break block0;
                    }
                    case 72: 
                    case 73: 
                    case 74: 
                    case 75: 
                    case 76: 
                    case 77: 
                    case 78: 
                    case 79: {
                        sb.append(" -- 72-79 unused --\n");
                        break block0;
                    }
                    case 81: 
                    case 82: 
                    case 83: 
                    case 84: 
                    case 85: 
                    case 86: 
                    case 87: 
                    case 88: 
                    case 89: 
                    case 90: {
                        sb.append(" -- 81-90 reserved for APIs --");
                        break block0;
                    }
                }
                sb.append("Unknown error code : ").append((Object)this.resultCode);
            }
        }
        sb.append("            Matched DN : '").append(this.matchedDN == null ? "" : this.matchedDN.toString()).append("'\n");
        sb.append("            Error message : '").append(this.errorMessage == null ? "" : this.errorMessage).append("'\n");
        if (this.referrals != null && this.referrals.size() != 0) {
            sb.append("            Referrals :\n");
            int i = 0;
            for (LdapURL referral : this.referrals) {
                sb.append("                Referral[").append(i++).append("] :").append(referral).append('\n');
            }
        }
        return sb.toString();
    }
}

