/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema.registries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.SyntaxCheckerRegistry;
import org.apache.directory.shared.asn1.primitives.OID;
import org.apache.directory.shared.ldap.schema.SyntaxChecker;
import org.apache.directory.shared.ldap.schema.parsers.SyntaxCheckerDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultSyntaxCheckerRegistry
implements SyntaxCheckerRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSyntaxCheckerRegistry.class);
    private final Map<String, SyntaxChecker> byOidSyntaxChecker = new ConcurrentHashMap<String, SyntaxChecker>();
    private final Map<String, SyntaxCheckerDescription> oidToDescription = new ConcurrentHashMap<String, SyntaxCheckerDescription>();

    @Override
    public void register(SyntaxCheckerDescription syntaxCheckerDescription, SyntaxChecker syntaxChecker) throws NamingException {
        String oid = syntaxChecker.getSyntaxOid();
        if (this.byOidSyntaxChecker.containsKey(oid)) {
            String msg = "SyntaxChecker with OID " + oid + " already registered!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        this.byOidSyntaxChecker.put(oid, syntaxChecker);
        this.oidToDescription.put(oid, syntaxCheckerDescription);
        if (LOG.isDebugEnabled()) {
            LOG.debug("registered syntaxChecher for OID {}", (Object)oid);
        }
    }

    @Override
    public SyntaxChecker lookup(String oid) throws NamingException {
        SyntaxChecker syntaxChecker = this.byOidSyntaxChecker.get(oid);
        if (syntaxChecker == null) {
            String msg = "SyntaxChecker for OID " + oid + " not found!";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("looked up syntaxChecher with OID {}", (Object)oid);
        }
        return syntaxChecker;
    }

    @Override
    public boolean hasSyntaxChecker(String oid) {
        return this.byOidSyntaxChecker.containsKey(oid);
    }

    @Override
    public String getSchemaName(String oid) throws NamingException {
        if (!OID.isOID(oid)) {
            String msg = "Looks like the arg is not a numeric OID";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        SyntaxCheckerDescription description = this.oidToDescription.get(oid);
        if (description != null) {
            return DefaultSyntaxCheckerRegistry.getSchema(description);
        }
        String msg = "OID " + oid + " not found in oid to schema name map!";
        LOG.warn(msg);
        throw new NamingException(msg);
    }

    private static String getSchema(SyntaxCheckerDescription desc) {
        List<String> ext = desc.getExtensions().get("X-SCHEMA");
        if (ext == null || ext.size() == 0) {
            return "other";
        }
        return ext.get(0);
    }

    @Override
    public Iterator<SyntaxChecker> iterator() {
        return this.byOidSyntaxChecker.values().iterator();
    }

    @Override
    public void unregister(String numericOid) throws NamingException {
        if (!OID.isOID(numericOid)) {
            String msg = "Looks like the arg is not a numeric OID";
            LOG.warn(msg);
            throw new NamingException(msg);
        }
        this.byOidSyntaxChecker.remove(numericOid);
        this.oidToDescription.remove(numericOid);
    }

    @Override
    public void unregisterSchemaElements(String schemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOidSyntaxChecker.keySet());
        for (String oid : oids) {
            SyntaxCheckerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultSyntaxCheckerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(schemaName)) continue;
            this.byOidSyntaxChecker.remove(oid);
            this.oidToDescription.remove(oid);
        }
    }

    @Override
    public void renameSchema(String originalSchemaName, String newSchemaName) {
        ArrayList<String> oids = new ArrayList<String>(this.byOidSyntaxChecker.keySet());
        for (String oid : oids) {
            SyntaxCheckerDescription description = this.oidToDescription.get(oid);
            String schemaNameForOid = DefaultSyntaxCheckerRegistry.getSchema(description);
            if (!schemaNameForOid.equalsIgnoreCase(originalSchemaName)) continue;
            List<String> values = description.getExtensions().get("X-SCHEMA");
            values.clear();
            values.add(newSchemaName);
        }
    }

    @Override
    public Iterator<SyntaxCheckerDescription> syntaxCheckerDescriptionIterator() {
        return this.oidToDescription.values().iterator();
    }
}

