/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import java.util.Comparator;
import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.name.LdapDN;

public class NameAndOptionalUIDComparator
implements Comparator {
    private AttributeTypeRegistry attrRegistry;

    public NameAndOptionalUIDComparator(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public NameAndOptionalUIDComparator() {
    }

    public void setRegistries(Registries registries) {
        this.attrRegistry = registries.getAttributeTypeRegistry();
    }

    public int compare(Object obj0, Object obj1) {
        String dnstr0 = null;
        String dnstr1 = null;
        if (obj0 instanceof String && obj1 instanceof String) {
            dnstr0 = (String)obj0;
            dnstr1 = (String)obj1;
            int dash0 = dnstr0.lastIndexOf(35);
            int dash1 = dnstr1.lastIndexOf(35);
            if (dash0 == -1 && dash1 == -1) {
                try {
                    return this.getDn(dnstr0).compareTo(this.getDn(dnstr1));
                }
                catch (NamingException ne) {
                    return -1;
                }
            }
            if (dnstr0.indexOf(35) != dash0) {
                return -1;
            }
            if (dnstr1.indexOf(35) != dash0) {
                return 1;
            }
            LdapDN dn0 = null;
            LdapDN dn1 = null;
            String uid0 = dnstr0.substring(dash0 + 1);
            if (dash0 > 0) {
                try {
                    dn0 = new LdapDN(dnstr0.substring(0, dash0));
                }
                catch (NamingException ne) {
                    return -1;
                }
            } else {
                return -1;
            }
            String uid1 = dnstr1.substring(dash1 + 1);
            if (dash1 > 0) {
                try {
                    dn1 = new LdapDN(dnstr0.substring(0, dash1));
                }
                catch (NamingException ne) {
                    return 1;
                }
            } else {
                return 1;
            }
            int dnComp = dn0.compareTo(dn1);
            if (dnComp != 0) {
                return dnComp;
            }
            return uid0.compareTo(uid1);
        }
        return -1;
    }

    public LdapDN getDn(Object obj) throws NamingException {
        LdapDN dn = null;
        if (obj instanceof LdapDN) {
            dn = (LdapDN)obj;
            dn = dn.isNormalized() ? dn : LdapDN.normalize(dn, this.attrRegistry.getNormalizerMapping());
        } else if (obj instanceof Name) {
            dn = new LdapDN((Name)obj);
            dn.normalize(this.attrRegistry.getNormalizerMapping());
        } else if (obj instanceof String) {
            dn = new LdapDN((String)obj);
            dn.normalize(this.attrRegistry.getNormalizerMapping());
        } else {
            throw new IllegalStateException("I do not know how to handle dn comparisons with objects of class: " + (obj == null ? null : obj.getClass()));
        }
        return dn;
    }
}

