/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.io.encoder;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.directory.server.kerberos.shared.messages.value.EncryptedData;
import org.apache.directory.shared.asn1.der.ASN1OutputStream;
import org.apache.directory.shared.asn1.der.DERInteger;
import org.apache.directory.shared.asn1.der.DEROctetString;
import org.apache.directory.shared.asn1.der.DERSequence;
import org.apache.directory.shared.asn1.der.DERTaggedObject;

public class EncryptedDataEncoder {
    public static byte[] encode(EncryptedData encryptedData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ASN1OutputStream aos = new ASN1OutputStream(baos);
        aos.writeObject(EncryptedDataEncoder.encodeSequence(encryptedData));
        aos.close();
        return baos.toByteArray();
    }

    public static DERSequence encodeSequence(EncryptedData encryptedData) {
        DERSequence sequence = new DERSequence();
        sequence.add(new DERTaggedObject(0, DERInteger.valueOf(encryptedData.getEType().getOrdinal())));
        if (encryptedData.hasKvno()) {
            sequence.add(new DERTaggedObject(1, DERInteger.valueOf(encryptedData.getKvno())));
        }
        sequence.add(new DERTaggedObject(2, new DEROctetString(encryptedData.getCipher())));
        return sequence;
    }
}

