/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NotImplementedException;
import org.apache.directory.server.core.CoreSession;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.core.security.TlsKeyGenerator;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.util.SingletonEnumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreKeyStoreSpi
extends KeyStoreSpi {
    private static final String APACHEDS_ALIAS = "apacheds";
    private static final Logger LOG = LoggerFactory.getLogger(CoreKeyStoreSpi.class);
    private DirectoryService directoryService;

    public CoreKeyStoreSpi(DirectoryService directoryService) {
        LOG.debug("Constructor called.");
        this.directoryService = directoryService;
    }

    private ServerEntry getTlsEntry() throws Exception {
        LdapDN adminDn = PartitionNexus.getAdminName();
        LdapPrincipal principal = new LdapPrincipal(adminDn, AuthenticationLevel.SIMPLE);
        CoreSession session = this.directoryService.getSession(principal);
        return session.lookup(adminDn);
    }

    @Override
    public Enumeration<String> engineAliases() {
        LOG.debug("engineAliases() called.");
        return new SingletonEnumeration<String>(APACHEDS_ALIAS);
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        LOG.debug("engineContainsAlias({}) called.", (Object)alias);
        return alias.equalsIgnoreCase(APACHEDS_ALIAS);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        LOG.debug("engineDeleteEntry({}) called.", (Object)alias);
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        LOG.debug("engineGetCertificate({}) called.", (Object)alias);
        if (alias.equalsIgnoreCase(APACHEDS_ALIAS)) {
            try {
                ServerEntry entry = this.getTlsEntry();
                return TlsKeyGenerator.getCertificate(entry);
            }
            catch (Exception e) {
                LOG.error("Failed to access certificate in DIT.", e);
            }
        }
        return null;
    }

    @Override
    public String engineGetCertificateAlias(Certificate cert) {
        LOG.debug("engineGetCertificateAlias({}) called.", cert);
        if (cert instanceof X509Certificate) {
            LOG.debug("Certificate in alias request is X.509 based.");
            X509Certificate xcert = (X509Certificate)cert;
            if (((Object)xcert.getSubjectDN()).toString().equals("CN=ApacheDS, OU=Directory, O=ASF, C=US")) {
                return APACHEDS_ALIAS;
            }
        }
        try {
            ServerEntry entry = this.getTlsEntry();
            if (ArrayUtils.isEquals(cert.getEncoded(), entry.get("userCertificate").getBytes())) {
                return APACHEDS_ALIAS;
            }
        }
        catch (Exception e) {
            LOG.error("Failed on attempt to compare certificate bytes to determine alias.", e);
        }
        return null;
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        LOG.debug("engineGetCertificateChain({}) called.", (Object)alias);
        try {
            ServerEntry entry = this.getTlsEntry();
            LOG.debug("Entry:\n{}", entry);
            return new Certificate[]{TlsKeyGenerator.getCertificate(entry)};
        }
        catch (Exception e) {
            LOG.error("Failed on attempt to compare certificate bytes to determine alias.", e);
            return new Certificate[0];
        }
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        LOG.debug("engineGetCreationDate({}) called.", (Object)alias);
        return new Date();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        LOG.debug("engineGetKey({}, {}) called.", (Object)alias, (Object)password);
        try {
            ServerEntry entry = this.getTlsEntry();
            KeyPair keyPair = TlsKeyGenerator.getKeyPair(entry);
            return keyPair.getPrivate();
        }
        catch (Exception e) {
            LOG.error("Failed on attempt to extract key.", e);
            return null;
        }
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        LOG.debug("engineIsCertificateEntry({}) called.", (Object)alias);
        return false;
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        LOG.debug("engineIsKeyEntry({}) called.", (Object)alias);
        return true;
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug("engineLoad({}, {}) called.", stream, (Object)password);
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        LOG.debug("engineSetCertificateEntry({}, {}) called.", (Object)alias, (Object)cert);
        throw new NotImplementedException();
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        LOG.debug("engineSetKeyEntry({}, key, {}) called.", (Object)alias, (Object)chain);
        throw new NotImplementedException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        LOG.debug("engineSetKeyEntry({}, key, {}, chain) called.", (Object)alias, (Object)new String(password));
        throw new NotImplementedException();
    }

    @Override
    public int engineSize() {
        LOG.debug("engineSize() called.");
        return 1;
    }

    @Override
    public void engineStore(OutputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        LOG.debug("engineStore(stream, {}) called.", (Object)new String(password));
    }
}

