/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.security.cert.CertPathValidatorException;
import java.util.HashSet;
import java.util.Set;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralSubtree;

public class PKIXNameConstraints {
    private Set permittedSubtreesDN = new HashSet();
    private Set excludedSubtreesDN = new HashSet();
    private Set permittedSubtreesEmail = new HashSet();
    private Set permittedSubtreesIP = new HashSet();
    private Set excludedSubtreesEmail = new HashSet();
    private Set excludedSubtreesIP = new HashSet();

    private static boolean withinDNSubtree(ASN1Sequence aSN1Sequence, ASN1Sequence aSN1Sequence2) {
        if (aSN1Sequence2.size() < 1) {
            return false;
        }
        if (aSN1Sequence2.size() > aSN1Sequence.size()) {
            return false;
        }
        for (int i = aSN1Sequence2.size() - 1; i >= 0; --i) {
            if (aSN1Sequence2.getObjectAt(i).equals(aSN1Sequence.getObjectAt(i))) continue;
            return false;
        }
        return true;
    }

    public void checkPermittedDN(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        this.checkPermittedDN(this.permittedSubtreesDN, aSN1Sequence);
    }

    public void checkExcludedDN(ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        this.checkPermittedDN(this.excludedSubtreesDN, aSN1Sequence);
    }

    private void checkPermittedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!PKIXNameConstraints.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject distinguished name is not from a permitted subtree");
    }

    private void checkExcludedDN(Set set, ASN1Sequence aSN1Sequence) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (!PKIXNameConstraints.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) continue;
            throw new CertPathValidatorException("Subject distinguished name is from an excluded subtree");
        }
    }

    private Set intersectDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (PKIXNameConstraints.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            if (!PKIXNameConstraints.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) continue;
            hashSet.add(aSN1Sequence2);
        }
        return hashSet;
    }

    private Set unionDN(Set set, ASN1Sequence aSN1Sequence) {
        if (set.isEmpty()) {
            set.add(aSN1Sequence);
            return set;
        }
        HashSet<ASN1Sequence> hashSet = new HashSet<ASN1Sequence>();
        for (ASN1Sequence aSN1Sequence2 : set) {
            if (PKIXNameConstraints.withinDNSubtree(aSN1Sequence, aSN1Sequence2)) {
                hashSet.add(aSN1Sequence2);
                continue;
            }
            if (PKIXNameConstraints.withinDNSubtree(aSN1Sequence2, aSN1Sequence)) {
                hashSet.add(aSN1Sequence);
                continue;
            }
            hashSet.add(aSN1Sequence2);
            hashSet.add(aSN1Sequence);
        }
        return hashSet;
    }

    private Set intersectEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string2);
                continue;
            }
            if (!string3.endsWith(string2)) continue;
            hashSet.add(string3);
        }
        return hashSet;
    }

    private Set unionEmail(Set set, String string) {
        String string2 = string.substring(string.indexOf(64) + 1);
        if (set.isEmpty()) {
            set.add(string2);
            return set;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (String string3 : set) {
            if (string2.endsWith(string3)) {
                hashSet.add(string3);
                continue;
            }
            if (string3.endsWith(string2)) {
                hashSet.add(string2);
                continue;
            }
            hashSet.add(string3);
            hashSet.add(string2);
        }
        return hashSet;
    }

    private Set intersectIP(Set set, byte[] byArray) {
        return set;
    }

    private Set unionIP(Set set, byte[] byArray) {
        return set;
    }

    private void checkPermittedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            return;
        }
        throw new CertPathValidatorException("Subject email address is not from a permitted subtree");
    }

    private void checkExcludedEmail(Set set, String string) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
        String string2 = string.substring(string.indexOf(64) + 1);
        for (String string3 : set) {
            if (!string2.endsWith(string3)) continue;
            throw new CertPathValidatorException("Subject email address is from an excluded subtree");
        }
    }

    private void checkPermittedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    private void checkExcludedIP(Set set, byte[] byArray) throws CertPathValidatorException {
        if (set.isEmpty()) {
            return;
        }
    }

    public void checkPermitted(GeneralName generalName) throws CertPathValidatorException {
        switch (generalName.getTagNo()) {
            case 1: {
                String string = DERIA5String.getInstance(generalName.getName()).getString();
                this.checkPermittedEmail(this.permittedSubtreesEmail, string);
                break;
            }
            case 4: {
                this.checkPermittedDN(ASN1Sequence.getInstance(generalName.getName()));
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                this.checkPermittedIP(this.permittedSubtreesIP, byArray);
            }
        }
    }

    public void checkExcluded(GeneralName generalName) throws CertPathValidatorException {
        switch (generalName.getTagNo()) {
            case 1: {
                String string = DERIA5String.getInstance(generalName.getName()).getString();
                this.checkExcludedEmail(this.excludedSubtreesEmail, string);
                break;
            }
            case 4: {
                this.checkExcludedDN(ASN1Sequence.getInstance(generalName.getName()));
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                this.checkExcludedIP(this.excludedSubtreesIP, byArray);
            }
        }
    }

    public void intersectPermittedSubtree(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getBase();
        switch (generalName.getTagNo()) {
            case 1: {
                String string = DERIA5String.getInstance(generalName.getName()).getString();
                this.intersectEmail(this.permittedSubtreesEmail, string);
                break;
            }
            case 4: {
                this.intersectDN(this.permittedSubtreesDN, ASN1Sequence.getInstance(generalName.getName()));
                break;
            }
            case 7: {
                byte[] byArray = ASN1OctetString.getInstance(generalName.getName()).getOctets();
                this.intersectIP(this.permittedSubtreesIP, byArray);
            }
        }
    }

    public void addExcludedSubtree(GeneralSubtree generalSubtree) {
        GeneralName generalName = generalSubtree.getBase();
        switch (generalName.getTagNo()) {
            case 1: {
                this.excludedSubtreesEmail = this.unionEmail(this.excludedSubtreesEmail, DERIA5String.getInstance(generalName.getName()).getString());
                break;
            }
            case 4: {
                this.excludedSubtreesDN = this.unionDN(this.excludedSubtreesDN, (ASN1Sequence)generalName.getName());
                break;
            }
            case 7: {
                this.excludedSubtreesIP = this.unionIP(this.excludedSubtreesIP, ASN1OctetString.getInstance(generalName.getName()).getOctets());
            }
        }
    }
}

