/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.schema.syntax;

import org.apache.directory.shared.ldap.schema.syntax.AbstractSyntaxChecker;
import org.apache.directory.shared.ldap.util.StringTools;

public class NumericStringSyntaxChecker
extends AbstractSyntaxChecker {
    private static final String SC_OID = "1.3.6.1.4.1.1466.115.121.1.36";

    public NumericStringSyntaxChecker() {
        super(SC_OID);
    }

    protected NumericStringSyntaxChecker(String oid) {
        super(oid);
    }

    public boolean isValidSyntax(Object value) {
        String strValue = null;
        if (value == null) {
            return false;
        }
        strValue = value instanceof String ? (String)value : (value instanceof byte[] ? StringTools.utf8ToString((byte[])value) : value.toString());
        if (strValue.length() == 0) {
            return false;
        }
        block3: for (int i = 0; i < strValue.length(); ++i) {
            switch (strValue.charAt(i)) {
                case ' ': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block3;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }
}

