/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.codec.search;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.directory.shared.asn1.ber.tlv.TLV;
import org.apache.directory.shared.asn1.codec.EncoderException;
import org.apache.directory.shared.ldap.codec.search.Filter;
import org.apache.directory.shared.ldap.util.StringTools;

public class PresentFilter
extends Filter {
    private String attributeDescription;
    private byte[] attributeDescriptionBytes;

    public PresentFilter(int tlvId) {
        super(tlvId);
    }

    public PresentFilter() {
    }

    public String getAttributeDescription() {
        return this.attributeDescription;
    }

    public void setAttributeDescription(String attributeDescription) {
        this.attributeDescription = attributeDescription;
    }

    public int computeLength() {
        this.attributeDescriptionBytes = StringTools.getBytesUtf8(this.attributeDescription);
        return 1 + TLV.getNbBytes(this.attributeDescriptionBytes.length) + this.attributeDescriptionBytes.length;
    }

    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException("Cannot put a PDU in a null buffer !");
        }
        try {
            buffer.put((byte)-121);
            buffer.put(TLV.getBytes(this.attributeDescriptionBytes.length));
            buffer.put(this.attributeDescriptionBytes);
        }
        catch (BufferOverflowException boe) {
            throw new EncoderException("The PDU buffer size is too small !");
        }
        super.encode(buffer);
        return buffer;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.attributeDescription).append("=*");
        return sb.toString();
    }
}

