/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.xdbm.search.impl;

import java.util.Iterator;
import org.apache.directory.server.core.entry.ServerAttribute;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.server.xdbm.Index;
import org.apache.directory.server.xdbm.IndexEntry;
import org.apache.directory.server.xdbm.Store;
import org.apache.directory.server.xdbm.search.Evaluator;
import org.apache.directory.shared.ldap.filter.PresenceNode;
import org.apache.directory.shared.ldap.schema.AttributeType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PresenceEvaluator
implements Evaluator<PresenceNode, ServerEntry> {
    private final PresenceNode node;
    private final Store<ServerEntry> db;
    private final Registries registries;
    private final AttributeType type;
    private final Index<String, ServerEntry> idx;

    public PresenceEvaluator(PresenceNode node, Store<ServerEntry> db, Registries registries) throws Exception {
        this.db = db;
        this.node = node;
        this.registries = registries;
        this.type = registries.getAttributeTypeRegistry().lookup(node.getAttribute());
        this.idx = db.hasUserIndexOn(node.getAttribute()) ? db.getPresenceIndex() : null;
    }

    @Override
    public PresenceNode getExpression() {
        return this.node;
    }

    public AttributeType getAttributeType() {
        return this.type;
    }

    @Override
    public boolean evaluate(IndexEntry<?, ServerEntry> indexEntry) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.type.getOid(), indexEntry.getId());
        }
        ServerEntry entry = indexEntry.getObject();
        if (null == entry) {
            entry = this.db.lookup(indexEntry.getId());
            indexEntry.setObject(entry);
        }
        return this.evaluate(entry);
    }

    @Override
    public boolean evaluate(Long id) throws Exception {
        if (this.idx != null) {
            return this.idx.forward(this.type.getOid(), id);
        }
        return this.evaluate(this.db.lookup(id));
    }

    @Override
    public boolean evaluate(ServerEntry entry) throws Exception {
        ServerAttribute attr = (ServerAttribute)entry.get(this.type);
        if (attr != null) {
            return true;
        }
        if (this.registries.getAttributeTypeRegistry().hasDescendants(this.node.getAttribute())) {
            Iterator<AttributeType> descendants = this.registries.getAttributeTypeRegistry().descendants(this.node.getAttribute());
            do {
                AttributeType descendant;
                if ((attr = (ServerAttribute)entry.get(descendant = descendants.next())) == null) continue;
                return true;
            } while (descendants.hasNext());
        }
        return false;
    }
}

