/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.schema;

import javax.naming.Name;
import javax.naming.NamingException;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.server.schema.registries.Registries;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.Normalizer;

public class DnNormalizer
implements Normalizer {
    private static final long serialVersionUID = 1L;
    private AttributeTypeRegistry attrRegistry;

    public DnNormalizer(AttributeTypeRegistry attrRegistry) {
        this.attrRegistry = attrRegistry;
    }

    public DnNormalizer() {
    }

    public void setRegistries(Registries registries) {
        this.attrRegistry = registries.getAttributeTypeRegistry();
    }

    public Object normalize(Object value) throws NamingException {
        LdapDN dn = null;
        if (value instanceof LdapDN) {
            dn = (LdapDN)((LdapDN)value).clone();
        } else if (value instanceof Name) {
            dn = new LdapDN((Name)value);
        } else if (value instanceof String) {
            dn = new LdapDN((String)value);
        } else {
            throw new IllegalStateException("I do not know how to handle dn normalization with objects of class: " + (value == null ? null : value.getClass()));
        }
        dn.normalize(this.attrRegistry.getNormalizerMapping());
        return dn.getNormName();
    }
}

