/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.ldap.handlers;

import org.apache.directory.server.core.event.DirectoryListener;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.ldap.LdapService;
import org.apache.directory.shared.ldap.exception.OperationAbandonedException;
import org.apache.directory.shared.ldap.message.AbandonListener;
import org.apache.directory.shared.ldap.message.AbandonableRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchAbandonListener
implements AbandonListener {
    private static final Logger LOG = LoggerFactory.getLogger(SearchAbandonListener.class);
    private final LdapService ldapService;
    private EntryFilteringCursor cursor;
    private DirectoryListener listener;

    public SearchAbandonListener(LdapService ldapService, EntryFilteringCursor cursor, DirectoryListener listener) {
        if (ldapService == null) {
            throw new NullPointerException("ldapService");
        }
        this.ldapService = ldapService;
        this.cursor = cursor;
        this.listener = listener;
    }

    public SearchAbandonListener(LdapService ldapService, DirectoryListener listener) {
        this(ldapService, null, listener);
    }

    public SearchAbandonListener(LdapService ldapService, EntryFilteringCursor cursor) {
        this(ldapService, cursor, null);
    }

    public void requestAbandoned(AbandonableRequest req) {
        if (this.listener != null) {
            this.ldapService.getDirectoryService().getEventService().removeListener(this.listener);
        }
        try {
            if (this.cursor != null) {
                this.cursor.close(new OperationAbandonedException());
            }
        }
        catch (Exception e) {
            LOG.error("Failed to close the search cursor for message {} on abandon request.", req.getMessageId(), (Object)e);
        }
    }
}

