/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SamType
implements Comparable<SamType> {
    public static final SamType PA_SAM_TYPE_ENIGMA = new SamType(1, "Enigma Logic");
    public static final SamType PA_SAM_TYPE_DIGI_PATH = new SamType(2, "Digital Pathways");
    public static final SamType PA_SAM_TYPE_SKEY_K0 = new SamType(3, "S/key where KDC has key 0");
    public static final SamType PA_SAM_TYPE_SKEY = new SamType(4, "Traditional S/Key");
    public static final SamType PA_SAM_TYPE_SECURID = new SamType(5, "Security Dynamics");
    public static final SamType PA_SAM_TYPE_CRYPTOCARD = new SamType(6, "CRYPTOCard");
    public static final SamType PA_SAM_TYPE_APACHE = new SamType(7, "Apache Software Foundation");
    private static final SamType[] values = new SamType[]{PA_SAM_TYPE_ENIGMA, PA_SAM_TYPE_DIGI_PATH, PA_SAM_TYPE_SKEY_K0, PA_SAM_TYPE_SKEY, PA_SAM_TYPE_SECURID, PA_SAM_TYPE_CRYPTOCARD, PA_SAM_TYPE_APACHE};
    public static final List<SamType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private SamType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(SamType that) {
        return this.ordinal - that.ordinal;
    }

    public static SamType getTypeByOrdinal(int ordinal) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (SamType.values[ii].ordinal != ordinal) continue;
            return values[ii];
        }
        return PA_SAM_TYPE_APACHE;
    }

    public int getOrdinal() {
        return this.ordinal;
    }
}

