/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.keytab;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.directory.server.kerberos.shared.keytab.KeytabDecoder;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEncoder;
import org.apache.directory.server.kerberos.shared.keytab.KeytabEntry;
import org.apache.mina.common.ByteBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Keytab {
    public static final byte[] VERSION_51 = new byte[]{5, 1};
    public static final byte[] VERSION_52 = new byte[]{5, 2};
    private byte[] keytabVersion = VERSION_52;
    private List<KeytabEntry> entries = new ArrayList<KeytabEntry>();

    public static Keytab read(File file) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(Keytab.getBytesFromFile(file));
        return Keytab.readKeytab(buffer);
    }

    public static Keytab getInstance() {
        return new Keytab();
    }

    public void write(File file) throws IOException {
        KeytabEncoder writer = new KeytabEncoder();
        ByteBuffer buffer = writer.write(this.keytabVersion, this.entries);
        this.writeFile(buffer, file);
    }

    public void setEntries(List<KeytabEntry> entries) {
        this.entries = entries;
    }

    public void setKeytabVersion(byte[] keytabVersion) {
        this.keytabVersion = keytabVersion;
    }

    public List<KeytabEntry> getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public byte[] getKeytabVersion() {
        return this.keytabVersion;
    }

    static Keytab read(byte[] bytes) {
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return Keytab.readKeytab(buffer);
    }

    ByteBuffer write() {
        KeytabEncoder writer = new KeytabEncoder();
        return writer.write(this.keytabVersion, this.entries);
    }

    private static Keytab readKeytab(ByteBuffer buffer) {
        KeytabDecoder reader = new KeytabDecoder();
        byte[] keytabVersion = reader.getKeytabVersion(buffer);
        List<KeytabEntry> entries = reader.getKeytabEntries(buffer);
        Keytab keytab = new Keytab();
        keytab.setKeytabVersion(keytabVersion);
        keytab.setEntries(entries);
        return keytab;
    }

    protected static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File is too large " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    protected void writeFile(ByteBuffer buffer, File file) throws IOException {
        FileChannel wChannel = new FileOutputStream(file, false).getChannel();
        wChannel.write(buffer.buf());
        wChannel.close();
    }
}

