/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core;

import java.net.SocketAddress;
import java.util.List;
import java.util.Set;
import javax.naming.ldap.Control;
import org.apache.directory.server.core.DirectoryService;
import org.apache.directory.server.core.ReferralHandlingMode;
import org.apache.directory.server.core.authn.LdapPrincipal;
import org.apache.directory.server.core.entry.ClonedServerEntry;
import org.apache.directory.server.core.entry.ServerEntry;
import org.apache.directory.server.core.filtering.EntryFilteringCursor;
import org.apache.directory.server.core.interceptor.context.OperationContext;
import org.apache.directory.shared.ldap.constants.AuthenticationLevel;
import org.apache.directory.shared.ldap.entry.Modification;
import org.apache.directory.shared.ldap.filter.ExprNode;
import org.apache.directory.shared.ldap.filter.SearchScope;
import org.apache.directory.shared.ldap.message.AddRequest;
import org.apache.directory.shared.ldap.message.AliasDerefMode;
import org.apache.directory.shared.ldap.message.CompareRequest;
import org.apache.directory.shared.ldap.message.DeleteRequest;
import org.apache.directory.shared.ldap.message.ModifyDnRequest;
import org.apache.directory.shared.ldap.message.ModifyRequest;
import org.apache.directory.shared.ldap.message.SearchRequest;
import org.apache.directory.shared.ldap.message.UnbindRequest;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.name.Rdn;
import org.apache.directory.shared.ldap.schema.AttributeTypeOptions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface CoreSession {
    public DirectoryService getDirectoryService();

    public LdapPrincipal getAuthenticatedPrincipal();

    public LdapPrincipal getEffectivePrincipal();

    public boolean isConfidential();

    public boolean isAnonymous();

    public boolean isAdministrator();

    public boolean isAnAdministrator();

    public AuthenticationLevel getAuthenticationLevel();

    public Set<Control> getControls();

    public Set<OperationContext> getOutstandingOperations();

    public boolean isVirtual();

    public SocketAddress getClientAddress();

    public SocketAddress getServiceAddress();

    public void add(ServerEntry var1) throws Exception;

    public void add(AddRequest var1) throws Exception;

    public void compare(LdapDN var1, String var2, Object var3) throws Exception;

    public boolean compare(CompareRequest var1) throws Exception;

    public void delete(LdapDN var1) throws Exception;

    public void delete(DeleteRequest var1) throws Exception;

    public boolean exists(LdapDN var1) throws Exception;

    public ClonedServerEntry lookup(LdapDN var1) throws Exception;

    public ClonedServerEntry lookup(LdapDN var1, String[] var2) throws Exception;

    public ClonedServerEntry lookup(LdapDN var1, Control[] var2, ReferralHandlingMode var3, LdapDN var4) throws Exception;

    public void modify(LdapDN var1, List<Modification> var2) throws Exception;

    public void modify(ModifyRequest var1) throws Exception;

    public void move(LdapDN var1, LdapDN var2) throws Exception;

    public void move(ModifyDnRequest var1) throws Exception;

    public void moveAndRename(LdapDN var1, LdapDN var2, Rdn var3, boolean var4) throws Exception;

    public void moveAndRename(ModifyDnRequest var1) throws Exception;

    public void rename(LdapDN var1, Rdn var2, boolean var3) throws Exception;

    public void rename(ModifyDnRequest var1) throws Exception;

    public EntryFilteringCursor list(LdapDN var1, AliasDerefMode var2, Set<AttributeTypeOptions> var3) throws Exception;

    public EntryFilteringCursor list(LdapDN var1, AliasDerefMode var2, Set<AttributeTypeOptions> var3, int var4, int var5) throws Exception;

    public EntryFilteringCursor search(LdapDN var1, SearchScope var2, ExprNode var3, AliasDerefMode var4, Set<AttributeTypeOptions> var5) throws Exception;

    public EntryFilteringCursor search(LdapDN var1, SearchScope var2, ExprNode var3, AliasDerefMode var4, Set<AttributeTypeOptions> var5, int var6, int var7) throws Exception;

    public EntryFilteringCursor search(SearchRequest var1) throws Exception;

    public void unbind() throws Exception;

    public void unbind(UnbindRequest var1) throws Exception;
}

